/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.baos.ip;

import java.nio.ByteBuffer;
import java.util.Optional;
import tuwien.auto.calimero.knxnetip.Discoverer;
import tuwien.auto.calimero.knxnetip.servicetype.SearchResponse;
import tuwien.auto.calimero.knxnetip.util.ManufacturerDIB;

public final class BaosIp {
    private static final int ObjectServerProtocol = 240;
    private static final int WeinzierlMfrId = 197;
    private static final int Version = 32;

    public static boolean supportsBaos(Discoverer.Result<SearchResponse> result) {
        Optional<ManufacturerDIB> mfrDib = result.getResponse().description().stream().filter(ManufacturerDIB.class::isInstance).map(ManufacturerDIB.class::cast).filter(dib -> dib.getStructLength() == 8).findFirst();
        if (mfrDib.isEmpty()) {
            return false;
        }
        ByteBuffer buf = ByteBuffer.wrap(mfrDib.get().getData());
        return buf.getShort() == 197 && buf.get() == 1 && buf.get() == 4 && (buf.get() & 0xFF) == 240 && buf.get() == 32;
    }

    private BaosIp() {
    }
}

