/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.baos.ip;

import java.net.InetSocketAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.baos.BaosLink;
import tuwien.auto.calimero.baos.BaosService;
import tuwien.auto.calimero.baos.ip.ObjectServerConnection;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.knxnetip.KNXConnectionClosedException;
import tuwien.auto.calimero.knxnetip.KNXnetIPConnection;
import tuwien.auto.calimero.knxnetip.TcpConnection;
import tuwien.auto.calimero.link.AbstractLink;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.medium.TPSettings;

public final class BaosLinkIp
extends AbstractLink<ObjectServerConnection>
implements BaosLink {
    private final ObjectServerConnection c;

    public static BaosLink newUdpLink(InetSocketAddress localEp, InetSocketAddress serverCtrlEp) throws KNXException, InterruptedException {
        ObjectServerConnection c = new ObjectServerConnection(localEp, serverCtrlEp);
        return new BaosLinkIp(c);
    }

    public static BaosLink newTcpLink(TcpConnection connection) throws KNXException {
        ObjectServerConnection c = new ObjectServerConnection(connection);
        return new BaosLinkIp(c);
    }

    BaosLinkIp(ObjectServerConnection c) {
        super(c, c.name(), new TPSettings());
        this.c = c;
        this.notifier.registerEventType(BaosService.class);
        c.addConnectionListener(this.notifier);
        c.addConnectionListener(this::dispatchCustomEvent);
    }

    @Override
    public void send(BaosService service) throws KNXTimeoutException, KNXLinkClosedException {
        try {
            this.c.send(service, KNXnetIPConnection.BlockingMode.WaitForAck);
        }
        catch (KNXConnectionClosedException e) {
            throw new KNXLinkClosedException("link closed, " + e.getMessage());
        }
    }

    @Override
    protected void onSend(KNXAddress dst, byte[] msg, boolean waitForCon) {
        throw new UnsupportedOperationException("object server protocol does not support cEMI");
    }

    @Override
    protected void onSend(CEMILData msg, boolean waitForCon) {
        throw new UnsupportedOperationException("object server protocol does not support cEMI");
    }

    private void dispatchCustomEvent(BaosService event) {
        this.notifier.dispatchCustomEvent(event);
    }
}

