/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.baos.ip;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXListener;
import tuwien.auto.calimero.KnxRuntimeException;
import tuwien.auto.calimero.baos.BaosService;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.knxnetip.ClientConnection;
import tuwien.auto.calimero.knxnetip.KNXConnectionClosedException;
import tuwien.auto.calimero.knxnetip.KNXnetIPConnection;
import tuwien.auto.calimero.knxnetip.TcpConnection;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.knxnetip.servicetype.PacketHelper;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceAck;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceRequest;
import tuwien.auto.calimero.knxnetip.util.CRI;
import tuwien.auto.calimero.log.LogService;

class ObjectServerConnection
extends ClientConnection {
    private static final int ObjectServerProtocol = 240;
    private static final int ProtocolVersion = 32;
    private static final int ReqTimeout = 1;
    private final boolean tcp;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final Future<?> keepAlive;

    ObjectServerConnection(InetSocketAddress localEP, InetSocketAddress serverCtrlEP) throws KNXException, InterruptedException {
        super(61568, 61569, 2, 1);
        this.tcp = false;
        this.keepAlive = CompletableFuture.completedFuture(Void.TYPE);
        this.connect(localEP, serverCtrlEP, CRI.createRequest(240, new byte[0]), false);
    }

    ObjectServerConnection(TcpConnection c) throws KNXException {
        super(61568, 61569, 1, 1, c);
        this.ctrlEndpt = c.server();
        this.logger = LogService.getLogger("calimero.baos." + this.name());
        this.tcp = true;
        try {
            c.connect();
        }
        catch (IOException e) {
            throw new KNXException("connecting " + c, e);
        }
        this.setState(0);
        this.keepAlive = this.scheduler.scheduleAtFixedRate(this::sendKeepAlive, 2L, 60L, TimeUnit.SECONDS);
        c.registerConnection(this);
    }

    @Override
    public void send(CEMI frame, KNXnetIPConnection.BlockingMode mode) {
        throw new UnsupportedOperationException("object server protocol does not support cEMI");
    }

    public void send(BaosService svc, KNXnetIPConnection.BlockingMode mode) throws KNXConnectionClosedException {
        if (mode == KNXnetIPConnection.BlockingMode.WaitForCon) {
            throw new KNXIllegalArgumentException((Object)((Object)mode) + " is not supported");
        }
        try {
            int chid = this.tcp ? 0 : this.channelId;
            int seq = this.tcp ? 0 : this.getSeqSend();
            byte[] buf = PacketHelper.toPacket(new ServiceRequest<BaosService>(this.serviceRequest, chid, seq, svc));
            this.send(buf, this.dataEndpt);
        }
        catch (IOException e) {
            this.close(3, "communication failure", LogService.LogLevel.ERROR, e);
            throw new KNXConnectionClosedException("connection closed", e);
        }
    }

    @Override
    public String getName() {
        return "KNX IP ObjectServer " + super.name();
    }

    @Override
    protected boolean handleServiceType(KNXnetIPHeader h, byte[] data, int offset, InetAddress src, int port) throws KNXFormatException, IOException {
        BaosService objSvrService;
        if (super.handleServiceType(h, data, offset, src, port)) {
            return true;
        }
        int svc = h.getServiceType();
        if (svc < this.serviceRequest || svc > this.serviceAck) {
            return false;
        }
        Function<ByteBuffer, BaosService> objectServerParser = buf -> {
            try {
                return BaosService.from(buf);
            }
            catch (KNXFormatException e) {
                throw new KnxRuntimeException("parsing BAOS service", e);
            }
        };
        ServiceRequest<BaosService> req = ServiceRequest.from(h, data, offset, objectServerParser);
        if (!this.checkChannelId(req.getChannelID(), "request")) {
            return true;
        }
        if (!this.tcp) {
            boolean repeated;
            int seq = req.getSequenceNumber();
            boolean expected = seq == this.getSeqRcv();
            boolean bl = repeated = (seq + 1 & 0xFF) == this.getSeqRcv();
            if (expected || repeated) {
                int status = h.getVersion() == 32 ? 0 : 2;
                byte[] buf2 = PacketHelper.toPacket(new ServiceAck(this.serviceAck, this.channelId, seq, status));
                this.send(buf2, this.dataEndpt);
                if (status == 2) {
                    this.close(3, "protocol version changed", LogService.LogLevel.ERROR, null);
                    return true;
                }
            } else {
                this.logger.warn("object server request with invalid rcv-seq {}, expected {}", (Object)seq, (Object)this.getSeqRcv());
                return true;
            }
            if (repeated) {
                this.logger.debug("skip object server request with rcv-seq {} (already received)", (Object)seq);
                return true;
            }
            this.incSeqRcv();
        }
        if ((objSvrService = (BaosService)req.service()).isResponse() || objSvrService.subService() == 193 || objSvrService.subService() == 194) {
            this.logger.trace("received request seq {} (channel {}) svc {}", new Object[]{req.getSequenceNumber(), this.channelId, objSvrService});
            this.fireFrameReceived(objSvrService);
        } else {
            this.logger.warn("received object server request - ignore {}", (Object)objSvrService);
        }
        return true;
    }

    @Override
    protected void close(int initiator, String reason, LogService.LogLevel level, Throwable t) {
        if (this.tcp) {
            this.cleanup(initiator, reason, level, t);
            this.keepAlive.cancel(true);
            this.scheduler.shutdown();
        } else {
            super.close(initiator, reason, level, t);
        }
    }

    @Override
    protected int protocolVersion() {
        return 32;
    }

    private void fireFrameReceived(BaosService objSvrService) {
        this.listeners.listeners().stream().filter(ObjectServerListener.class::isInstance).map(ObjectServerListener.class::cast).forEach(l -> l.baosService(objSvrService));
    }

    private void sendKeepAlive() {
        try {
            this.send(BaosService.getServerItem(BaosService.Property.TimeSinceReset, 1), KNXnetIPConnection.BlockingMode.NonBlocking);
        }
        catch (KNXConnectionClosedException kNXConnectionClosedException) {}
    }

    static interface ObjectServerListener
    extends KNXListener {
        public void baosService(BaosService var1);

        @Override
        default public void frameReceived(FrameEvent e) {
        }
    }
}

