/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.buffer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.buffer.Configuration;
import tuwien.auto.calimero.buffer.LDataObject;
import tuwien.auto.calimero.buffer.cache.Cache;
import tuwien.auto.calimero.buffer.cache.CacheObject;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMIFactory;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.cemi.CEMILDataEx;
import tuwien.auto.calimero.datapoint.ChangeListener;
import tuwien.auto.calimero.datapoint.ChangeNotifier;
import tuwien.auto.calimero.datapoint.Datapoint;
import tuwien.auto.calimero.datapoint.DatapointMap;
import tuwien.auto.calimero.datapoint.DatapointModel;
import tuwien.auto.calimero.datapoint.StateDP;
import tuwien.auto.calimero.log.LogService;

public class StateFilter
implements Configuration.NetworkFilter,
Configuration.RequestFilter {
    private Map<KNXAddress, List<GroupAddress>> invalidate;
    private Map<KNXAddress, List<GroupAddress>> update;
    private DatapointModel<? extends Datapoint> model;
    private final ChangeListener cl = new ChangeListener(){

        @Override
        public void onDatapointRemoved(DatapointModel<? extends Datapoint> m, Datapoint dp) {
            if (dp instanceof StateDP) {
                StateFilter.this.destroyReferences((StateDP)dp);
            }
        }

        @Override
        public void onDatapointAdded(DatapointModel<? extends Datapoint> m, Datapoint dp) {
            if (dp instanceof StateDP) {
                StateFilter.this.createReferences((StateDP)dp);
            }
        }
    };

    @Override
    public void init(Configuration c) {
        DatapointModel<? extends Datapoint> m;
        if (this.model instanceof ChangeNotifier) {
            ChangeNotifier notifier = (ChangeNotifier)((Object)this.model);
            notifier.removeChangeListener(this.cl);
        }
        if ((m = c.getDatapointModel()) instanceof ChangeNotifier) {
            this.model = m;
            ChangeNotifier notifier = (ChangeNotifier)((Object)m);
            notifier.addChangeListener(this.cl);
        }
        if (m != null) {
            this.createReferences(m);
        }
    }

    @Override
    public void accept(CEMI frame, Configuration c) {
        CacheObject co;
        CEMILData copy;
        Cache cache = c.getCache();
        if (cache == null || !(frame instanceof CEMILData)) {
            return;
        }
        CEMILData f = (CEMILData)frame;
        if (!(f.getDestination() instanceof GroupAddress)) {
            return;
        }
        GroupAddress dst = (GroupAddress)f.getDestination();
        DatapointModel<? extends Datapoint> m = c.getDatapointModel();
        Datapoint dp = null;
        if (!(m == null || (dp = m.get(dst)) != null && dp.isStateBased())) {
            return;
        }
        byte[] d = f.getPayload();
        int svc = d[0] & 3 | d[1] & 0xC0;
        if (svc == 64) {
            if (f.getMessageCode() == 46) {
                try {
                    copy = (CEMILData)CEMIFactory.create(41, d, f);
                }
                catch (KNXFormatException e) {
                    LogService.getLogger("calimero").error("create L_Data.ind for network buffer: {}", (Object)f, (Object)e);
                    return;
                }
            } else {
                copy = f;
            }
        } else if (svc == 128) {
            d[1] = (byte)(d[1] & 0x3F | 0x40);
            try {
                copy = (CEMILData)CEMIFactory.create(41, d, f);
            }
            catch (KNXFormatException e) {
                LogService.getLogger("calimero").error("create L_Data.ind for network buffer: {}", (Object)f, (Object)e);
                return;
            }
        } else {
            return;
        }
        if (copy instanceof CEMILDataEx) {
            if (copy.getHopCount() != 6) {
                ((CEMILDataEx)copy).setHopCount(6);
            }
            if (copy.isRepetition()) {
                copy = CEMIFactory.create(null, null, copy, false, false);
            }
        } else if (copy.getHopCount() != 6 || copy.isRepetition()) {
            copy = new CEMILData(copy.getMessageCode(), copy.getSource(), copy.getDestination(), copy.getPayload(), copy.getPriority(), false, 6);
        }
        if ((co = cache.get(dst)) != null) {
            ((LDataObject)co).setFrame(copy);
        } else {
            co = new LDataObject(copy);
        }
        cache.put(co);
        this.update(copy, cache);
        if (svc == 128) {
            this.invalidate(copy, cache);
        }
    }

    @Override
    public CEMILData request(KNXAddress dst, Configuration c) {
        int t;
        Datapoint dp;
        Cache cache = c.getCache();
        if (cache == null || !(dst instanceof GroupAddress)) {
            return null;
        }
        LDataObject o = (LDataObject)cache.get(dst);
        if (o == null) {
            return null;
        }
        DatapointModel<? extends Datapoint> m = c.getDatapointModel();
        if (m != null && (dp = m.get((GroupAddress)dst)) != null && dp.isStateBased() && (t = ((StateDP)dp).getExpirationTimeout() * 1000) != 0 && System.currentTimeMillis() > o.getTimestamp() + (long)t) {
            return null;
        }
        return o.getFrame();
    }

    private void update(CEMILData f, Cache c) {
        List<GroupAddress> upd;
        if (this.update != null && (upd = this.update.get(f.getDestination())) != null) {
            Iterator<GroupAddress> i = upd.iterator();
            while (i.hasNext()) {
                CacheObject co = c.get(i.next());
                if (co == null) continue;
                ((LDataObject)co).setFrame(CEMIFactory.create(null, (KNXAddress)co.getKey(), f, false));
            }
        }
    }

    private void invalidate(CEMILData f, Cache c) {
        List<GroupAddress> inv;
        if (this.invalidate != null && (inv = this.invalidate.get(f.getDestination())) != null) {
            Iterator<GroupAddress> i = inv.iterator();
            while (i.hasNext()) {
                c.remove(i.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createReferences(DatapointModel<? extends Datapoint> m) {
        Collection c;
        this.invalidate = new HashMap<KNXAddress, List<GroupAddress>>();
        this.update = new HashMap<KNXAddress, List<GroupAddress>>();
        Collection collection = c = ((DatapointMap)m).getDatapoints();
        synchronized (collection) {
            for (Datapoint dp : c) {
                if (!(dp instanceof StateDP)) continue;
                this.createReferences((StateDP)dp);
            }
        }
    }

    private void createReferences(StateDP dp) {
        StateFilter.createReferences(this.invalidate, dp.getAddresses(false), dp.getMainAddress());
        StateFilter.createReferences(this.update, dp.getAddresses(true), dp.getMainAddress());
    }

    private static void createReferences(Map<KNXAddress, List<GroupAddress>> map, Collection<GroupAddress> forAddr, GroupAddress toAddr) {
        for (GroupAddress ga : forAddr) {
            List<GroupAddress> l = map.get(ga);
            if (l == null) {
                l = new ArrayList<GroupAddress>();
                map.put(ga, l);
            }
            l.add(toAddr);
        }
    }

    private void destroyReferences(StateDP dp) {
        StateFilter.destroyReferences(this.invalidate, dp.getAddresses(false), dp.getMainAddress());
        StateFilter.destroyReferences(this.update, dp.getAddresses(true), dp.getMainAddress());
    }

    private static void destroyReferences(Map<KNXAddress, List<GroupAddress>> map, Collection<GroupAddress> forAddr, GroupAddress toAddr) {
        for (GroupAddress ga : forAddr) {
            List<GroupAddress> l = map.get(ga);
            if (l == null) continue;
            l.remove(toAddr);
            if (!l.isEmpty()) continue;
            map.remove(ga);
        }
    }
}

