/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.buffer.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import tuwien.auto.calimero.buffer.cache.Cache;
import tuwien.auto.calimero.buffer.cache.CacheObject;
import tuwien.auto.calimero.buffer.cache.CacheSweeper;

public abstract class ExpiringCache
implements Cache {
    protected static final int defaultSweepInterval = 60;
    protected int sweepInterval = 60;
    protected Map<Object, CacheObject> map;
    private CacheSweeper sweeper;
    private final int timeToExpire;

    public ExpiringCache(int timeToExpire) {
        if (timeToExpire > 0) {
            this.timeToExpire = timeToExpire;
            this.map = new LinkedHashMap<Object, CacheObject>();
        } else {
            this.timeToExpire = 0;
            this.map = new HashMap<Object, CacheObject>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExpired() {
        if (this.timeToExpire == 0 || !(this.map instanceof LinkedHashMap)) {
            return;
        }
        long now = System.currentTimeMillis();
        long duration = (long)this.timeToExpire * 1000L;
        CacheObject o = null;
        ExpiringCache expiringCache = this;
        synchronized (expiringCache) {
            Iterator<CacheObject> i = this.map.values().iterator();
            while (i.hasNext()) {
                o = i.next();
                if (now < o.getTimestamp() + duration) break;
                i.remove();
                this.notifyRemoved(o);
            }
        }
    }

    protected void notifyRemoved(CacheObject obj) {
    }

    protected final void startSweeper() {
        if (this.timeToExpire > 0 && this.sweeper == null) {
            this.sweeper = new CacheSweeper(this, this.sweepInterval);
            this.sweeper.start();
        }
    }

    protected final void stopSweeper() {
        CacheSweeper s = this.sweeper;
        if (s != null) {
            s.stopSweeper();
            this.sweeper = null;
        }
    }

    static void updateAccess(CacheObject obj) {
        obj.incCount();
        obj.setUsage(obj.getCount());
    }
}

