/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.buffer.cache;

import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import tuwien.auto.calimero.buffer.cache.Cache;
import tuwien.auto.calimero.buffer.cache.CacheObject;
import tuwien.auto.calimero.buffer.cache.ExpiringCache;
import tuwien.auto.calimero.buffer.cache.StatisticImpl;

public class LFUCache
extends ExpiringCache {
    private final SortedMap<CacheObject, CacheObject> tree;
    private int maxSize;
    private long hits;
    private long misses;

    public LFUCache(int cacheSize, int timeToExpire) {
        super(timeToExpire);
        if (cacheSize > 0) {
            this.maxSize = cacheSize;
        }
        this.tree = new TreeMap<CacheObject, CacheObject>(new LFUObjectCompare());
    }

    @Override
    public synchronized void put(CacheObject obj) {
        this.startSweeper();
        Object old = this.map.remove(obj.getKey());
        if (old != null) {
            this.tree.remove(old);
        } else {
            this.ensureSizeLimits();
        }
        obj.resetTimestamp();
        this.map.put(obj.getKey(), obj);
        this.tree.put(obj, obj);
    }

    @Override
    public synchronized CacheObject get(Object key) {
        CacheObject o = (CacheObject)this.map.get(key);
        if (o != null) {
            this.tree.remove(o);
            LFUCache.updateAccess(o);
            this.tree.put(o, o);
            ++this.hits;
        } else {
            ++this.misses;
        }
        return o;
    }

    @Override
    public synchronized void remove(Object key) {
        Object o = this.map.remove(key);
        if (o != null) {
            this.tree.remove(o);
        }
    }

    @Override
    public synchronized void clear() {
        this.stopSweeper();
        this.map.clear();
        this.tree.clear();
    }

    @Override
    public synchronized Cache.Statistic statistic() {
        return new StatisticImpl(this.hits, this.misses);
    }

    @Override
    protected final void notifyRemoved(CacheObject obj) {
        this.tree.remove(obj);
    }

    private void ensureSizeLimits() {
        if (this.maxSize > 0) {
            while (this.map.size() >= this.maxSize) {
                this.remove(this.tree.firstKey().getKey());
            }
        }
    }

    private static class LFUObjectCompare
    implements Comparator<CacheObject> {
        LFUObjectCompare() {
        }

        @Override
        public int compare(CacheObject o1, CacheObject o2) {
            if (o1.getUsage() > o2.getUsage()) {
                return 1;
            }
            if (o1.getUsage() < o2.getUsage()) {
                return -1;
            }
            if (o1.getCount() > o2.getCount()) {
                return 1;
            }
            if (o1.getCount() < o2.getCount()) {
                return -1;
            }
            return 0;
        }
    }
}

