/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.cemi;

import java.io.ByteArrayInputStream;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.cemi.RFMediumInfo;

public class AdditionalInfo {
    public static final int PlMedium = 1;
    public static final int RfMedium = 2;
    public static final int Timestamp = 4;
    public static final int TimeDelay = 5;
    public static final int ExtendedTimestamp = 6;
    public static final int BiBat = 7;
    public static final int RfMulti = 8;
    public static final int PreamblePostamble = 9;
    public static final int RfFastAck = 10;
    public static final int ManufacturerSpecific = 254;
    static final int Escape = 255;
    private static final int[] typeLengths;
    private final int type;
    private final byte[] data;

    static {
        int[] nArray = new int[10];
        nArray[1] = 2;
        nArray[2] = 8;
        nArray[3] = 1;
        nArray[4] = 2;
        nArray[5] = 4;
        nArray[6] = 4;
        nArray[7] = 2;
        nArray[8] = 4;
        nArray[9] = 3;
        typeLengths = nArray;
    }

    public static AdditionalInfo from(ByteArrayInputStream is) throws KNXFormatException {
        int remaining = is.available();
        if (remaining < 3) {
            throw new KNXFormatException("invalid additional info, remaining length " + remaining + " < 3 bytes");
        }
        int type = is.read();
        int len = is.read();
        if (len > remaining) {
            throw new KNXFormatException("additional info length of type " + type + " exceeds info block", len);
        }
        byte[] info = new byte[len];
        is.read(info, 0, len);
        try {
            if (type == 2) {
                return new RFMediumInfo(info);
            }
            return AdditionalInfo.of(type, info);
        }
        catch (KNXIllegalArgumentException e) {
            throw new KNXFormatException(e.getMessage());
        }
    }

    public static AdditionalInfo of(int type, byte[] info) {
        if (type < 0 || type >= 255) {
            throw new KNXIllegalArgumentException("cEMI additional info type " + type + " out of range [0..254]");
        }
        if (info.length > 255) {
            throw new KNXIllegalArgumentException("cEMI additional info of type " + type + " exceeds maximum length of 255 bytes");
        }
        if (type < typeLengths.length && info.length != typeLengths[type]) {
            throw new KNXIllegalArgumentException("invalid length " + info.length + " for cEMI additional info type " + type);
        }
        if (type == 2) {
            return new RFMediumInfo(info);
        }
        return new AdditionalInfo(type, info);
    }

    AdditionalInfo(int type, byte[] info) {
        this.type = type;
        this.data = (byte[])info.clone();
    }

    public final int type() {
        return this.type;
    }

    public final byte[] info() {
        return (byte[])this.data.clone();
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return "PL DoA " + Integer.toHexString((this.data[0] & 0xFF) << 8 | this.data[1] & 0xFF);
            }
            case 2: {
                return new RFMediumInfo(this.data, false).toString();
            }
            case 4: {
                return "timestamp " + ((this.data[0] & 0xFF) << 8 | this.data[1] & 0xFF);
            }
            case 5: {
                return "timedelay " + AdditionalInfo.unsigned(this.data);
            }
            case 6: {
                return "ext.timestamp " + AdditionalInfo.unsigned(this.data);
            }
            case 7: {
                return "BiBat 0x" + DataUnitBuilder.toHex(this.data, " ");
            }
        }
        return "type " + this.type + " = 0x" + DataUnitBuilder.toHex(this.data, "");
    }

    private static long unsigned(byte[] data) {
        long l = 0L;
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            l = l << 8 | (long)(b & 0xFF);
            ++n2;
        }
        return l;
    }
}

