/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.cemi;

import java.io.ByteArrayInputStream;
import java.util.BitSet;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.cemi.CEMI;

public class CEMIDevMgmt
implements CEMI {
    public static final int MC_PROPREAD_REQ = 252;
    public static final int MC_PROPREAD_CON = 251;
    public static final int MC_PROPWRITE_REQ = 246;
    public static final int MC_PROPWRITE_CON = 245;
    public static final int MC_PROPINFO_IND = 247;
    public static final int MC_RESET_REQ = 241;
    public static final int MC_RESET_IND = 240;
    private static BitSet msgCodes;
    private static final int MC_OFFSET = 240;
    private static final byte[] empty;
    private static final String[] errors;
    private final int mc;
    private int iot;
    private int oi;
    private int pid;
    private int elems;
    private int start;
    private byte[] data = empty;
    private int header = 1;

    static {
        empty = new byte[0];
        errors = new String[]{"unspecified Error (unknown error)", "out of range (write value not allowed)", "out of max. range (write value too high)", "out of min. range (write value too low)", "memory error (memory can not be written or only with faults)", "read-only (write access to a read-only or write-protected property)", "illegal command (command not valid or not supported)", "void DP (read/write access to nonexistent property)", "type conflict (write access with a wrong data type (datapoint length))", "property index/range error (read/write access to nonexistent property index)"};
        msgCodes = new BitSet(20);
        msgCodes.set(12);
        msgCodes.set(11);
        msgCodes.set(6);
        msgCodes.set(5);
        msgCodes.set(7);
        msgCodes.set(1);
        msgCodes.set(0);
    }

    public CEMIDevMgmt(byte[] data, int offset, int length) throws KNXFormatException {
        ByteArrayInputStream is = new ByteArrayInputStream(data, offset, length);
        CEMIDevMgmt.checkLength(is, 1);
        this.mc = is.read();
        if (this.mc < 240 || !msgCodes.get(this.mc - 240)) {
            throw new KNXFormatException("unknown message code 0x" + Integer.toHexString(this.mc));
        }
        if (this.mc == 241 || this.mc == 240) {
            CEMIDevMgmt.initReset(is);
        } else {
            this.initHeader(is);
            this.initBody(is);
        }
    }

    public CEMIDevMgmt(int msgCode) {
        if (msgCode != 241 && msgCode != 240) {
            throw new KNXIllegalArgumentException("not a reset message code");
        }
        this.mc = msgCode;
    }

    public CEMIDevMgmt(int msgCode, int objType, int objInstance, int propID, int startIndex, int elements) {
        if (msgCode < 240 || !msgCodes.get(msgCode - 240)) {
            throw new KNXIllegalArgumentException("unknown message code");
        }
        this.mc = msgCode;
        this.header = 7;
        this.checkSetHeaderInfo(objType, objInstance, propID, startIndex, elements);
    }

    public CEMIDevMgmt(int msgCode, int objType, int objInstance, int propID, int startIndex, int elements, byte[] data) {
        this(msgCode, objType, objInstance, propID, startIndex, elements);
        this.data = (byte[])data.clone();
    }

    public static String getErrorMessage(int errorCode) {
        if (errorCode < 0) {
            throw new KNXIllegalArgumentException("error code has to be >= 0");
        }
        if (errorCode > errors.length - 1) {
            return "unknown error code";
        }
        return errors[errorCode];
    }

    @Override
    public final int getMessageCode() {
        return this.mc;
    }

    @Override
    public final byte[] getPayload() {
        return (byte[])this.data.clone();
    }

    public final int getObjectType() {
        return this.iot;
    }

    public final int getObjectInstance() {
        return this.oi;
    }

    public final int getElementCount() {
        return this.elems;
    }

    public final int getPID() {
        return this.pid;
    }

    public final int getStartIndex() {
        return this.start;
    }

    public final boolean isNegativeResponse() {
        return (this.mc == 251 || this.mc == 245) && this.elems == 0;
    }

    public String getErrorMessage() {
        if (!this.isNegativeResponse()) {
            return "no error";
        }
        return CEMIDevMgmt.getErrorMessage(this.data[0] & 0xFF);
    }

    @Override
    public final int getStructLength() {
        return this.header + this.data.length;
    }

    @Override
    public byte[] toByteArray() {
        byte[] buf = new byte[this.header + this.data.length];
        int i = 0;
        buf[i++] = (byte)this.mc;
        if (this.header > 1) {
            buf[i++] = (byte)(this.iot >>> 8);
            buf[i++] = (byte)this.iot;
            buf[i++] = (byte)this.oi;
            buf[i++] = (byte)this.pid;
            buf[i++] = (byte)(this.elems << 4 | this.start >>> 8);
            buf[i++] = (byte)this.start;
            int k = 0;
            while (k < this.data.length) {
                buf[i++] = this.data[k];
                ++k;
            }
        }
        return buf;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(30);
        buf.append("DM ");
        if (this.mc == 252) {
            buf.append("prop-read.req");
        } else if (this.mc == 251) {
            buf.append("prop-read.con");
        } else if (this.mc == 246) {
            buf.append("prop-write.req");
        } else if (this.mc == 245) {
            buf.append("prop-write.con");
        } else if (this.mc == 247) {
            buf.append("prop-info.ind");
        } else {
            if (this.mc == 241) {
                return "DM reset.req";
            }
            if (this.mc == 240) {
                return "DM reset.ind";
            }
        }
        buf.append(" objtype ").append(this.iot);
        buf.append(" instance ").append(this.oi);
        buf.append(" pid ").append(this.pid);
        buf.append(" start ").append(this.start);
        if (this.isNegativeResponse()) {
            buf.append(" ").append(this.getErrorMessage());
        } else {
            buf.append(" elements ").append(this.elems);
            if (this.data.length > 0) {
                buf.append(" data ").append(DataUnitBuilder.toHex(this.data, " "));
            }
        }
        return buf.toString();
    }

    private static void checkLength(ByteArrayInputStream is, int len) throws KNXFormatException {
        if (is.available() < len) {
            throw new KNXFormatException("insufficient frame length", len);
        }
    }

    private static void initReset(ByteArrayInputStream is) throws KNXFormatException {
        if (is.available() != 0) {
            throw new KNXFormatException("invalid length for a reset frame", is.available());
        }
    }

    private void initHeader(ByteArrayInputStream is) throws KNXFormatException {
        CEMIDevMgmt.checkLength(is, 6);
        this.header = 7;
        try {
            int tmp = is.read();
            this.checkSetHeaderInfo(is.read() << 8 | is.read(), is.read(), is.read(), (tmp & 0xF) << 8 | is.read(), tmp >> 4);
        }
        catch (KNXIllegalArgumentException e) {
            throw new KNXFormatException(e.getMessage());
        }
    }

    private void initBody(ByteArrayInputStream is) throws KNXFormatException {
        if (this.isNegativeResponse()) {
            this.data = new byte[]{(byte)is.read()};
        } else if (this.mc == 251 || this.mc == 246 || this.mc == 247) {
            CEMIDevMgmt.checkLength(is, 1);
            this.data = new byte[is.available()];
            is.read(this.data, 0, this.data.length);
        }
    }

    private void checkSetHeaderInfo(int objType, int objInstance, int propID, int startIndex, int elements) {
        if (objType < 0 || objType > 65535) {
            throw new KNXIllegalArgumentException("interface object type " + objType + " out of range [0..0xFFFF]");
        }
        if (objInstance < 1 || objInstance > 255) {
            throw new KNXIllegalArgumentException("object instance " + objInstance + " out of range [1..0xFF]");
        }
        if (propID < 0 || propID > 255) {
            throw new KNXIllegalArgumentException("property ID " + propID + " out of range [0..0xFF]");
        }
        if (startIndex < 0 || startIndex > 4095) {
            throw new KNXIllegalArgumentException("start index " + startIndex + " out of range [0..0xFFF]");
        }
        if (elements < 0 || elements > 15) {
            throw new KNXIllegalArgumentException("elements " + elements + " out of range [0..0xF]");
        }
        if ((this.mc == 252 || this.mc == 246 || this.mc == 247) && elements < 1) {
            throw new KNXIllegalArgumentException("elements may not be 0");
        }
        this.iot = objType;
        this.oi = objInstance;
        this.pid = propID;
        this.start = startIndex;
        this.elems = elements;
    }

    public static final class ErrorCodes {
        public static final int UNSPECIFIED_ERROR = 0;
        public static final int OUT_OF_RANGE = 1;
        public static final int OUT_OF_MAXRANGE = 2;
        public static final int OUT_OF_MINRANGE = 3;
        public static final int MEMORY_ERROR = 4;
        public static final int READ_ONLY = 5;
        public static final int ILLEGAL_COMMAND = 6;
        public static final int VOID_DP = 7;
        public static final int TYPE_CONFLICT = 8;
        public static final int PROP_INDEX_RANGE_ERROR = 9;
        public static final int VALUE_NOT_WRITEABLE_NOW = 10;

        private ErrorCodes() {
        }
    }
}

