/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.cemi;

import java.util.Arrays;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMIBusMon;
import tuwien.auto.calimero.cemi.CEMIDevMgmt;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.cemi.CEMILDataEx;
import tuwien.auto.calimero.cemi.CemiTData;

public final class CEMIFactory {
    private static final int Emi1_LData_ind = 73;
    private static final int Emi1_LBusmon_ind = 73;
    private static final int Emi1_LData_con = 78;
    private static final int Emi1_LSysBcast_req = 21;
    private static final int Emi1_LSysBcast_con = 76;
    private static final int Emi1_LSysBcast_ind = 77;

    private CEMIFactory() {
    }

    public static CEMI create(byte[] data, int offset, int length) throws KNXFormatException {
        if (length < 1) {
            throw new KNXFormatException("buffer too short for cEMI frame", length);
        }
        int mc = data[offset] & 0xFF;
        switch (mc) {
            case 17: 
            case 41: 
            case 46: {
                if (length < 26 && !CEMIFactory.isLteFrame(data, offset, length)) {
                    try {
                        return new CEMILData(data, offset, length);
                    }
                    catch (KNXFormatException kNXFormatException) {}
                }
                return new CEMILDataEx(data, offset, length);
            }
            case 240: 
            case 241: 
            case 245: 
            case 246: 
            case 247: 
            case 251: 
            case 252: {
                return new CEMIDevMgmt(data, offset, length);
            }
            case 43: {
                return new CEMIBusMon(data, offset, length);
            }
            case 65: 
            case 74: 
            case 137: 
            case 148: {
                return new CemiTData(data, offset, length);
            }
        }
        throw new KNXFormatException("unsupported cEMI msg code", mc);
    }

    private static boolean isLteFrame(byte[] data, int offset, int length) {
        if (length < 4) {
            return false;
        }
        int addInfoLen = data[offset + 1] & 0xFF;
        if (length < 4 + addInfoLen) {
            return false;
        }
        int ctrl2 = data[offset + 3 + addInfoLen] & 0xFF;
        return (ctrl2 & 4) != 0;
    }

    public static CEMI create(int msgCode, byte[] data, CEMI original) throws KNXFormatException {
        switch (msgCode) {
            case 17: 
            case 41: 
            case 46: {
                return CEMIFactory.create(msgCode, null, null, data, (CEMILData)original, false, ((CEMILData)original).isRepetition());
            }
            case 240: 
            case 241: 
            case 245: 
            case 246: 
            case 247: 
            case 251: 
            case 252: {
                CEMIDevMgmt f = (CEMIDevMgmt)original;
                return new CEMIDevMgmt(msgCode, f.getObjectType(), f.getObjectInstance(), f.getPID(), f.getStartIndex(), f.getElementCount(), data);
            }
            case 43: {
                CEMIBusMon f = (CEMIBusMon)original;
                return CEMIBusMon.newWithStatus(f.getStatus(), f.getTimestamp(), f.getTimestampType() == 6, data);
            }
        }
        throw new KNXFormatException("unsupported cEMI msg code", msgCode);
    }

    public static CEMILData create(IndividualAddress src, KNXAddress dst, CEMILData original, boolean extended) {
        return (CEMILData)CEMIFactory.create(0, src, dst, null, original, extended, original.isRepetition());
    }

    public static CEMILData create(IndividualAddress src, KNXAddress dst, CEMILData original, boolean extended, boolean repeat) {
        return (CEMILData)CEMIFactory.create(0, src, dst, null, original, extended, repeat);
    }

    public static CEMI fromEmiBusmon(byte[] frame) throws KNXFormatException {
        if (frame.length < 4) {
            throw new KNXFormatException("EMI frame too short");
        }
        int mc = frame[0] & 0xFF;
        if (mc != 43 && mc != 73) {
            throw new KNXFormatException("not a busmonitor frame with msg code 0x" + Integer.toHexString(mc));
        }
        return CEMIBusMon.newWithStatus(frame[1] & 0xFF, (frame[2] & 0xFF) << 8 | frame[3] & 0xFF, false, Arrays.copyOfRange(frame, 4, frame.length));
    }

    public static CEMI fromEmi(byte[] frame) throws KNXFormatException {
        if (frame.length < 4) {
            throw new KNXFormatException("EMI frame too short");
        }
        int mc = frame[0] & 0xFF;
        boolean domainBcast = true;
        if (mc == 21 || mc == 76 || mc == 77) {
            domainBcast = false;
        }
        if (mc == 73) {
            mc = 41;
        }
        if (mc == 78) {
            mc = 46;
        }
        if (mc == 21) {
            mc = 17;
        }
        if (mc == 76) {
            mc = 46;
        }
        if (mc == 77) {
            mc = 41;
        }
        if (mc == 43) {
            return CEMIBusMon.newWithStatus(frame[1] & 0xFF, (frame[2] & 0xFF) << 8 | frame[3] & 0xFF, false, Arrays.copyOfRange(frame, 4, frame.length));
        }
        Priority p = Priority.get(frame[1] >> 2 & 3);
        boolean ack = (frame[1] & 2) != 0;
        boolean c = (frame[1] & 1) != 0;
        int dst = (frame[4] & 0xFF) << 8 | frame[5] & 0xFF;
        KNXAddress a = (frame[6] & 0x80) != 0 ? new GroupAddress(dst) : new IndividualAddress(dst);
        int hops = frame[6] >> 4 & 7;
        int len = (frame[6] & 0xF) + 1;
        byte[] tpdu = Arrays.copyOfRange(frame, 7, len + 7);
        int src = (frame[2] & 0xFF) << 8 | frame[3] & 0xFF;
        if (c) {
            return new CEMILData(mc, new IndividualAddress(src), a, tpdu, p, c);
        }
        boolean repeat = mc != 41;
        return new CEMILData(mc, new IndividualAddress(src), a, tpdu, p, repeat, domainBcast, ack, hops);
    }

    public static byte[] toEmi(CEMILData msg) {
        int mc = msg.getMessageCode();
        KNXAddress dst = msg.getDestination();
        if (msg.isSystemBroadcast()) {
            mc = 21;
        }
        if (dst.getRawAddress() == 0 && DataUnitBuilder.getAPDUService(msg.getPayload()) == 993) {
            mc = 21;
        }
        Priority p = msg.getPriority();
        boolean repeat = msg.isRepetition();
        boolean ackRequest = msg.isAckRequested();
        boolean posCon = msg.isPositiveConfirmation();
        int hopCount = msg.getHopCount();
        byte[] nsdu = msg.getPayload();
        return CEMIFactory.toEmi(mc, dst, p, repeat, ackRequest, posCon, hopCount, nsdu);
    }

    public static byte[] toEmi(int mc, KNXAddress dst, Priority p, boolean repeat, boolean ackRequest, boolean positiveCon, int hopCount, byte[] nsdu) {
        if (nsdu.length > 16) {
            throw new KNXIllegalArgumentException("maximum TPDU length is 16 in standard frame");
        }
        byte[] buf = new byte[nsdu.length + 7];
        buf[0] = (byte)mc;
        buf[1] = (byte)(p.value << 2);
        boolean rep = mc == 78 ? repeat : false;
        int ctrl = (rep ? 32 : 0) | (ackRequest ? 2 : 0) | (positiveCon ? 0 : 1);
        buf[1] = (byte)(buf[1] | (byte)ctrl);
        int d = dst != null ? dst.getRawAddress() : 0;
        buf[4] = (byte)(d >> 8);
        buf[5] = (byte)d;
        buf[6] = (byte)(hopCount << 4 | nsdu.length - 1);
        if (dst instanceof GroupAddress) {
            buf[6] = (byte)(buf[6] | 0x80);
        }
        int i = 0;
        while (i < nsdu.length) {
            buf[7 + i] = nsdu[i];
            ++i;
        }
        return buf;
    }

    public static CEMI copy(CEMI original) {
        if (original instanceof CEMILDataEx) {
            return ((CEMILDataEx)original).clone();
        }
        return original;
    }

    private static CEMI create(int msgCode, IndividualAddress src, KNXAddress dst, byte[] data, CEMILData original, boolean ext, boolean repeat) {
        byte[] content;
        int mc = msgCode != 0 ? msgCode : original.getMessageCode();
        IndividualAddress s = src != null ? src : original.getSource();
        KNXAddress d = dst != null ? dst : original.getDestination();
        byte[] byArray = content = data != null ? data : original.getPayload();
        if (original instanceof CEMILDataEx) {
            CEMILDataEx f = (CEMILDataEx)original;
            CEMILDataEx copy = new CEMILDataEx(mc, s, d, content, f.getPriority(), repeat, f.isDomainBroadcast(), f.isAckRequested(), f.getHopCount());
            if ((original.ctrl1 & 0x80) == 0) {
                copy.ctrl1 &= 0xFFFFFF7F;
            }
            copy.ctrl2 |= original.ctrl2 & 0xF;
            copy.additionalInfo().addAll(f.additionalInfo());
            return copy;
        }
        if (ext) {
            return new CEMILDataEx(mc, s, d, content, original.getPriority(), repeat, original.getHopCount());
        }
        return new CEMILData(mc, s, d, content, original.getPriority(), repeat, original.getHopCount());
    }
}

