/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.cemi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.cemi.CEMI;

public class CEMILData
implements CEMI {
    public static final int MC_LDATA_REQ = 17;
    public static final int MC_LDATA_CON = 46;
    public static final int MC_LDATA_IND = 41;
    static final int BASIC_LENGTH = 9;
    protected int mc;
    protected int ctrl1;
    protected int ctrl2;
    byte[] data;
    private volatile Priority p;
    private IndividualAddress source;
    private KNXAddress dst;

    public CEMILData(byte[] data, int offset, int length) throws KNXFormatException {
        if (data.length - offset < length || length < 10) {
            throw new KNXFormatException("buffer too short for frame");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(data, offset, length);
        this.readMC(is);
        this.readAddInfo(is);
        this.readCtrlAndAddr(is);
        if ((this.ctrl1 & 0x80) == 0) {
            throw new KNXFormatException("only cEMI standard frame supported");
        }
        this.readPayload(is);
    }

    public CEMILData(int msgCode, IndividualAddress src, KNXAddress dst, byte[] tpdu, Priority p) {
        this(msgCode, src, dst, tpdu, p, true, true, false, 6);
    }

    public CEMILData(int msgCode, IndividualAddress src, KNXAddress dst, byte[] tpdu, Priority p, boolean confirm) {
        this(msgCode, src, dst, tpdu, p, true, true, false, 6);
        this.setConfirmation(confirm);
    }

    protected CEMILData(int msgCode, IndividualAddress src, KNXAddress dst, byte[] tpdu, Priority p, boolean repeat, boolean broadcast, boolean ack, int hopCount) {
        if (msgCode != 17 && msgCode != 46 && msgCode != 41) {
            throw new KNXIllegalArgumentException("unknown L-Data message code " + Integer.toHexString(msgCode));
        }
        this.mc = msgCode;
        this.source = src;
        this.dst = dst;
        this.ctrl1 |= 0x80;
        if (dst instanceof GroupAddress) {
            this.ctrl2 |= 0x80;
        }
        if (!this.isValidTPDULength(tpdu)) {
            throw new KNXIllegalArgumentException("maximum TPDU length is 16 in standard frame");
        }
        this.data = (byte[])tpdu.clone();
        this.setPriority(p);
        this.setRepeat(repeat);
        this.setBroadcast(broadcast);
        this.setAcknowledgeRequest(ack);
        this.setHopCount(hopCount);
    }

    public CEMILData(int msgCode, IndividualAddress src, KNXAddress dst, byte[] tpdu, Priority p, boolean repeat, int hopCount) {
        this(msgCode, src, dst, tpdu, p, repeat, true, false, hopCount);
    }

    CEMILData() {
    }

    @Override
    public final int getMessageCode() {
        return this.mc;
    }

    @Override
    public final byte[] getPayload() {
        return (byte[])this.data.clone();
    }

    public final IndividualAddress getSource() {
        return this.source;
    }

    public final KNXAddress getDestination() {
        return this.dst;
    }

    public final int getHopCount() {
        return (this.ctrl2 & 0x70) >> 4;
    }

    public final Priority getPriority() {
        return this.p;
    }

    public final boolean isSystemBroadcast() {
        return (this.ctrl1 & 0x10) == 0;
    }

    public final boolean isAckRequested() {
        return (this.ctrl1 & 2) != 0;
    }

    public final boolean isRepetition() {
        if (this.mc == 41) {
            return (this.ctrl1 & 0x20) == 0;
        }
        return (this.ctrl1 & 0x20) == 32;
    }

    public final boolean isPositiveConfirmation() {
        return (this.ctrl1 & 1) == 0;
    }

    @Override
    public int getStructLength() {
        return 9 + this.data.length;
    }

    @Override
    public byte[] toByteArray() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(this.mc);
        this.writeAddInfo(os);
        this.setCtrlPriority();
        os.write(this.ctrl1);
        os.write(this.ctrl2);
        byte[] buf = this.source.toByteArray();
        os.write(buf, 0, buf.length);
        buf = this.dst.toByteArray();
        os.write(buf, 0, buf.length);
        this.writePayload(os);
        return os.toByteArray();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.source).append("->").append(this.dst);
        buf.append(" L_Data");
        buf.append(this.mc == 41 ? ".ind" : (this.mc == 17 ? ".req" : ".con"));
        if (this.mc == 46) {
            buf.append(this.isPositiveConfirmation() ? " (pos)" : " (neg)");
        }
        buf.append(", ");
        if (this.isSystemBroadcast()) {
            buf.append("system broadcast ");
        }
        buf.append((Object)this.p).append(" priority");
        buf.append(" hop count ").append(this.getHopCount());
        if (this.mc != 46) {
            if (this.isAckRequested()) {
                buf.append(" ack-request");
            }
            if (this.isRepetition()) {
                buf.append(" repeat");
            }
        }
        buf.append(", tpdu ").append(DataUnitBuilder.toHex(this.data, " "));
        return buf.toString();
    }

    void readAddInfo(ByteArrayInputStream is) throws KNXFormatException {
        if (is.read() != 0) {
            throw new KNXFormatException("cEMI frames with additional info not supported");
        }
    }

    void readPayload(ByteArrayInputStream is) throws KNXFormatException {
        int len = is.read() + 1;
        if (len > is.available()) {
            throw new KNXFormatException("length of tpdu exceeds available data", len);
        }
        this.data = new byte[len];
        is.read(this.data, 0, len);
    }

    void writeAddInfo(ByteArrayOutputStream os) {
        os.write(0);
    }

    void writePayload(ByteArrayOutputStream os) {
        os.write(this.data.length - 1);
        os.write(this.data, 0, this.data.length);
    }

    boolean isValidTPDULength(byte[] tpdu) {
        return tpdu.length <= 16;
    }

    void readCtrlAndAddr(ByteArrayInputStream is) {
        this.ctrl1 = is.read();
        this.getCtrlPriority();
        this.ctrl2 = is.read();
        byte[] addr = new byte[2];
        is.read(addr, 0, 2);
        this.source = new IndividualAddress(addr);
        is.read(addr, 0, 2);
        this.dst = (this.ctrl2 & 0x80) != 0 ? new GroupAddress(addr) : new IndividualAddress(addr);
    }

    void readMC(ByteArrayInputStream is) throws KNXFormatException {
        this.mc = is.read();
        if (this.mc != 17 && this.mc != 46 && this.mc != 41) {
            throw new KNXFormatException("msg code indicates no L-data frame", this.mc);
        }
    }

    void setHopCount(int hobbes) {
        if (hobbes < 0 || hobbes > 7) {
            throw new KNXIllegalArgumentException("hop count out of range [0..7]");
        }
        this.ctrl2 &= 0x8F;
        this.ctrl2 |= hobbes << 4;
    }

    void setPriority(Priority priority) {
        this.p = priority;
    }

    void setBroadcast(boolean domain) {
        this.ctrl1 = domain ? (this.ctrl1 |= 0x10) : (this.ctrl1 &= 0xEF);
    }

    private void getCtrlPriority() {
        int bits = this.ctrl1 >> 2 & 3;
        this.p = bits == Priority.LOW.value ? Priority.LOW : (bits == Priority.NORMAL.value ? Priority.NORMAL : (bits == Priority.SYSTEM.value ? Priority.SYSTEM : Priority.URGENT));
        this.ctrl1 &= 0xFFFFFFF3;
    }

    private void setAcknowledgeRequest(boolean ack) {
        this.ctrl1 = ack ? (this.ctrl1 |= 2) : (this.ctrl1 &= 0xFD);
    }

    private void setConfirmation(boolean error) {
        this.ctrl1 = error ? (this.ctrl1 |= 1) : (this.ctrl1 &= 0xFE);
    }

    private void setCtrlPriority() {
        this.ctrl1 &= 0xFFFFFFF3;
        this.ctrl1 |= this.p.value << 2;
    }

    private void setRepeat(boolean repeat) {
        boolean flag;
        boolean bl = this.mc == 41 ? !repeat : (flag = repeat);
        this.ctrl1 = flag ? (this.ctrl1 |= 0x20) : (this.ctrl1 &= 0xDF);
    }
}

