/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.cemi;

import java.util.Arrays;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.cemi.AdditionalInfo;

public final class RFMediumInfo
extends AdditionalInfo {
    private final boolean sysBcast;

    RFMediumInfo(byte[] info) {
        this(info, false);
    }

    public RFMediumInfo(byte[] info, boolean systemBroadcast) {
        super(2, info);
        this.sysBcast = systemBroadcast;
    }

    public RFMediumInfo(boolean batteryOk, boolean transmitOnlyDevice) {
        this(RSS.Void, RSS.Void, batteryOk, transmitOnlyDevice, new byte[6], 255);
    }

    public RFMediumInfo(boolean batteryOk, boolean transmitOnlyDevice, byte[] doA, int lfn) {
        this(batteryOk, transmitOnlyDevice, doA, lfn, false);
    }

    public RFMediumInfo(boolean batteryOk, boolean transmitOnlyDevice, byte[] doA, int lfn, boolean systemBroadcast) {
        super(2, RFMediumInfo.toByteArray(RSS.Void, RSS.Void, batteryOk, transmitOnlyDevice, doA, lfn));
        this.sysBcast = systemBroadcast;
    }

    public RFMediumInfo(RSS sender, RSS retransmitter, boolean batteryOk, boolean transmitOnlyDevice, byte[] doA, int lfn) {
        super(2, RFMediumInfo.toByteArray(sender, retransmitter, batteryOk, transmitOnlyDevice, doA, lfn));
        this.sysBcast = false;
    }

    public boolean isSystemBroadcast() {
        return this.sysBcast;
    }

    public RSS getRSS() {
        int rfInfo = this.info()[0] & 0xFF;
        int rss = rfInfo >> 4 & 3;
        return RSS.values()[rss];
    }

    public RSS getRetransmitterRSS() {
        int rfInfo = this.info()[0] & 0xFF;
        int rss = rfInfo >> 2 & 3;
        return RSS.values()[rss];
    }

    public boolean isBatteryOk() {
        int rfInfo = this.info()[0] & 0xFF;
        boolean ok = (rfInfo >> 1 & 1) == 1;
        return ok;
    }

    public boolean isTransmitOnlyDevice() {
        int rfInfo = this.info()[0] & 0xFF;
        boolean uni = (rfInfo & 1) == 1;
        return uni;
    }

    public byte[] getDoAorSN() {
        return Arrays.copyOfRange(this.info(), 1, 7);
    }

    public int getFrameNumber() {
        int lfn = this.info()[7] & 0xFF;
        return lfn;
    }

    @Override
    public String toString() {
        String domain = this.isSystemBroadcast() ? "SN " : "DoA ";
        RSS retxRss = this.getRetransmitterRSS();
        String rtx = retxRss == RSS.Void ? "" : " ReTx RSS=" + (Object)((Object)retxRss);
        String battery = this.isBatteryOk() ? "OK" : "weak";
        return "RF " + domain + DataUnitBuilder.toHex(this.getDoAorSN(), "") + ", LFN " + this.getFrameNumber() + ", RSS=" + (Object)((Object)this.getRSS()) + rtx + ", Battery " + battery;
    }

    private static byte[] toByteArray(RSS sender, RSS retransmitter, boolean batteryOK, boolean transmitOnlyDevice, byte[] doA, int lfn) {
        byte[] info = new byte[8];
        int unidir = transmitOnlyDevice ? 1 : 0;
        info[0] = (byte)(sender.ordinal() << 4 | retransmitter.ordinal() << 2 | (batteryOK ? 2 : 0) | unidir);
        if (doA.length != 6) {
            throw new KNXIllegalArgumentException("DoA/SN invalid length: 0x" + DataUnitBuilder.toHex(doA, ""));
        }
        int i = 0;
        while (i < doA.length) {
            byte b;
            info[1 + i] = b = doA[i];
            ++i;
        }
        if ((lfn < 0 || lfn > 7) && lfn != 255) {
            throw new KNXIllegalArgumentException("LFN not in {0, ..., 7, 255}: " + lfn);
        }
        info[7] = (byte)lfn;
        return info;
    }

    public static enum RSS {
        Void,
        Weak,
        Medium,
        Strong;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

