/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.datapoint;

import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.datapoint.CommandDP;
import tuwien.auto.calimero.datapoint.StateDP;
import tuwien.auto.calimero.xml.KNXMLException;
import tuwien.auto.calimero.xml.XmlReader;
import tuwien.auto.calimero.xml.XmlWriter;

public abstract class Datapoint {
    static final String TAG_DATAPOINT = "datapoint";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_STATEBASED = "stateBased";
    private static final String ATTR_MAINNUMBER = "mainNumber";
    private static final String ATTR_DPTID = "dptID";
    private static final String ATTR_PRIORITY = "priority";
    private final boolean stateBased;
    private GroupAddress main;
    private volatile String name;
    private volatile int mainNo;
    private volatile String dptId;
    private volatile Priority priority = Priority.LOW;

    Datapoint(GroupAddress main, String name, boolean stateBased) {
        this.main = main;
        this.name = name;
        this.stateBased = stateBased;
    }

    Datapoint(XmlReader r) throws KNXMLException {
        if (r.getEventType() != 1) {
            r.nextTag();
        }
        if (r.getEventType() != 1 || !r.getLocalName().equals(TAG_DATAPOINT)) {
            throw new KNXMLException("no KNX datapoint element", r);
        }
        this.stateBased = Datapoint.readDPType(r);
        this.name = r.getAttributeValue(null, ATTR_NAME);
        if (this.name == null) {
            throw new KNXMLException("missing attribute name", r);
        }
        this.dptId = r.getAttributeValue(null, ATTR_DPTID);
        if (this.dptId == null) {
            throw new KNXMLException("missing attribute dptID", r);
        }
        if (this.dptId.length() == 0) {
            this.dptId = null;
        }
        String a = null;
        try {
            a = r.getAttributeValue(null, ATTR_MAINNUMBER);
            if (a != null) {
                this.mainNo = Integer.decode(a);
            }
            if ((a = r.getAttributeValue(null, ATTR_PRIORITY)) != null) {
                this.priority = Priority.get(a);
            }
        }
        catch (RuntimeException rte) {
            throw new KNXMLException("malformed attribute, " + rte.getMessage(), r);
        }
        r.nextTag();
    }

    public static Datapoint create(XmlReader r) throws KNXMLException {
        if (r.getEventType() != 1) {
            r.nextTag();
        }
        if (r.getEventType() == 1) {
            if (Datapoint.readDPType(r)) {
                return new StateDP(r);
            }
            return new CommandDP(r);
        }
        throw new KNXMLException("no KNX datapoint", r);
    }

    public final GroupAddress getMainAddress() {
        return this.main;
    }

    public final void setName(String friendlyName) {
        this.name = friendlyName;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isStateBased() {
        return this.stateBased;
    }

    public final void setPriority(Priority p) {
        this.priority = p;
    }

    public final Priority getPriority() {
        return this.priority;
    }

    public final void setDPT(int mainNumber, String dptID) {
        this.mainNo = mainNumber;
        this.dptId = dptID;
    }

    public final int getMainNumber() {
        return this.mainNo;
    }

    public final String getDPT() {
        return this.dptId;
    }

    public void save(XmlWriter w) throws KNXMLException {
        w.writeStartElement(TAG_DATAPOINT);
        w.writeAttribute(ATTR_STATEBASED, Boolean.toString(this.stateBased));
        w.writeAttribute(ATTR_NAME, this.name);
        w.writeAttribute(ATTR_MAINNUMBER, Integer.toString(this.mainNo));
        w.writeAttribute(ATTR_DPTID, this.dptId == null ? "" : this.dptId);
        w.writeAttribute(ATTR_PRIORITY, this.priority.toString());
        this.main.save(w);
        this.doSave(w);
        w.writeEndElement();
    }

    public String toString() {
        return String.valueOf(this.main.toString()) + " '" + this.name + "', DPT" + (this.mainNo != 0 ? " main " + this.mainNo : "") + " " + (this.dptId == null ? "-" : this.dptId) + ", " + this.priority.toString() + " priority";
    }

    void doLoad(XmlReader r) throws KNXMLException {
        if (this.main != null) {
            throw new KNXMLException("main address already set", r);
        }
        if (r.getEventType() != 1) {
            r.nextTag();
        }
        this.main = new GroupAddress(r);
    }

    abstract void doSave(XmlWriter var1) throws KNXMLException;

    private static boolean readDPType(XmlReader r) throws KNXMLException {
        String a = r.getAttributeValue(null, ATTR_STATEBASED);
        if ("false".equalsIgnoreCase(a)) {
            return false;
        }
        if ("true".equalsIgnoreCase(a)) {
            return true;
        }
        throw new KNXMLException("malformed attribute stateBased", r);
    }
}

