/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.Map;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.DPTXlatorBoolean;

public class DPTXlator1BitControlled
extends DPTXlator {
    public static final DPT DPT_SWITCH_CONTROL = new DPT1BitControlled("2.001", "Switch Controlled", DPTXlatorBoolean.DPT_SWITCH);
    public static final DPT DPT_BOOL_CONTROL = new DPT1BitControlled("2.002", "Boolean Controlled", DPTXlatorBoolean.DPT_BOOL);
    public static final DPT DPT_ENABLE_CONTROL = new DPT1BitControlled("2.003", "Enable Controlled", DPTXlatorBoolean.DPT_ENABLE);
    public static final DPT DPT_RAMP_CONTROL = new DPT1BitControlled("2.004", "Ramp Controlled", DPTXlatorBoolean.DPT_RAMP);
    public static final DPT DPT_ALARM_CONTROL = new DPT1BitControlled("2.005", "Alarm Controlled", DPTXlatorBoolean.DPT_ALARM);
    public static final DPT DPT_BINARY_CONTROL = new DPT1BitControlled("2.006", "Binary Controlled", DPTXlatorBoolean.DPT_BINARYVALUE);
    public static final DPT DPT_STEP_CONTROL = new DPT1BitControlled("2.007", "Step Controlled", DPTXlatorBoolean.DPT_STEP);
    public static final DPT DPT_UPDOWN_CONTROL = new DPT1BitControlled("2.008", "Up/Down Controlled", DPTXlatorBoolean.DPT_UPDOWN);
    public static final DPT DPT_OPENCLOSE_CONTROL = new DPT1BitControlled("2.009", "Open/Close Controlled", DPTXlatorBoolean.DPT_OPENCLOSE);
    public static final DPT DPT_START_CONTROL = new DPT1BitControlled("2.010", "Start Controlled", DPTXlatorBoolean.DPT_START);
    public static final DPT DPT_STATE_CONTROL = new DPT1BitControlled("2.011", "State Controlled", DPTXlatorBoolean.DPT_STATE);
    public static final DPT DPT_INVERT_CONTROL = new DPT1BitControlled("2.012", "Invert Controlled", DPTXlatorBoolean.DPT_INVERT);
    private static final Map<String, DPT> types = DPTXlator1BitControlled.loadDatapointTypes(DPTXlator1BitControlled.class);

    public DPTXlator1BitControlled(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DPTXlator1BitControlled(String dptId) throws KNXFormatException {
        super(false, 2);
        this.setTypeID(types, dptId);
        this.data = new short[1];
    }

    @Override
    public void setValue(double value) {
        if (value < 0.0 || value > 3.0) {
            throw new KNXIllegalArgumentException("value " + value + " out of range [0..3]");
        }
        int i = (int)value;
        boolean control = (i & 2) != 0;
        boolean v = (i & 1) != 0;
        this.setValue(control, v);
    }

    public final void setValue(boolean control, boolean value) {
        this.data = new short[1];
        this.setControlBit(control);
        this.setValueBit(value);
    }

    @Override
    public String[] getAllValues() {
        String[] buf = new String[this.data.length];
        int i = 0;
        while (i < this.data.length) {
            buf[i] = this.fromDPT(i);
            ++i;
        }
        return buf;
    }

    public final void setControlBit(boolean control) {
        this.data[0] = control ? (short)(this.data[0] | 2) : (short)(this.data[0] & 0xFFFFFFFD);
    }

    public final boolean getControlBit() {
        return this.control(0);
    }

    public final void setValueBit(boolean value) {
        this.data[0] = value ? (short)(this.data[0] | 1) : (short)(this.data[0] & 0xFFFFFFFE);
    }

    public final boolean getValueBit() {
        return this.value(0);
    }

    @Override
    public double getNumericValue() {
        return this.data[0] & 3;
    }

    @Override
    public void setData(byte[] data, int offset) {
        super.setData(data, offset);
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = (short)(this.data[i] & 3);
            ++i;
        }
    }

    @Override
    public byte[] getData(byte[] dst, int offset) {
        int end = Math.min(this.data.length, dst.length - offset);
        int i = 0;
        while (i < end) {
            dst[offset + i] = (byte)(dst[offset + i] & 0xFC | this.data[i]);
            ++i;
        }
        return dst;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private boolean value(int index) {
        return (this.data[index] & 1) == 1;
    }

    private boolean control(int index) {
        return (this.data[index] & 2) != 0;
    }

    private String fromDPT(int index) {
        String ctrl = this.control(index) ? "1 " : "0 ";
        DPT val = ((DPT1BitControlled)this.dpt).getValueDPT();
        return String.valueOf(ctrl) + (this.value(index) ? val.getUpperValue() : val.getLowerValue());
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        if (value.length() < 3) {
            throw this.newException("wrong value format", value);
        }
        DPT val = ((DPT1BitControlled)this.dpt).getValueDPT();
        DPTXlatorBoolean x = new DPTXlatorBoolean(val);
        x.setValue(value.substring(2));
        int c = 0;
        if (value.startsWith("1 ")) {
            c = 2;
        } else if (!value.startsWith("0 ")) {
            throw this.newException("invalid control bit", value);
        }
        dst[index] = (short)(c + (x.getValueBoolean() ? 1 : 0));
    }

    public static class DPT1BitControlled
    extends DPT {
        private final DPT value;

        public DPT1BitControlled(String typeID, String description, DPT value) {
            super(typeID, description, "0 " + value.getLowerValue(), "1 " + value.getUpperValue());
            this.value = value;
        }

        public final DPT getValueDPT() {
            return this.value;
        }
    }
}

