/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.Map;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DPTXlator2ByteFloat
extends DPTXlator {
    public static final DPT DPT_TEMPERATURE = new DPT("9.001", "Temperature", "-273", "+670760", "\u00b0C");
    public static final DPT DPT_TEMPERATURE_DIFFERENCE = new DPT("9.002", "Temperature difference", "-670760", "+670760", "K");
    public static final DPT DPT_TEMPERATURE_GRADIENT = new DPT("9.003", "Temperature gradient", "-670760", "+670760", "K/h");
    public static final DPT DPT_INTENSITY_OF_LIGHT = new DPT("9.004", "Light intensity", "0", "+670760", "lx");
    public static final DPT DPT_WIND_SPEED = new DPT("9.005", "Wind speed", "0", "+670760", "m/s");
    public static final DPT DPT_AIR_PRESSURE = new DPT("9.006", "Air pressure", "0", "+670760", "Pa");
    public static final DPT DPT_HUMIDITY = new DPT("9.007", "Humidity", "0", "+670760", "%");
    public static final DPT DPT_AIRQUALITY = new DPT("9.008", "Air quality", "0", "+670760", "ppm");
    public static final DPT DPT_AIR_FLOW = new DPT("9.009", "Air flow", "-670760", "+670760", "m\u00b3/h");
    public static final DPT DPT_TIME_DIFFERENCE1 = new DPT("9.010", "Time difference 1", "-670760", "+670760", "s");
    public static final DPT DPT_TIME_DIFFERENCE2 = new DPT("9.011", "Time difference 2", "-670760", "+670760", "ms");
    public static final DPT DPT_VOLTAGE = new DPT("9.020", "Voltage", "-670760", "+670760", "mV");
    public static final DPT DPT_ELECTRICAL_CURRENT = new DPT("9.021", "Electrical current", "-670760", "+670760", "mA");
    public static final DPT DPT_POWERDENSITY = new DPT("9.022", "Power density", "-670760", "+670760", "W/m\u00b2");
    public static final DPT DPT_KELVIN_PER_PERCENT = new DPT("9.023", "Kelvin/percent", "-670760", "+670760", "K/%");
    public static final DPT DPT_POWER = new DPT("9.024", "Power", "-670760", "+670760", "kW");
    public static final DPT DPT_VOLUME_FLOW = new DPT("9.025", "Volume flow", "-670760", "+670760", "l/h");
    public static final DPT DPT_RAIN_AMOUNT = new DPT("9.026", "Rain amount", "-671088.64", "670760.96", "l/m\u00b2");
    public static final DPT DPT_TEMP_F = new DPT("9.027", "Temperature", "-459.6", "670760.96", "\u00b0F");
    public static final DPT DPT_WIND_SPEED_KMH = new DPT("9.028", "Wind speed", "0", "670760.96", "km/h");
    public static final DPT DptAbsoluteHumidity = new DPT("9.029", "absolute humidity", "0", "670760.96", "g/m\u00b3");
    public static final DPT DptConcentration = new DPT("9.030", "concentration", "0", "670760.96", "\u00b5g/m\u00b3");
    private static final Map<String, DPT> types = DPTXlator2ByteFloat.loadDatapointTypes(DPTXlator2ByteFloat.class);
    private final double min;
    private final double max;
    private static final double negLimit = -671088.64;
    private static final double posLimit = 670760.96;

    public DPTXlator2ByteFloat(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DPTXlator2ByteFloat(String dptID) throws KNXFormatException {
        super(2);
        this.setTypeID(types, dptID);
        this.min = this.getLimit(this.dpt.getLowerValue());
        this.max = this.getLimit(this.dpt.getUpperValue());
        this.data = new short[2];
    }

    @Override
    public void setValue(double value) throws KNXFormatException {
        short[] buf = new short[2];
        this.toDPT(value, buf, 0);
        this.data = buf;
    }

    @Override
    public final double getNumericValue() {
        return this.fromDPT(0);
    }

    @Override
    public String[] getAllValues() {
        String[] buf = new String[this.data.length / 2];
        int i = 0;
        while (i < buf.length) {
            buf[i] = this.makeString(i);
            ++i;
        }
        return buf;
    }

    @Override
    public Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String makeString(int index) {
        return this.appendUnit(String.valueOf(this.fromDPT(index)));
    }

    private double fromDPT(int index) {
        int i = 2 * index;
        int v = (this.data[i] & 0x80) << 24 | (this.data[i] & 7) << 28 | this.data[i + 1] << 20;
        int exp = (this.data[i] & 0x78) >> 3;
        return (double)((1 << exp) * (v >>= 20)) * 0.01;
    }

    private void toDPT(double value, short[] dst, int index) throws KNXFormatException {
        if (value < this.min || value > this.max) {
            throw this.newException("translation error, value out of range [" + this.dpt.getLowerValue() + ".." + this.dpt.getUpperValue() + "]", Double.toString(value));
        }
        double v = value * 100.0;
        int e = 0;
        while (v < -2048.0) {
            ++e;
            v /= 2.0;
        }
        while (v > 2047.0) {
            ++e;
            v /= 2.0;
        }
        int m = (int)Math.round(v) & 0x7FF;
        short msb = (short)(e << 3 | m >> 8);
        if (value < 0.0) {
            msb = (short)(msb | 0x80);
        }
        dst[2 * index] = msb;
        dst[2 * index + 1] = DPTXlator2ByteFloat.ubyte(m);
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        try {
            this.toDPT(Double.parseDouble(this.removeUnit(value)), dst, index);
        }
        catch (NumberFormatException e) {
            throw this.newException("wrong value format", value, e);
        }
    }

    private double getLimit(String limit) throws KNXFormatException {
        try {
            double d = Double.parseDouble(limit);
            if (d >= -671088.64 && d <= 670760.96) {
                return d;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        throw this.newException("limit in valid DPT range", limit);
    }
}

