/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.Map;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DPTXlator4ByteSigned
extends DPTXlator {
    public static final DPT DPT_COUNT = new DPT("13.001", "Counter pulses", "-2147483648", "2147483647", "counter pulses");
    public static final DPT DPT_FLOWRATE = new DPT("13.002", "Flow rate", "-2147483648", "2147483647", "m3/h");
    public static final DPT DPT_ACTIVE_ENERGY = new DPT("13.010", "Active Energy", "-2147483648", "2147483647", "Wh");
    public static final DPT DPT_APPARENT_ENERGY = new DPT("13.011", "Apparent energy", "-2147483648", "2147483647", "VAh");
    public static final DPT DPT_REACTIVE_ENERGY = new DPT("13.012", "Reactive energy", "-2147483648", "2147483647", "VARh");
    public static final DPT DPT_ACTIVE_ENERGY_KWH = new DPT("13.013", "Active energy in kWh", "-2147483648", "2147483647", "kWh");
    public static final DPT DPT_APPARENT_ENERGY_KVAH = new DPT("13.014", "Apparent energy in kVAh", "-2147483648", "2147483647", "kVAh");
    public static final DPT DPT_REACTIVE_ENERGY_KVARH = new DPT("13.015", "Reactive energy in kVARh", "-2147483648", "2147483647", "kVARh");
    public static final DPT DptActiveEnergyMWh = new DPT("13.016", "Active energy in MWh", "-2147483648", "2147483647", "MWh");
    public static final DPT DPT_DELTA_TIME = new DPT("13.100", "time lag", "-2147483648", "2147483647", "s");
    public static final DPT DPT_DELTA_VOLUME_LIQUID_LITER = new DPT("13.1200", "volume liquid [l]", "-2147483648", "2147483647", "l");
    public static final DPT DPT_DELTA_VOLUME_M3 = new DPT("13.1201", "volume [m\u00b3]", "-2147483648", "2147483647", "m\u00b3");
    private static final Map<String, DPT> types = DPTXlator4ByteSigned.loadDatapointTypes(DPTXlator4ByteSigned.class);

    public DPTXlator4ByteSigned(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DPTXlator4ByteSigned(String dptId) throws KNXFormatException {
        super(4);
        this.setTypeID(types, dptId);
        this.data = new short[4];
    }

    @Override
    public void setValue(double value) {
        this.setValue((int)value);
    }

    public final void setValue(int value) {
        this.data = DPTXlator4ByteSigned.toDPT(value, new short[4], 0);
    }

    public final int getValueSigned() {
        return this.fromDPT(0);
    }

    @Override
    public final double getNumericValue() {
        return this.getValueSigned();
    }

    @Override
    public String getValue() {
        return this.makeString(0);
    }

    @Override
    public String[] getAllValues() {
        String[] s = new String[this.data.length / 4];
        int i = 0;
        while (i < s.length) {
            s[i] = this.makeString(i);
            ++i;
        }
        return s;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private int fromDPT(int index) {
        int i = 4 * index;
        return this.data[i] << 24 | this.data[i + 1] << 16 | this.data[i + 2] << 8 | this.data[i + 3];
    }

    private String makeString(int index) {
        return this.appendUnit(Integer.toString(this.fromDPT(index)));
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        try {
            DPTXlator4ByteSigned.toDPT(Integer.decode(this.removeUnit(value)), dst, index);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.newException("wrong value format", value);
        }
    }

    private static short[] toDPT(int value, short[] dst, int index) {
        int i = 4 * index;
        dst[i] = (short)(value >> 24 & 0xFF);
        dst[i + 1] = (short)(value >> 16 & 0xFF);
        dst[i + 2] = (short)(value >> 8 & 0xFF);
        dst[i + 3] = (short)(value & 0xFF);
        return dst;
    }
}

