/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.Map;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DPTXlator4ByteUnsigned
extends DPTXlator {
    public static final DPT DPT_VALUE_4_UCOUNT = new DPT("12.001", "Unsigned count", "0", "4294967295", "counter pulses");
    public static final DPT DptTimePeriodSec = new DPT("12.100", "counter time [s]", "0", "4294967295", "s");
    public static final DPT DptTimePeriodMin = new DPT("12.101", "counter time [min]", "0", "4294967295", "min");
    public static final DPT DptTimePeriodHours = new DPT("12.102", "counter time [h]", "0", "4294967295", "h");
    public static final DPT DptVolumeLiquid = new DPT("12.1200", "volume liquid [liter]", "0", "4294967295", "l");
    public static final DPT DptVolume = new DPT("12.1201", "volume [m\u00b3]", "0", "4294967295", "m\u00b3");
    private static final Map<String, DPT> types = DPTXlator4ByteUnsigned.loadDatapointTypes(DPTXlator4ByteUnsigned.class);

    public DPTXlator4ByteUnsigned(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DPTXlator4ByteUnsigned(String dptID) throws KNXFormatException {
        super(4);
        this.setTypeID(types, dptID);
        this.data = new short[4];
    }

    @Override
    public void setValue(double value) throws KNXFormatException {
        this.setValue((long)value);
    }

    public final void setValue(long value) throws KNXFormatException {
        this.data = this.toDPT(value, new short[4], 0);
    }

    public final long getValueUnsigned() {
        return this.fromDPT(0);
    }

    @Override
    public final double getNumericValue() {
        return this.getValueUnsigned();
    }

    @Override
    public String getValue() {
        return this.makeString(0);
    }

    @Override
    public String[] getAllValues() {
        String[] s = new String[this.data.length / 4];
        int i = 0;
        while (i < s.length) {
            s[i] = this.makeString(i);
            ++i;
        }
        return s;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private long fromDPT(int index) {
        int i = 4 * index;
        return (long)this.data[i] << 24 | (long)(this.data[i + 1] << 16) | (long)(this.data[i + 2] << 8) | (long)this.data[i + 3];
    }

    private String makeString(int index) {
        return this.appendUnit(Long.toString(this.fromDPT(index)));
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        try {
            this.toDPT(Long.decode(this.removeUnit(value)), dst, index);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.newException("wrong value format", value);
        }
    }

    private short[] toDPT(long value, short[] dst, int index) throws KNXFormatException {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw this.newException("translation error, input value out of range", Long.toString(value));
        }
        int i = 4 * index;
        dst[i] = (short)(value >> 24 & 0xFFL);
        dst[i + 1] = (short)(value >> 16 & 0xFFL);
        dst[i + 2] = (short)(value >> 8 & 0xFFL);
        dst[i + 3] = (short)(value & 0xFFL);
        return dst;
    }
}

