/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.HashMap;
import java.util.Map;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DPTXlator8BitSigned
extends DPTXlator {
    public static final DPT DPT_PERCENT_V8 = new DPT("6.001", "Percent (8 Bit)", "-128", "127", "%");
    public static final DPT DPT_VALUE_1_UCOUNT = new DPT("6.010", "signed count", "-128", "127", "counter pulses");
    public static final DPT DPT_STATUS_MODE3 = new DPT("6.020", "status with mode", "0/0/0/0/0 0", "1/1/1/1/1 2");
    private static final Map<String, DPT> types = new HashMap<String, DPT>();

    static {
        types.put(DPT_PERCENT_V8.getID(), DPT_PERCENT_V8);
        types.put(DPT_VALUE_1_UCOUNT.getID(), DPT_VALUE_1_UCOUNT);
        types.put(DPT_STATUS_MODE3.getID(), DPT_STATUS_MODE3);
    }

    public DPTXlator8BitSigned(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DPTXlator8BitSigned(String dptID) throws KNXFormatException {
        super(1);
        this.setTypeID(types, dptID);
        if (this.dpt.equals(DPT_STATUS_MODE3)) {
            this.data[0] = 1;
        }
    }

    @Override
    public String getValue() {
        return this.makeString(0);
    }

    @Override
    public void setValue(double value) throws KNXFormatException {
        this.setValue((int)value);
    }

    public final void setValue(int value) throws KNXFormatException {
        this.data = new short[]{DPTXlator8BitSigned.toDPT(value)};
    }

    @Override
    public double getNumericValue() {
        return this.getValueSigned();
    }

    byte getValueSigned() {
        return DPTXlator8BitSigned.fromDPT(this.data[0]);
    }

    @Override
    public String[] getAllValues() {
        String[] s = new String[this.data.length];
        int i = 0;
        while (i < this.data.length) {
            s[i] = this.makeString(i);
            ++i;
        }
        return s;
    }

    public final void setStatusMode(boolean a, boolean b, boolean c, boolean d, boolean e, int mode) {
        if (!this.dpt.equals(DPT_STATUS_MODE3)) {
            throw new IllegalStateException("translator not set to DPT 6.020 (Status with Mode)");
        }
        if (mode < 0 || mode > 2) {
            throw new KNXIllegalArgumentException("mode out of range [0..2]");
        }
        int status = a ? 128 : 0;
        status |= b ? 64 : 0;
        status |= c ? 32 : 0;
        status |= d ? 16 : 0;
        int enc = mode == 0 ? 1 : (mode == 1 ? 2 : 4);
        this.data = new short[]{(short)((status |= e ? 8 : 0) | enc)};
    }

    boolean statusBit(int statusBit) {
        if (!this.dpt.equals(DPT_STATUS_MODE3)) {
            throw new IllegalStateException("translator not set to DPT 6.020 (Status with Mode)");
        }
        if (statusBit < 0 || statusBit > 4) {
            throw new KNXIllegalArgumentException("status bit " + statusBit + " out of range [0..4]");
        }
        return (this.data[0] & 128 >> statusBit) != 0;
    }

    public final int getMode() {
        if (!this.dpt.equals(DPT_STATUS_MODE3)) {
            throw new IllegalStateException("translator not set to DPT 6.020 (Status with Mode)");
        }
        int enc = this.data[0] & 7;
        if (enc != 1 && enc != 2 && enc != 4) {
            throw new IllegalStateException("invalid mode encoding " + enc + " out of {1, 2, 4}");
        }
        return enc == 1 ? 0 : (enc == 2 ? 1 : 2);
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private static byte fromDPT(short data) {
        return (byte)data;
    }

    private String makeString(int index) {
        if (this.dpt.equals(DPT_STATUS_MODE3)) {
            short d = this.data[index];
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < 4) {
                sb.append(d >> 7 - i & 1).append("/");
                ++i;
            }
            sb.append(d >> 3 & 1);
            sb.append(' ').append(this.getMode());
            return sb.toString();
        }
        return this.appendUnit(Short.toString(DPTXlator8BitSigned.fromDPT(this.data[index])));
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        if (this.dpt.equals(DPT_STATUS_MODE3)) {
            if (value.length() != 11) {
                throw new KNXFormatException("status mode requires 11 characters", value);
            }
            int d = 0;
            int i = 0;
            while (i < 5) {
                char c = value.charAt(2 * i);
                if (c == '1') {
                    d = (short)(d | 1 << 7 - i);
                } else if (c != '0') {
                    throw new KNXFormatException("invalid status", c);
                }
                ++i;
            }
            char c = value.charAt(10);
            if (c == '0') {
                d = (short)(d + 1);
            } else if (c == '1') {
                d = (short)(d + 2);
            } else if (c == '2') {
                d = (short)(d + 4);
            } else {
                throw new KNXFormatException("invalid mode", c);
            }
            dst[index] = d;
            return;
        }
        try {
            dst[index] = DPTXlator8BitSigned.toDPT(Short.decode(this.removeUnit(value)).shortValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw this.newException("wrong value format", value);
        }
    }

    private static short toDPT(int value) throws KNXFormatException {
        if (value < -128 || value > 127) {
            throw new KNXFormatException("value out of range [-128 .. 127]", value);
        }
        return (short)(value & 0xFF);
    }
}

