/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.time.Instant;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.Map;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DPTXlatorDate
extends DPTXlator {
    public static final DPT DPT_DATE = new DPT("11.001", "Date", "1990-01-01", "2089-12-31", "yyyy-mm-dd");
    static final ResolverStyle defaultResolverStyle = ResolverStyle.STRICT;
    private static final int DAY = 0;
    private static final int MONTH = 1;
    private static final int YEAR = 2;
    private static volatile DateTimeFormatter dtf = DateTimeFormatter.ISO_DATE.withResolverStyle(defaultResolverStyle);
    private static final Map<String, DPT> types = new HashMap<String, DPT>(3);

    static {
        types.put(DPT_DATE.getID(), DPT_DATE);
    }

    public DPTXlatorDate() {
        super(3);
        this.dpt = DPT_DATE;
        short[] sArray = new short[3];
        sArray[0] = 1;
        sArray[1] = 1;
        this.data = sArray;
    }

    public DPTXlatorDate(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DPTXlatorDate(String dptId) throws KNXFormatException {
        super(3);
        this.setTypeID(types, dptId);
        short[] sArray = new short[3];
        sArray[0] = 1;
        sArray[1] = 1;
        this.data = sArray;
    }

    public static final void useValueFormat(String pattern) {
        DPTXlatorDate.useValueFormat(DateTimeFormatter.ofPattern(pattern).withResolverStyle(defaultResolverStyle));
    }

    public static final void useValueFormat(DateTimeFormatter formatter) {
        dtf = formatter;
    }

    @Override
    public String[] getAllValues() {
        String[] buf = new String[this.data.length / 3];
        int i = 0;
        while (i < buf.length) {
            buf[i] = this.fromDPT(i);
            ++i;
        }
        return buf;
    }

    @Override
    public void setValue(double milliseconds) {
        this.setValue((long)milliseconds);
    }

    public final void setValue(int year, int month, int day) {
        this.data = DPTXlatorDate.set(year, month, day, new short[3], 0);
    }

    public final int getDay() {
        return this.data[0];
    }

    public final int getMonth() {
        return this.data[1];
    }

    public final Month month() {
        return Month.of(this.getMonth());
    }

    public final int getYear() {
        return DPTXlatorDate.absYear(this.data[2]);
    }

    public final LocalDate localDate() {
        return this.localDate(0);
    }

    public final void setValue(long milliseconds) {
        this.data = DPTXlatorDate.toDPT(milliseconds, new short[3], 0);
    }

    public final long getValueMilliseconds() throws KNXFormatException {
        return this.fromDPTMillis(0);
    }

    @Override
    public double getNumericValue() throws KNXFormatException {
        return this.getValueMilliseconds();
    }

    @Override
    public void setData(byte[] data, int offset) {
        if (offset < 0 || offset > data.length) {
            throw new KNXIllegalArgumentException("illegal offset " + offset);
        }
        int size = (data.length - offset) / 3 * 3;
        if (size == 0) {
            throw new KNXIllegalArgumentException("DPT " + this.dpt.getID() + " " + this.dpt.getDescription() + ": data length " + size + " < required datapoint type width " + Math.max(1, this.getTypeSize()));
        }
        short[] buf = new short[size];
        int item = 0;
        int i = offset;
        while (i < size + offset) {
            DPTXlatorDate.set(DPTXlatorDate.absYear(data[i + 2] & 0x7F), data[i + 1] & 0xF, data[i + 0] & 0x1F, buf, item++);
            if ((data[i + 2] & 0xFFFFFF80) + (data[i + 1] & 0xFFFFFFF0) + (data[i + 0] & 0xFFFFFFE0) != 0) {
                logger.warn("DPT " + this.dpt.getID() + " " + this.dpt.getDescription() + ": reserved bit not 0");
            }
            i += 3;
        }
        this.data = buf;
    }

    @Override
    public Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String fromDPT(int index) {
        return dtf.format(this.localDate(index));
    }

    private long fromDPTMillis(int index) throws KNXFormatException {
        try {
            return this.localDate(index).atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
        }
        catch (Exception e) {
            throw this.newException("invalid date", "index " + index, e);
        }
    }

    private LocalDate localDate(int index) {
        int i = index * 3;
        short d = this.data[i + 0];
        short m = this.data[i + 1];
        short y = DPTXlatorDate.absYear(this.data[i + 2]);
        return LocalDate.of((int)y, m, (int)d);
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        String trimmed = value.trim();
        try {
            TemporalAccessor date = dtf.parse(trimmed);
            int y = date.get(ChronoField.YEAR_OF_ERA);
            int m = date.get(ChronoField.MONTH_OF_YEAR);
            int d = date.get(ChronoField.DAY_OF_MONTH);
            DPTXlatorDate.set(y, m, d, dst, index);
        }
        catch (Exception e) {
            throw this.newException("invalid date", trimmed, e);
        }
    }

    private static short[] toDPT(long milliseconds, short[] dst, int index) {
        LocalDate date = Instant.ofEpochMilli(milliseconds).atZone(ZoneId.systemDefault()).toLocalDate();
        DPTXlatorDate.set(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), dst, index);
        return dst;
    }

    private static short[] set(int year, int month, int day, short[] dst, int index) {
        if (year < 1990 || year > 2089) {
            throw new KNXIllegalArgumentException("year out of range [1990..2089]");
        }
        if (month < 1 || month > 12) {
            throw new KNXIllegalArgumentException("month out of range [1..12]");
        }
        if (day < 1 || day > 31) {
            throw new KNXIllegalArgumentException("day out of range [1..31]");
        }
        int i = 3 * index;
        dst[i + 0] = (short)day;
        dst[i + 1] = (short)month;
        dst[i + 2] = (short)(year % 100);
        return dst;
    }

    private static short absYear(int relative) {
        if (relative > 99) {
            throw new KNXIllegalArgumentException("relative year out of range [0..99]");
        }
        return (short)(relative + (relative < 90 ? 2000 : 1900));
    }
}

