/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DPTXlatorRGB
extends DPTXlator {
    public static final String Description = "RGB Color";
    public static final DPT DPT_RGB = new DPT("232.600", "RGB", "0 0 0", "255 255 255", "");
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    private static final Map<String, DPT> types = new HashMap<String, DPT>(3);

    static {
        types.put(DPT_RGB.getID(), DPT_RGB);
    }

    public DPTXlatorRGB() throws KNXFormatException {
        this(DPT_RGB);
    }

    public DPTXlatorRGB(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DPTXlatorRGB(String dptID) throws KNXFormatException {
        super(3);
        this.setTypeID(types, dptID);
        this.data = new short[3];
    }

    @Override
    public String[] getAllValues() {
        String[] buf = new String[this.data.length / 3];
        int i = 0;
        while (i < buf.length) {
            buf[i] = this.fromDPT(i);
            ++i;
        }
        return buf;
    }

    public final int red() {
        return this.data[0];
    }

    public final int green() {
        return this.data[1];
    }

    public final int blue() {
        return this.data[2];
    }

    @Override
    public void setValue(double value) {
        long v = (long)value;
        int red = (int)(v >> 16 & 0xFFL);
        int green = (int)(v >> 8 & 0xFFL);
        int blue = (int)(v & 0xFFL);
        this.setValue(red, green, blue);
    }

    public final void setValue(int red, int green, int blue) {
        this.data = DPTXlatorRGB.set(red, green, blue, new short[3], 0);
    }

    @Override
    public Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String fromDPT(int index) {
        int i = index * 3;
        return "r:" + Short.toString(this.data[i + 0]) + " g:" + Short.toString(this.data[i + 1]) + " b:" + Short.toString(this.data[i + 2]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        StringTokenizer t = new StringTokenizer(value, "- ");
        int r = -1;
        int g = -1;
        int b = -1;
        try {
            int count = 0;
            while (count < 3 && t.hasMoreTokens()) {
                String colorComponent = t.nextToken();
                StringTokenizer t2 = new StringTokenizer(colorComponent, ":");
                if (!t2.hasMoreTokens()) throw new KNXIllegalArgumentException("expected component identifier e.g. 'r:', 'g:', 'b:' in " + colorComponent);
                String componentID = t2.nextToken();
                if (t2.hasMoreTokens()) {
                    String componentValue = t2.nextToken();
                    if (componentID.equals("r")) {
                        r = Short.parseShort(componentValue);
                    } else if (componentID.equals("g")) {
                        g = Short.parseShort(componentValue);
                    } else {
                        if (!componentID.equals("b")) throw this.newException("invalid color component " + componentID + " in", value);
                        b = Short.parseShort(componentValue);
                    }
                } else {
                    short v = Short.decode(componentID);
                    if (count == 0) {
                        r = v;
                    } else if (count == 1) {
                        g = v;
                    } else {
                        b = v;
                    }
                }
                ++count;
            }
            if (r == -1 || g == -1 || b == -1) {
                throw this.newException("invalid color", value);
            }
            DPTXlatorRGB.set(r, g, b, dst, index);
            return;
        }
        catch (KNXIllegalArgumentException e) {
            throw this.newException("invalid color", value, e);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.newException("invalid number", value);
        }
    }

    private static short[] set(int red, int green, int blue, short[] dst, int index) {
        if (red < 0 || red > 255) {
            throw new KNXIllegalArgumentException("red out of range [0..255]");
        }
        if (green < 0 || green > 255) {
            throw new KNXIllegalArgumentException("green out of range [0..255]");
        }
        if (blue < 0 || blue > 255) {
            throw new KNXIllegalArgumentException("blue out of range [0..255]");
        }
        int i = 3 * index;
        dst[i + 0] = (short)red;
        dst[i + 1] = (short)green;
        dst[i + 2] = (short)blue;
        return dst;
    }
}

