/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DPTXlatorSceneControl
extends DPTXlator {
    public static final DPT DPT_SCENE_CONTROL = new DPT("18.001", "Scene Control", "activate 0", "learn 63");
    private static final Map<String, DPT> types = new HashMap<String, DPT>(5);

    static {
        types.put(DPT_SCENE_CONTROL.getID(), DPT_SCENE_CONTROL);
    }

    public DPTXlatorSceneControl(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DPTXlatorSceneControl(String dptID) throws KNXFormatException {
        super(1);
        this.setTypeID(types, dptID);
        this.data = new short[1];
    }

    @Override
    public String getValue() {
        return this.fromDPT(0);
    }

    public final void setValue(boolean control, int scene) {
        this.data = new short[]{DPTXlatorSceneControl.toDPT(control, scene)};
    }

    public final short getSceneNumber() {
        return (short)(this.data[0] & 0x3F);
    }

    @Override
    public String[] getAllValues() {
        String[] s = new String[this.data.length];
        int i = 0;
        while (i < this.data.length) {
            s[i] = this.fromDPT(i);
            ++i;
        }
        return s;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String fromDPT(int index) {
        boolean c = (this.data[index] & 0x80) == 128;
        int scene = this.data[index] & 0x3F;
        String value = c ? this.dpt.getUpperValue() : this.dpt.getLowerValue();
        return String.valueOf(new StringTokenizer(value).nextToken()) + " " + scene;
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        StringTokenizer token = new StringTokenizer(value, " \t");
        if (token.countTokens() < 2) {
            throw this.newException("wrong value format", value);
        }
        boolean learn = false;
        String s = token.nextToken();
        if (s.equals("learn")) {
            learn = true;
        } else if (!s.equals("activate")) {
            throw this.newException("wrong value format", value);
        }
        try {
            s = token.nextToken();
            dst[index] = DPTXlatorSceneControl.toDPT(learn, Integer.decode(s));
        }
        catch (NumberFormatException numberFormatException) {
            throw this.newException("parsing", value);
        }
    }

    private static short toDPT(boolean ctrl, int scene) {
        if (scene < 0 || scene > 63) {
            throw new KNXIllegalArgumentException("input scene number out of range [0..63]");
        }
        return (short)(ctrl ? scene | 0x80 : scene);
    }
}

