/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.HashMap;
import java.util.Map;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DPTXlatorSceneNumber
extends DPTXlator {
    public static final DPT DPT_SCENE_NUMBER = new DPT("17.001", "Scene Number", "0", "63");
    private static final Map<String, DPT> types = new HashMap<String, DPT>();

    static {
        types.put(DPT_SCENE_NUMBER.getID(), DPT_SCENE_NUMBER);
    }

    public DPTXlatorSceneNumber(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DPTXlatorSceneNumber(String dptID) throws KNXFormatException {
        super(1);
        this.setTypeID(types, dptID);
        this.data = new short[1];
    }

    @Override
    public String getValue() {
        return this.fromDPT(0);
    }

    @Override
    public void setValue(double scene) {
        this.setValue((int)scene);
    }

    public final void setValue(int scene) {
        this.data = new short[]{DPTXlatorSceneNumber.toDPT(scene)};
    }

    public final short getSceneNumber() {
        return (short)(this.data[0] & 0x3F);
    }

    @Override
    public final double getNumericValue() {
        return this.getSceneNumber();
    }

    @Override
    public String[] getAllValues() {
        String[] s = new String[this.data.length];
        int i = 0;
        while (i < this.data.length) {
            s[i] = this.fromDPT(i);
            ++i;
        }
        return s;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String fromDPT(int index) {
        int scene = this.data[index] & 0x3F;
        return Integer.toString(scene);
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        try {
            dst[index] = DPTXlatorSceneNumber.toDPT(Short.decode(value.trim()).shortValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw this.newException("wrong value format", value);
        }
    }

    private static short toDPT(int value) {
        if (value < 0 || value > 63) {
            throw new KNXIllegalArgumentException("input scene number out of range [0..63]");
        }
        return (short)value;
    }
}

