/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.HashMap;
import java.util.Map;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DPTXlatorString
extends DPTXlator {
    public static final DPT DPT_STRING_ASCII = new DPT("16.000", "ASCII string", "", "");
    public static final DPT DPT_STRING_8859_1 = new DPT("16.001", "ISO-8859-1 string (Latin 1)", "", "");
    private static final Map<String, DPT> types = new HashMap<String, DPT>(5);
    private static final short replacement = 63;
    private static final int stringLength = 14;

    static {
        types.put(DPT_STRING_ASCII.getID(), DPT_STRING_ASCII);
        types.put(DPT_STRING_8859_1.getID(), DPT_STRING_8859_1);
    }

    public DPTXlatorString(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DPTXlatorString(String dptID) throws KNXFormatException {
        super(14);
        this.setTypeID(types, dptID);
        this.data = new short[14];
    }

    @Override
    public String[] getAllValues() {
        String[] buf = new String[this.getItems()];
        int i = 0;
        while (i < buf.length) {
            buf[i] = this.fromDPT(i);
            ++i;
        }
        return buf;
    }

    @Override
    public void setData(byte[] data, int offset) {
        if (offset < 0 || offset > data.length) {
            throw new KNXIllegalArgumentException("illegal offset " + offset);
        }
        this.toDPT(data, offset);
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String fromDPT(int index) {
        int offset = index * 14;
        char[] output = new char[14];
        int strlen = 0;
        int i = offset;
        while (i < offset + 14 && this.data[i] != 0) {
            output[strlen] = (char)this.data[i];
            ++strlen;
            ++i;
        }
        return new String(output, 0, strlen);
    }

    private void toDPT(byte[] buf, int offset) {
        int len;
        int rangeMax = 127;
        if (this.dpt.equals(DPT_STRING_8859_1)) {
            rangeMax = 255;
        }
        if ((len = buf.length - offset) % 14 != 0) {
            throw new KNXIllegalArgumentException("data length " + len + " does not exactly fit KNX strings of length 14 bytes");
        }
        int items = len / 14;
        if (items == 0) {
            throw new KNXIllegalArgumentException("data length " + len + " < required 14 bytes for KNX string");
        }
        this.data = new short[items * 14];
        int i = 0;
        while (i < this.data.length) {
            int c = DPTXlatorString.ubyte(buf[offset + i]);
            this.data[i] = c <= rangeMax ? c : 63;
            ++i;
        }
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        if (value.length() > 14) {
            throw this.newException("maximum KNX string length is 14 characters", value);
        }
        char rangeMax = '\u007f';
        if (this.dpt.equals(DPT_STRING_8859_1)) {
            rangeMax = '\u00ff';
        }
        int offset = index * 14;
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            dst[offset + i] = c <= rangeMax ? (int)c : 63;
            ++i;
        }
    }
}

