/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.EnumSet;
import java.util.Map;
import java.util.StringJoiner;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.EnumDptBase;

public class DptXlator16BitSet
extends DPTXlator {
    public static final EnumDpt<RhccStatus> DptRhccStatus = new EnumDpt<RhccStatus>("22.101", RhccStatus.class);
    public static final EnumDpt<Medium> DptMedia = new EnumDpt<Medium>("22.1000", Medium.class);
    private static final Map<String, DPT> types = DptXlator16BitSet.loadDatapointTypes(DptXlator16BitSet.class);

    public DptXlator16BitSet(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DptXlator16BitSet(String dptId) throws KNXFormatException {
        super(2);
        this.setTypeID(types, dptId);
    }

    @Override
    public String getValue() {
        return this.textOf(0);
    }

    @Override
    public void setValue(double value) throws KNXFormatException {
        this.setValue((int)value);
    }

    public final void setValue(int value) throws KNXFormatException {
        this.data = this.toDpt(value);
    }

    public final void setValue(EnumSet<?> elements) {
        this.data = DptXlator16BitSet.toDpt(elements);
    }

    @Override
    public final double getNumericValue() throws KNXFormatException {
        return this.fromDpt(0);
    }

    @Override
    public String[] getAllValues() {
        int items = this.getItems();
        String[] s = new String[items];
        int i = 0;
        while (i < items) {
            s[i] = this.textOf(i);
            ++i;
        }
        return s;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String textOf(int index) {
        int offset = 2 * index;
        int d = this.data[offset] << 8 | this.data[offset + 1];
        StringJoiner joiner = new StringJoiner(", ");
        int i = 16384;
        while (i > 0) {
            if ((d & i) == i) {
                joiner.add(((EnumDpt)this.dpt).textOf(i));
            }
            i >>= 1;
        }
        if (this.dpt.equals(DptRhccStatus) && joiner.length() == 0) {
            return "Cooling Mode";
        }
        return joiner.toString();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        block9: {
            result = 0;
            try {
                result = Integer.decode(value);
                this.validate(result);
                break block9;
            }
            catch (NumberFormatException v0) {
                enumDpt = (EnumDpt)this.dpt;
                v1 = regex = value.contains(",") != false ? "," : " ";
                if ("Cooling Mode".equals(value) || enumDpt.find(value) != null) {
                    regex = ",";
                }
                if ((split = value.split(regex, 0)).length == 1 && "".equals(split[0])) {
                    return;
                }
                i = 0;
                ** while (i < split.length)
            }
lbl-1000:
            // 1 sources

            {
                s = split[split.length - 1 - i].trim();
                v2 = "1".equals(s) != false || "true".equalsIgnoreCase(s) != false ? 1 : (bit = "0".equals(s) != false || "false".equalsIgnoreCase(s) != false ? 0 : -1);
                if (bit == 1) {
                    result |= bit << i;
                } else if (!(bit != -1 || this.dpt.equals(DptXlator16BitSet.DptRhccStatus) && "Cooling Mode".equals(s))) {
                    e = enumDpt.find(s);
                    if (e == null) {
                        throw this.newException("value is no element of " + enumDpt.elements.getSimpleName(), s);
                    }
                    result |= 1 << e.ordinal();
                }
                ++i;
                continue;
            }
        }
        offset = 2 * index;
        dst[offset] = (short)(result >> 8);
        dst[offset + 1] = DptXlator16BitSet.ubyte(result);
    }

    private static short[] toDpt(EnumSet<?> elements) {
        int v = 0;
        for (Enum e : elements) {
            v |= 1 << e.ordinal();
        }
        return new short[]{(short)(v >> 8), DptXlator16BitSet.ubyte(v)};
    }

    private short[] toDpt(int value) throws KNXFormatException {
        this.validate(value);
        return new short[]{(short)(value >> 8), DptXlator16BitSet.ubyte(value)};
    }

    private int fromDpt(int index) throws KNXFormatException {
        int offset = 2 * index;
        int v = this.data[offset] << 8 | this.data[offset + 1];
        this.validate(v);
        return v;
    }

    private void validate(int value) throws KNXFormatException {
        EnumDpt enumDpt = (EnumDpt)this.dpt;
        if (value < 0 || value > DptXlator16BitSet.maxValue(enumDpt.elements)) {
            throw this.newException("value is out of range [" + enumDpt.getLowerValue() + ".." + enumDpt.getUpperValue() + "]", Integer.toString(value));
        }
    }

    private static <E extends Enum<E>> int maxValue(Class<E> elements) {
        int bits = EnumSet.allOf(elements).size();
        return (1 << bits) - 1;
    }

    private static interface EnumBase<E extends Enum<E>>
    extends EnumDptBase.EnumBase<E> {
    }

    public static class EnumDpt<T extends Enum<T>>
    extends EnumDptBase<T> {
        EnumDpt(String typeId, Class<T> elements) {
            super(typeId, elements, "0", Integer.toString(DptXlator16BitSet.maxValue(elements)));
        }
    }

    public static enum Medium implements EnumBase<Medium>
    {
        _0,
        TP1,
        PL110,
        _3,
        RF,
        Knxip;


        @Override
        public String description() {
            switch (this.ordinal()) {
                case 1: {
                    return "TP1";
                }
                case 2: {
                    return "PL110";
                }
                case 4: {
                    return "RF";
                }
                case 5: {
                    return "KNX IP";
                }
            }
            return "undefined";
        }
    }

    public static enum RhccStatus implements EnumBase<RhccStatus>
    {
        Fault,
        HeatingEcoMode,
        LimitFlowTemperature,
        LimitReturnTemperature,
        HeatingMorningBoost,
        EarlyMorningStart,
        EarlyEveningShutdown,
        HeatingDisabled,
        HeatingMode,
        CoolingEcoMode,
        PreCoolingMode,
        CoolingDisabled,
        DewPointAlarm,
        FrostAlarm,
        OverheatAlarm;

    }
}

