/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Map;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DptXlator2ByteSigned
extends DPTXlator {
    public static final DPT DptValueCount = new DPT("8.001", "signed count", "-32768", "32767", "pulses");
    public static final DPT DptDeltaTime = new DPT("8.002", "delta time in ms", "-32768", "32767", "ms");
    public static final DPT DptDeltaTime10 = new DPT("8.003", "delta time in ms (resolution 10 ms)", "-327680", "327670", "ms");
    public static final DPT DptDeltaTime100 = new DPT("8.004", "delta time in ms (resolution 100 ms)", "-3276800", "3276700", "ms");
    public static final DPT DptDeltaTimeSec = new DPT("8.005", "delta time in seconds", "-32768", "32767", "s");
    public static final DPT DptDeltaTimeMin = new DPT("8.006", "delta time in minutes", "-32768", "32767", "min");
    public static final DPT DptDeltaTimeHours = new DPT("8.007", "delta time in hours", "-32768", "32767", "h");
    public static final DPT DptPercent = new DPT("8.010", "percent", "-327.68", "327.67", "%");
    public static final DPT DptRotationAngle = new DPT("8.011", "rotation angle", "-32768", "32767", "\u00b0");
    public static final DPT DptLength = new DPT("8.012", "length in m", "-32768", "32767", "m");
    private static final Map<String, DPT> types = DptXlator2ByteSigned.loadDatapointTypes(DptXlator2ByteSigned.class);
    private final NumberFormat formatter = NumberFormat.getNumberInstance();
    private final double min;
    private final double max;

    public DptXlator2ByteSigned(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DptXlator2ByteSigned(String dptId) throws KNXFormatException {
        super(2);
        this.setTypeID(types, dptId);
        this.min = this.getLimit(this.dpt.getLowerValue());
        this.max = this.getLimit(this.dpt.getUpperValue());
        this.data = new short[2];
        this.formatter.setMinimumFractionDigits(0);
        this.formatter.setMaximumFractionDigits(2);
        this.formatter.setParseIntegerOnly(!this.dpt.equals(DptPercent));
    }

    @Override
    public String getValue() {
        return this.makeString(0);
    }

    @Override
    public final void setValue(double value) throws KNXFormatException {
        short[] buf = new short[2];
        this.toDPT(value, buf, 0);
        this.data = buf;
    }

    @Override
    public final double getNumericValue() {
        return this.fromDPT(0);
    }

    @Override
    public String[] getAllValues() {
        String[] s = new String[this.data.length / 2];
        int i = 0;
        while (i < s.length) {
            s[i] = this.makeString(i);
            ++i;
        }
        return s;
    }

    public final void setDeltaTime(long milliseconds) throws KNXFormatException {
        this.data = this.toDPT(milliseconds);
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private double fromDPT(int index) {
        short v = (short)(this.data[2 * index] << 8 | this.data[2 * index + 1]);
        if (this.dpt.equals(DptDeltaTime10)) {
            return v * 10;
        }
        if (this.dpt.equals(DptDeltaTime100)) {
            return v * 100;
        }
        if (this.dpt.equals(DptPercent)) {
            return (double)v / 100.0;
        }
        return v;
    }

    private String makeString(int index) {
        return this.appendUnit(this.formatter.format(this.fromDPT(index)));
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        try {
            double v;
            String s = this.removeUnit(value);
            if (this.dpt.equals(DptPercent)) {
                v = this.formatter.parse(s).doubleValue();
            } else {
                try {
                    v = Integer.decode(s).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    v = this.formatter.parse(s).longValue();
                }
            }
            this.toDPT(v, dst, index);
        }
        catch (NumberFormatException | ParseException exception) {
            throw this.newException("wrong value format", value);
        }
    }

    private short[] toDPT(long ms) throws KNXFormatException {
        double v = ms;
        if (this.dpt.equals(DptDeltaTimeSec)) {
            v = Math.round((double)ms / 1000.0);
        } else if (this.dpt.equals(DptDeltaTimeMin)) {
            v = Math.round((double)ms / 1000.0 / 60.0);
        } else if (this.dpt.equals(DptDeltaTimeHours)) {
            v = Math.round((double)ms / 1000.0 / 60.0 / 60.0);
        }
        short[] buf = new short[2];
        this.toDPT(v, buf, 0);
        return buf;
    }

    private void toDPT(double value, short[] dst, int index) throws KNXFormatException {
        if (value < this.min || value > this.max) {
            throw this.newException("translation error, input value out of range [" + this.dpt.getLowerValue() + ".." + this.dpt.getUpperValue() + "]", Double.toString(value));
        }
        int v = this.dpt.equals(DptDeltaTime10) ? (int)Math.round(value / 10.0) : (this.dpt.equals(DptDeltaTime100) ? (int)Math.round(value / 100.0) : (this.dpt.equals(DptPercent) ? (int)Math.round(value * 100.0) : (int)value));
        dst[2 * index] = DptXlator2ByteSigned.ubyte(v >> 8);
        dst[2 * index + 1] = DptXlator2ByteSigned.ubyte(v);
    }

    private double getLimit(String limit) throws KNXFormatException {
        try {
            double d = Double.parseDouble(limit);
            double lower = this.dpt.equals(DptDeltaTime10) ? -327680L : (this.dpt.equals(DptDeltaTime100) ? -3276800L : -32768L);
            double upper = this.dpt.equals(DptDeltaTime10) ? 327670L : (this.dpt.equals(DptDeltaTime100) ? 3276700L : 32767L);
            if (d >= lower && d <= upper) {
                return d;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        throw this.newException("limit not in valid DPT range", limit);
    }
}

