/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.EnumSet;
import java.util.Map;
import java.util.StringJoiner;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.EnumDptBase;

public class DptXlator8BitSet
extends DPTXlator {
    public static final EnumDpt<GeneralStatus> DptGeneralStatus = new EnumDpt<GeneralStatus>("21.001", GeneralStatus.class);
    public static final EnumDpt<DeviceControl> DptDeviceControl = new EnumDpt<DeviceControl>("21.002", DeviceControl.class);
    public static final EnumDpt<ForcingSignal> DptForcingSignal = new EnumDpt<ForcingSignal>("21.100", ForcingSignal.class);
    public static final EnumDpt<ForcingSignalCool> DptForcingSignalCool = new EnumDpt<ForcingSignalCool>("21.101", ForcingSignalCool.class);
    public static final EnumDpt<RoomHeatingControllerStatus> DptRoomHeatingControllerStatus = new EnumDpt<RoomHeatingControllerStatus>("21.102", RoomHeatingControllerStatus.class);
    public static final EnumDpt<SolarDhwControllerStatus> DptSolarDhwControllerStatus = new EnumDpt<SolarDhwControllerStatus>("21.103", SolarDhwControllerStatus.class);
    public static final EnumDpt<FuelTypeSet> DptFuelTypeSet = new EnumDpt<FuelTypeSet>("21.104", FuelTypeSet.class);
    public static final EnumDpt<RoomCoolingControllerStatus> DptRoomCoolingControllerStatus = new EnumDpt<RoomCoolingControllerStatus>("21.105", RoomCoolingControllerStatus.class);
    public static final EnumDpt<VentilationControllerStatus> DptVentilationControllerStatus = new EnumDpt<VentilationControllerStatus>("21.106", VentilationControllerStatus.class);
    public static final EnumDpt<LightActuatorErrorInfo> DptLightActuatorErrorInfo = new EnumDpt<LightActuatorErrorInfo>("21.601", LightActuatorErrorInfo.class);
    public static final EnumDpt<RFCommModeInfo> DptRFCommModeInfo = new EnumDpt<RFCommModeInfo>("21.1000", RFCommModeInfo.class);
    public static final EnumDpt<RFFilterModes> DptRFFilterInfo = new EnumDpt<RFFilterModes>("21.1001", RFFilterModes.class);
    public static final EnumDpt<SecurityReport> DptSecurityReport = new EnumDpt<SecurityReport>("21.1002", SecurityReport.class);
    public static final EnumDpt<ChannelActivationState> DptChannelActivation = new EnumDpt<ChannelActivationState>("21.1010", ChannelActivationState.class);
    private static final Map<String, DPT> types = DptXlator8BitSet.loadDatapointTypes(DptXlator8BitSet.class);

    public DptXlator8BitSet(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DptXlator8BitSet(String dptId) throws KNXFormatException {
        super(1);
        this.setTypeID(types, dptId);
    }

    @Override
    public String getValue() {
        return this.textOf(0);
    }

    @Override
    public void setValue(double value) throws KNXFormatException {
        this.setValue((int)value);
    }

    public final void setValue(int value) throws KNXFormatException {
        this.data = new short[]{this.toDpt(value)};
    }

    public final void setValue(EnumSet<?> elements) {
        this.data = new short[]{DptXlator8BitSet.toDpt(elements)};
    }

    @Override
    public final double getNumericValue() throws KNXFormatException {
        return this.fromDpt(0);
    }

    @Override
    public String[] getAllValues() {
        String[] s = new String[this.data.length];
        int i = 0;
        while (i < this.data.length) {
            s[i] = this.textOf(i);
            ++i;
        }
        return s;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String textOf(int index) {
        StringJoiner joiner = new StringJoiner(", ");
        short d = this.data[index];
        int i = 128;
        while (i > 0) {
            if ((d & i) == i) {
                joiner.add(((EnumDpt)this.dpt).textOf(i));
            }
            i >>= 1;
        }
        return joiner.toString();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        block7: {
            try {
                dst[index] = this.toDpt(Integer.decode(value));
                break block7;
            }
            catch (NumberFormatException v0) {
                result = 0;
                tryNames = false;
                var9_6 = value.split(" ");
                var8_7 = var9_6.length;
                var7_8 = 0;
                ** while (var7_8 < var8_7)
            }
lbl-1000:
            // 1 sources

            {
                s = var9_6[var7_8];
                v1 = "1".equals(s) != false || "true".equalsIgnoreCase(s) != false ? 1 : (bit = "0".equals(s) != false || "false".equalsIgnoreCase(s) != false ? 0 : -1);
                if (bit == -1) {
                    tryNames = true;
                    break;
                }
                result = result << 1 | bit;
                ++var7_8;
                continue;
            }
lbl19:
            // 2 sources

            if (tryNames) {
                result = 0;
                var9_6 = value.split(",");
                var8_7 = var9_6.length;
                var7_8 = 0;
                while (var7_8 < var8_7) {
                    enumDpt = (EnumDpt)this.dpt;
                    s = var9_6[var7_8];
                    e = enumDpt.find(s.trim());
                    if (e == null) {
                        throw this.newException("value is no element of " + enumDpt.name(), value);
                    }
                    result |= 1 << e.ordinal();
                    ++var7_8;
                }
            }
            dst[index] = (short)result;
        }
    }

    private static short toDpt(EnumSet<?> elements) {
        int v = 0;
        for (Enum e : elements) {
            v |= 1 << e.ordinal();
        }
        return (short)v;
    }

    private short toDpt(int value) throws KNXFormatException {
        this.validate(value);
        return (short)value;
    }

    private short fromDpt(int index) throws KNXFormatException {
        short v = this.data[index];
        this.validate(v);
        return v;
    }

    private void validate(int value) throws KNXFormatException {
        EnumDpt enumDpt = (EnumDpt)this.dpt;
        if (value < 0 || value > DptXlator8BitSet.maxValue(enumDpt.elements)) {
            throw this.newException("value is out of range [" + enumDpt.getLowerValue() + ".." + enumDpt.getUpperValue() + "]", Integer.toString(value));
        }
    }

    private static <E extends Enum<E>> int maxValue(Class<E> elements) {
        int bits = EnumSet.allOf(elements).size();
        return (1 << bits) - 1;
    }

    public static enum ChannelActivationState implements EnumBase<ChannelActivationState>
    {
        Channel1,
        Channel2,
        Channel3,
        Channel4,
        Channel5,
        Channel6,
        Channel7,
        Channel8;

    }

    public static enum DeviceControl implements EnumBase<DeviceControl>
    {
        UserStopped,
        OwnIndAddress,
        VerifyMode;

    }

    private static interface EnumBase<E extends Enum<E>>
    extends EnumDptBase.EnumBase<E> {
    }

    public static class EnumDpt<T extends Enum<T>>
    extends EnumDptBase<T> {
        public EnumDpt(String typeId, Class<T> elements) {
            super(typeId, elements, "0", Integer.toString(DptXlator8BitSet.maxValue(elements)));
        }
    }

    public static enum ForcingSignal implements EnumBase<ForcingSignal>
    {
        ForceRequest,
        Protection,
        Oversupply,
        Overrun,
        DhwNorm,
        DhwLegio,
        RoomHeatingComfort,
        RoomHeatingMax;

    }

    public static enum ForcingSignalCool implements EnumBase<ForcingSignalCool>
    {
        ForceRequest;

    }

    public static enum FuelTypeSet implements EnumBase<FuelTypeSet>
    {
        Oil,
        Gas,
        SolidState;

    }

    public static enum GeneralStatus implements EnumBase<GeneralStatus>
    {
        OutOfService,
        Fault,
        Overridden,
        InAlarm,
        AlarmUnAck;

    }

    public static enum LightActuatorErrorInfo implements EnumBase<LightActuatorErrorInfo>
    {
        LoadDetectionFailed,
        Undervoltage,
        Overcurrent,
        Underload,
        DefectiveLoad,
        LampFailure,
        Overheat;

    }

    public static enum RFCommModeInfo implements EnumBase<RFCommModeInfo>
    {
        Asynchronous,
        BiBatMaster,
        BiBatSlave;

    }

    public static enum RFFilterModes implements EnumBase<RFFilterModes>
    {
        DomainAddress,
        SerialNumber,
        DoAAndSN;

    }

    public static enum RoomCoolingControllerStatus implements EnumBase<RoomCoolingControllerStatus>
    {
        Fault;

    }

    public static enum RoomHeatingControllerStatus implements EnumBase<RoomHeatingControllerStatus>
    {
        Fault,
        EcoMode,
        FlowTempLimit,
        ReturnTempLimit,
        MorningBoost,
        StartOptimization,
        StopOptimization,
        SummerMode;

    }

    public static enum SecurityReport implements EnumBase<SecurityReport>
    {
        SecurityFailure;

    }

    public static enum SolarDhwControllerStatus implements EnumBase<SolarDhwControllerStatus>
    {
        Fault,
        SolarDhwLoadActive,
        SolarLoadSufficient;

    }

    public static enum VentilationControllerStatus implements EnumBase<VentilationControllerStatus>
    {
        Fault,
        FanActive,
        Heat,
        Cool;

    }
}

