/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.DPTXlator3BitControlled;
import tuwien.auto.calimero.dptxlator.StepControl;

public class DptXlatorBrightnessClrTempControl
extends DPTXlator {
    public static final String Description = "brightness & color temperature control";
    public static final DPT DptBrightnessClrTempCtrl = new DPT("250.600", "brightness & color temperature control", "decrease 1 decrease 1", "increase 7 increase 7");
    private static final Map<String, DPT> types = new HashMap<String, DPT>();
    private static final String clrTempSuffix = "CT";
    private static final String brightnessSuffix = "BRT";
    private final DPTXlator3BitControlled t = new DPTXlator3BitControlled(DPTXlator3BitControlled.DPT_CONTROL_DIMMING);
    private static final int Brightness = 0;
    private static final int ColorTemp = 1;

    static {
        types.put(DptBrightnessClrTempCtrl.getID(), DptBrightnessClrTempCtrl);
    }

    public DptXlatorBrightnessClrTempControl() throws KNXFormatException {
        this(DptBrightnessClrTempCtrl);
    }

    public DptXlatorBrightnessClrTempControl(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DptXlatorBrightnessClrTempControl(String dptId) throws KNXFormatException {
        super(3);
        this.setTypeID(types, dptId);
        this.data = new short[3];
    }

    @Override
    public String getValue() {
        return this.fromDpt(0);
    }

    public Optional<StepControl> brightness() {
        return this.field(0);
    }

    public Optional<StepControl> colorTemp() {
        return this.field(1);
    }

    public final void setValue(StepControl colorTemp, StepControl brightness) {
        this.data = this.toDpt(colorTemp, brightness);
    }

    public final void setBrightness(StepControl value) {
        short d;
        this.t.setValue(value);
        this.data[1] = d = DptXlatorBrightnessClrTempControl.ubyte(this.t.getData()[0]);
        this.data[2] = (short)(this.data[2] | 1);
    }

    public final void setColorTemp(StepControl value) {
        short d;
        this.t.setValue(value);
        this.data[0] = d = DptXlatorBrightnessClrTempControl.ubyte(this.t.getData()[0]);
        this.data[2] = (short)(this.data[2] | 2);
    }

    @Override
    public String[] getAllValues() {
        int items = this.getItems();
        String[] s = new String[items];
        int i = 0;
        while (i < items) {
            s[i] = this.fromDpt(i);
            ++i;
        }
        return s;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String fromDpt(int index) {
        int offset = index * 3;
        String s = "";
        this.t.setAppendUnit(this.appendUnit);
        short valid = this.data[offset + 2];
        if ((valid & 2) == 2) {
            this.t.setData(new byte[]{(byte)this.data[offset]});
            s = "CT " + this.t.getValue();
        } else {
            s = "CT -";
        }
        if ((valid & 1) == 1) {
            this.t.setData(new byte[]{(byte)this.data[offset + 1]});
            if (!s.isEmpty()) {
                s = String.valueOf(s) + " ";
            }
            s = String.valueOf(s) + "BRT " + this.t.getValue();
        } else {
            s = String.valueOf(s) + " BRT -";
        }
        return s;
    }

    private Optional<StepControl> field(int field) {
        short valid = this.data[2];
        int validBit = 1 << field;
        if ((valid & validBit) == validBit) {
            return Optional.of(StepControl.from(this.data[1 - field]));
        }
        return Optional.empty();
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        if (value.isEmpty()) {
            return;
        }
        String[] fields = value.split(" ", 0);
        if (fields.length > 8 || fields.length < 2) {
            throw this.newException("unsupported format for brightness & color temperature control", value);
        }
        int valid = 0;
        int offset = index * 3;
        int i = 0;
        if (clrTempSuffix.equals(fields[i])) {
            int brt;
            int clr;
            valid |= (clr = this.component(true, fields, ++i)) == 0 ? 0 : 2;
            dst[offset] = DptXlatorBrightnessClrTempControl.ubyte(clr);
            if ("steps".equals(fields[i += clr == 0 ? 1 : 2])) {
                ++i;
            }
            if (!brightnessSuffix.equals(fields[i])) {
                throw this.newException("no brightness", fields[i]);
            }
            valid |= (brt = this.component(false, fields, ++i)) == 0 ? 0 : 1;
            dst[offset + 1] = DptXlatorBrightnessClrTempControl.ubyte(brt);
            if ((i += brt == 0 ? 1 : 2) < fields.length && "steps".equals(fields[i])) {
                ++i;
            }
        } else if (fields.length >= 2 && fields.length <= 6) {
            int brt;
            int clr = this.component(true, fields, i);
            valid |= clr == 0 ? 0 : 2;
            dst[offset] = DptXlatorBrightnessClrTempControl.ubyte(clr);
            if ("steps".equals(fields[i += clr == 0 ? 1 : 2])) {
                ++i;
            }
            valid |= (brt = this.component(false, fields, i)) == 0 ? 0 : 1;
            dst[offset + 1] = DptXlatorBrightnessClrTempControl.ubyte(brt);
            if ((i += brt == 0 ? 1 : 2) < fields.length && "steps".equals(fields[i])) {
                ++i;
            }
        }
        if (i < fields.length) {
            throw this.newException("value contains excessive components", fields[i]);
        }
        dst[offset + 2] = (short)valid;
    }

    private int component(boolean color, String[] fields, int i) throws KNXFormatException {
        String first = fields[i];
        if ("-".equals(first)) {
            return 0;
        }
        this.t.setValue(String.valueOf(first) + " " + fields[i + 1]);
        return this.t.getData()[0];
    }

    private short[] toDpt(StepControl colorTemp, StepControl brightness) {
        this.t.setValue(colorTemp);
        short clrtemp = DptXlatorBrightnessClrTempControl.ubyte(this.t.getData()[0]);
        this.t.setValue(brightness);
        short bright = DptXlatorBrightnessClrTempControl.ubyte(this.t.getData()[0]);
        return new short[]{clrtemp, bright, 3};
    }
}

