/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.text.NumberFormat;
import java.text.ParseException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DptXlatorBrightnessClrTempTrans
extends DPTXlator {
    public static final String Description = "brightness & color temperature transition";
    public static final DPT DptBrightnessClrTempTrans = new DPT("249.600", "brightness & color temperature transition", "0 0 0", "100 65535 6553.5", "% K s");
    private static final Map<String, DPT> types = new HashMap<String, DPT>();
    private final NumberFormat formatter = NumberFormat.getNumberInstance();

    static {
        types.put(DptBrightnessClrTempTrans.getID(), DptBrightnessClrTempTrans);
    }

    public DptXlatorBrightnessClrTempTrans() throws KNXFormatException {
        this(DptBrightnessClrTempTrans);
    }

    public DptXlatorBrightnessClrTempTrans(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DptXlatorBrightnessClrTempTrans(String dptId) throws KNXFormatException {
        super(6);
        this.setTypeID(types, dptId);
        this.data = new short[6];
        this.formatter.setMinimumFractionDigits(0);
        this.formatter.setMaximumFractionDigits(1);
    }

    @Override
    public String getValue() {
        return this.fromDpt(0);
    }

    public Optional<Double> brightness() {
        short valid = this.data[5];
        if ((valid & 1) == 1) {
            double brightness = (double)this.data[4] * 100.0 / 255.0;
            return Optional.of(brightness);
        }
        return Optional.empty();
    }

    public Optional<Integer> colorTemp() {
        short valid = this.data[5];
        if ((valid & 2) == 2) {
            int offset = 2;
            int temperature = this.data[offset++] << 8 | this.data[offset++];
            return Optional.of(temperature);
        }
        return Optional.empty();
    }

    public Optional<Duration> fadingTime() {
        short valid = this.data[5];
        if ((valid & 4) == 4) {
            int offset = 0;
            long time = (this.data[offset++] << 8 | this.data[offset++]) * 100;
            return Optional.of(Duration.ofMillis(time));
        }
        return Optional.empty();
    }

    public final void setValue(double brightness, int clrTemperature, Duration fadingTime) {
        this.data = this.toDpt(brightness, clrTemperature, fadingTime);
    }

    public final void setBrightness(double brightness) {
        DptXlatorBrightnessClrTempTrans.rangeCheck(brightness, 0, Duration.ZERO);
        this.data[4] = (short)Math.round(brightness * 255.0 / 100.0);
        this.data[5] = (short)(this.data[5] | 1);
    }

    public final void setColorTemp(int colorTemp) {
        DptXlatorBrightnessClrTempTrans.rangeCheck(0.0, colorTemp, Duration.ZERO);
        this.data[2] = (short)(colorTemp >> 8);
        this.data[3] = DptXlatorBrightnessClrTempTrans.ubyte(colorTemp);
        this.data[5] = (short)(this.data[5] | 2);
    }

    public final void setFadingTime(Duration fadingTime) {
        DptXlatorBrightnessClrTempTrans.rangeCheck(0.0, 0, fadingTime);
        int time = (int)Math.round((double)fadingTime.toMillis() / 100.0);
        this.data[0] = (short)(time >> 8);
        this.data[1] = DptXlatorBrightnessClrTempTrans.ubyte(time);
        this.data[5] = (short)(this.data[5] | 4);
    }

    @Override
    public String[] getAllValues() {
        int items = this.getItems();
        String[] s = new String[items];
        int i = 0;
        while (i < items) {
            s[i] = this.fromDpt(i);
            ++i;
        }
        return s;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String fromDpt(int index) {
        int offset = index * 6;
        double time = (double)(this.data[offset++] << 8 | this.data[offset++]) / 10.0;
        int temperature = this.data[offset++] << 8 | this.data[offset++];
        double brightness = (double)this.data[offset++] * 100.0 / 255.0;
        short valid = this.data[offset++];
        StringBuilder sb = new StringBuilder();
        sb.append((valid & 1) == 1 ? this.formatter.format(brightness) : "-").append(this.appendUnit ? " % " : " ");
        sb.append((valid & 2) == 2 ? Integer.valueOf(temperature) : "-").append(this.appendUnit ? " K " : " ");
        sb.append((valid & 4) == 4 ? this.formatter.format(time) : "-").append(this.appendUnit ? " s" : "");
        return sb.toString();
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        String[] fields = value.split(" ");
        if (fields.length != 6 && fields.length != 3) {
            throw this.newException("unsupported format for brightness & color temperature transition", value);
        }
        int inc = fields.length / 3;
        int valid = 0;
        String field = fields[0];
        boolean invalid = field.equals("-");
        double brightness = invalid ? 0.0 : this.parse(field);
        valid |= invalid ? 0 : 1;
        field = fields[inc];
        invalid = field.equals("-");
        int temperature = invalid ? 0 : this.parseInt(field);
        valid |= invalid ? 0 : 2;
        field = fields[2 * inc];
        invalid = field.equals("-");
        double time = invalid ? 0.0 : this.parse(field);
        valid |= invalid ? 0 : 4;
        try {
            DptXlatorBrightnessClrTempTrans.rangeCheck(brightness, temperature, Duration.ofMillis((long)(time * 1000.0)));
        }
        catch (KNXIllegalArgumentException e) {
            throw this.newException(e.getMessage(), value);
        }
        int brightnessRaw = (int)Math.round(brightness * 255.0 / 100.0);
        int timeRaw = (int)Math.round(time * 10.0);
        int offset = index * 6;
        dst[offset++] = (short)(timeRaw >> 8);
        dst[offset++] = DptXlatorBrightnessClrTempTrans.ubyte(timeRaw);
        dst[offset++] = (short)(temperature >> 8);
        dst[offset++] = DptXlatorBrightnessClrTempTrans.ubyte(temperature);
        dst[offset++] = DptXlatorBrightnessClrTempTrans.ubyte(brightnessRaw);
        dst[offset] = (short)valid;
    }

    private short[] toDpt(double brightness, int temperature, Duration timePeriod) {
        DptXlatorBrightnessClrTempTrans.rangeCheck(brightness, temperature, timePeriod);
        int time = (int)(timePeriod.toMillis() / 100L);
        return new short[]{(short)(time >> 8), DptXlatorBrightnessClrTempTrans.ubyte(time), (short)(temperature >> 8), DptXlatorBrightnessClrTempTrans.ubyte(temperature), (short)Math.round(brightness * 255.0 / 100.0), 7};
    }

    private static void rangeCheck(double brightness, int temperature, Duration timePeriod) {
        if (brightness < 0.0 || brightness > 100.0) {
            throw new KNXIllegalArgumentException("absolute brightness " + brightness + " out of range [0..100]");
        }
        if (temperature < 0 || temperature > 65535) {
            throw new KNXIllegalArgumentException("absolute color temperature " + temperature + " out of range [0..65535]");
        }
        if (timePeriod.isNegative() || timePeriod.toMillis() > 6553500L) {
            throw new KNXIllegalArgumentException("time period " + timePeriod + " out of range [0..6553500] ms");
        }
    }

    private double parse(String value) throws KNXFormatException {
        try {
            return this.formatter.parse(value).doubleValue();
        }
        catch (ParseException parseException) {
            throw this.newException("wrong value format", value);
        }
    }

    private int parseInt(String value) throws KNXFormatException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.newException("wrong value format", value);
        }
    }
}

