/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.Map;
import java.util.Optional;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.DPTXlator3BitControlled;
import tuwien.auto.calimero.dptxlator.StepControl;

public class DptXlatorRelativeControlXyY
extends DPTXlator {
    public static final String Description = "relative control xyY";
    public static final DPT DptRelativeControlXyY = new DPT("253.600", "relative control xyY", "x decrease 0 y decrease 0 Y decrease 0", "x increase 7 y increase 7 Y increase 7");
    private static final Map<String, DPT> types = DptXlatorRelativeControlXyY.loadDatapointTypes(DptXlatorRelativeControlXyY.class);
    private final DPTXlator3BitControlled t = new DPTXlator3BitControlled(DPTXlator3BitControlled.DPT_CONTROL_DIMMING);
    private static final int x = 2;
    private static final int y = 1;
    private static final int Y = 0;

    public DptXlatorRelativeControlXyY() throws KNXFormatException {
        this(DptRelativeControlXyY);
    }

    public DptXlatorRelativeControlXyY(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DptXlatorRelativeControlXyY(String dptId) throws KNXFormatException {
        super(4);
        this.setTypeID(types, dptId);
        this.data = new short[this.typeSize];
    }

    @Override
    public String getValue() {
        return this.fromDpt(0);
    }

    public final Optional<StepControl> x() {
        return this.component(2);
    }

    public final Optional<StepControl> y() {
        return this.component(1);
    }

    public final Optional<StepControl> brightness() {
        return this.component(0);
    }

    private Optional<StepControl> component(int c) {
        int validBit = 1 << c;
        if ((this.data[3] & validBit) == 0) {
            return Optional.empty();
        }
        int offset = 2 - c;
        return Optional.of(StepControl.from(this.data[offset]));
    }

    public final void setValue(StepControl x, StepControl y, StepControl brightness) {
        this.data = this.toDpt(x, y, brightness);
    }

    public final void setX(StepControl value) {
        short d;
        this.t.setValue(value);
        this.data[0] = d = DptXlatorRelativeControlXyY.ubyte(this.t.getData()[0]);
        this.data[3] = (short)(this.data[3] | 4);
    }

    public final void setY(StepControl value) {
        short d;
        this.t.setValue(value);
        this.data[1] = d = DptXlatorRelativeControlXyY.ubyte(this.t.getData()[0]);
        this.data[3] = (short)(this.data[3] | 2);
    }

    public final void setBrightness(StepControl value) {
        short d;
        this.t.setValue(value);
        this.data[2] = d = DptXlatorRelativeControlXyY.ubyte(this.t.getData()[0]);
        this.data[3] = (short)(this.data[3] | 1);
    }

    @Override
    public String[] getAllValues() {
        int items = this.getItems();
        String[] s = new String[items];
        int i = 0;
        while (i < items) {
            s[i] = this.fromDpt(i);
            ++i;
        }
        return s;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String fromDpt(int index) {
        int offset = index * this.typeSize;
        short valid = this.data[offset + this.typeSize - 1];
        if (valid == 0) {
            return "x - y - Y -";
        }
        this.t.setAppendUnit(this.appendUnit);
        String s = this.component(offset, 2);
        s = String.valueOf(s) + this.component(offset, 1);
        s = String.valueOf(s) + this.component(offset, 0);
        return s.trim();
    }

    private String component(int offset, int component) {
        String[] prefixes = new String[]{"Y", "y", "x"};
        short mask = this.data[offset + this.typeSize - 1];
        if ((mask >> component & 1) == 1) {
            this.t.setData(new byte[]{(byte)this.data[offset + 2 - component]});
            return " " + prefixes[component] + " " + this.t.getValue();
        }
        return "";
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        if (value.isEmpty()) {
            return;
        }
        String[] fields = value.split(" ", 0);
        if (fields.length > 12 || fields.length < 3) {
            throw this.newException("unsupported format for relative control xyY", value);
        }
        int valid = 0;
        int offset = index * this.typeSize;
        int i = 0;
        String[] components = new String[]{"x", "y", "Y"};
        int maskBit = 4;
        int clrOffset = 0;
        String[] stringArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (c.equals(fields[i])) {
                int clr = this.component(fields, ++i);
                dst[offset + clrOffset] = DptXlatorRelativeControlXyY.ubyte(clr);
                boolean invalid = clr == -1;
                valid |= invalid ? 0 : maskBit;
                if ((i += invalid || clr == 0 ? 1 : 2) < fields.length && "steps".equals(fields[i])) {
                    ++i;
                }
            }
            if (i >= fields.length) break;
            maskBit >>= 1;
            ++clrOffset;
            ++n2;
        }
        if (i < fields.length) {
            throw this.newException("value contains excessive components", fields[i]);
        }
        dst[offset + this.typeSize - 1] = (short)valid;
    }

    private int component(String[] fields, int i) throws KNXFormatException {
        String first = fields[i];
        if ("-".equals(first)) {
            return -1;
        }
        if (fields.length > i + 1) {
            this.t.setValue(String.valueOf(first) + " " + fields[i + 1]);
        } else {
            this.t.setValue(first);
        }
        return this.t.getData()[0];
    }

    private short[] toDpt(StepControl x, StepControl y, StepControl brightness) {
        this.t.setValue(x);
        short x_ = DptXlatorRelativeControlXyY.ubyte(this.t.getData()[0]);
        this.t.setValue(y);
        short y_ = DptXlatorRelativeControlXyY.ubyte(this.t.getData()[0]);
        this.t.setValue(brightness);
        short br = DptXlatorRelativeControlXyY.ubyte(this.t.getData()[0]);
        return new short[]{x_, y_, br, 7};
    }
}

