/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DptXlatorRgbw
extends DPTXlator {
    public static final String Description = "RGBW color";
    public static final DPT DptRgbw = new DPT("251.600", "RGBW color", "0 0 0 0", "100 100 100 100", "%");
    private static final Map<String, DPT> types = new HashMap<String, DPT>();
    private final NumberFormat formatter = NumberFormat.getNumberInstance();

    static {
        types.put(DptRgbw.getID(), DptRgbw);
    }

    public DptXlatorRgbw() throws KNXFormatException {
        this(DptRgbw);
    }

    public DptXlatorRgbw(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DptXlatorRgbw(String dptId) throws KNXFormatException {
        super(6);
        this.setTypeID(types, dptId);
        this.data = new short[6];
        this.formatter.setMaximumFractionDigits(1);
    }

    @Override
    public String getValue() {
        return this.fromDpt(0);
    }

    public final void setValue(double red, double green, double blue, double white) {
        this.data = this.toDpt(red, green, blue, white);
    }

    public final void setRed(double value) {
        short v;
        this.data[0] = v = this.toDpt(value);
        this.data[5] = (short)(this.data[5] | 8);
    }

    public final void setGreen(double value) {
        short v;
        this.data[1] = v = this.toDpt(value);
        this.data[5] = (short)(this.data[5] | 4);
    }

    public final void setBlue(double value) {
        short v;
        this.data[2] = v = this.toDpt(value);
        this.data[5] = (short)(this.data[5] | 2);
    }

    public final void setWhite(double value) {
        short v;
        this.data[3] = v = this.toDpt(value);
        this.data[5] = (short)(this.data[5] | 1);
    }

    public final Optional<Double> red() {
        return this.component(0);
    }

    public final Optional<Double> green() {
        return this.component(1);
    }

    public final Optional<Double> blue() {
        return this.component(2);
    }

    public final Optional<Double> white() {
        return this.component(3);
    }

    @Override
    public String[] getAllValues() {
        int items = this.getItems();
        String[] s = new String[items];
        int i = 0;
        while (i < items) {
            s[i] = this.fromDpt(i);
            ++i;
        }
        return s;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String fromDpt(int index) {
        if (this.data[index * 6 + 4] != 0) {
            logger.warn("DPT " + this.dpt.getID() + " " + this.dpt.getDescription() + ": reserved bits not 0");
        }
        return this.appendUnit(String.valueOf(this.component(index, 0)) + " " + this.component(index, 1) + " " + this.component(index, 2) + " " + this.component(index, 3));
    }

    private String component(int index, int component) {
        boolean valid;
        int mask = 1 << 3 - component;
        boolean bl = valid = (this.data[index * 6 + 5] & mask) == mask;
        if (valid) {
            return this.formatter.format((double)this.data[index * 6 + component] * 100.0 / 255.0);
        }
        return "-";
    }

    private Optional<Double> component(int component) {
        boolean valid;
        int mask = 1 << 3 - component;
        boolean bl = valid = (this.data[5] & mask) == mask;
        if (valid) {
            return Optional.of((double)this.data[0 + component] * 100.0 / 255.0);
        }
        return Optional.empty();
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        String[] components = this.removeUnit(value).split(" ");
        if (components.length != 4) {
            throw this.newException("RGBW format requires 4 components", value);
        }
        int valid = 0;
        int i = 0;
        while (i < 4) {
            int mask = 1 << 3 - i;
            if (!components[i].equals("-")) {
                valid |= mask;
                dst[index * 6 + i] = this.toDpt(components[i]);
            }
            ++i;
        }
        dst[index * 6 + 5] = (short)valid;
    }

    private short[] toDpt(double red, double green, double blue, double white) {
        short[] sArray = new short[6];
        sArray[0] = this.toDpt(red);
        sArray[1] = this.toDpt(green);
        sArray[2] = this.toDpt(blue);
        sArray[3] = this.toDpt(white);
        sArray[5] = 15;
        return sArray;
    }

    private short toDpt(double value) {
        if (value < 0.0 || value > 100.0) {
            throw new KNXIllegalArgumentException("RGBW component " + value + " out of range [0..100]");
        }
        return (short)Math.round(value * 255.0 / 100.0);
    }

    private short toDpt(String component) throws KNXFormatException {
        try {
            double value = Double.parseDouble(component.replace(',', '.'));
            return this.toDpt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.newException("wrong value format", component);
        }
        catch (KNXIllegalArgumentException e) {
            throw this.newException(e.getMessage(), component);
        }
    }
}

