/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import java.util.Optional;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DptXlatorXyY
extends DPTXlator {
    public static final String Description = "xyY color";
    public static final DPT DptXyY = new DPT("242.600", "color xyY", "(0 0) 0", "(1 1) 100", "%");
    private static final Map<String, DPT> types = DptXlatorXyY.loadDatapointTypes(DptXlatorXyY.class);
    private final NumberFormat formatter = NumberFormat.getNumberInstance();

    public DptXlatorXyY() throws KNXFormatException {
        this(DptXyY);
    }

    public DptXlatorXyY(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DptXlatorXyY(String dptId) throws KNXFormatException {
        super(6);
        this.setTypeID(types, dptId);
        this.data = new short[this.typeSize];
        this.formatter.setMinimumFractionDigits(0);
        this.formatter.setMaximumFractionDigits(4);
    }

    @Override
    public String getValue() {
        return this.fromDpt(0);
    }

    public final Optional<Double> x() {
        double x = this.fromDptDouble(0)[0];
        return x == -1.0 ? Optional.empty() : Optional.of(x);
    }

    public final Optional<Double> y() {
        double y = this.fromDptDouble(0)[1];
        return y == -1.0 ? Optional.empty() : Optional.of(y);
    }

    public final Optional<Double> brightness() {
        double b = this.fromDptDouble(0)[2];
        return b == -1.0 ? Optional.empty() : Optional.of(b);
    }

    public final void setValue(double x, double y, double brightness) {
        this.toDpt(x, y, brightness);
    }

    public final void setChromaticity(double x, double y) {
        DptXlatorXyY.rangeCheck(x, y, 0.0);
        this.setColor(x, y);
    }

    public final void setBrightness(double brightness) {
        DptXlatorXyY.rangeCheck(0.0, 0.0, brightness);
        this.data[4] = (short)Math.round(brightness * 255.0 / 100.0);
        this.data[5] = (short)(this.data[5] | 1);
    }

    @Override
    public String[] getAllValues() {
        int items = this.getItems();
        String[] s = new String[items];
        int i = 0;
        while (i < items) {
            s[i] = this.fromDpt(i);
            ++i;
        }
        return s;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String fromDpt(int index) {
        double[] values = this.fromDptDouble(index);
        StringBuilder sb = new StringBuilder();
        if (values[0] != -1.0) {
            sb.append("(");
            sb.append(this.formatter.format(values[0])).append(" ");
            sb.append(this.formatter.format(values[1]));
            sb.append(")");
        }
        if (values[2] != -1.0) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(new DecimalFormat("##.#").format(values[2])).append(this.appendUnit ? " %" : "");
        }
        return sb.toString();
    }

    private double[] fromDptDouble(int index) {
        short valid;
        int offset = index * this.typeSize;
        double x = (double)(this.data[offset++] << 8 | this.data[offset++]) / 65535.0;
        double y = (double)(this.data[offset++] << 8 | this.data[offset++]) / 65535.0;
        double brightness = (double)this.data[offset++] * 100.0 / 255.0;
        boolean clrValid = ((valid = this.data[offset++]) & 2) == 2;
        boolean brightnessValid = (valid & 1) == 1;
        return new double[]{clrValid ? x : -1.0, clrValid ? y : -1.0, brightnessValid ? brightness : -1.0};
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        boolean brightnessValid;
        boolean clrValid;
        String[] fields = value.split(" ");
        int i = 0;
        if (!(fields.length <= 3 || fields.length == 4 && "%".equals(fields[3]))) {
            throw this.newException("unsupported format for color (x y) Y", value);
        }
        int valid = 0;
        double x = 0.0;
        double y = 0.0;
        double brightness = 0.0;
        boolean bl = clrValid = fields.length >= 2 && !"%".equals(fields[1]) || fields[0].startsWith("(");
        if (clrValid) {
            String field;
            valid |= 2;
            if ((field = fields[i++]).charAt(field.length() - 1) == ',') {
                field = field.substring(0, field.length() - 1);
            }
            x = this.parse(field.replace("(", ""));
            field = fields[i++];
            y = this.parse(field.replace(")", ""));
        }
        boolean bl2 = brightnessValid = fields.length > 2 || "%".equals(fields[fields.length - 1]);
        if (brightnessValid) {
            valid |= 1;
            String field = fields[i++];
            brightness = this.parse(field);
        }
        try {
            DptXlatorXyY.rangeCheck(x, y, brightness);
        }
        catch (KNXIllegalArgumentException e) {
            throw this.newException(e.getMessage(), value);
        }
        int xRaw = (int)Math.round(x * 65535.0);
        int yRaw = (int)Math.round(y * 65535.0);
        int brightnessRaw = (int)Math.round(brightness * 255.0 / 100.0);
        int offset = index * 6;
        dst[offset++] = (short)(xRaw >> 8);
        dst[offset++] = DptXlatorXyY.ubyte(xRaw);
        dst[offset++] = (short)(yRaw >> 8);
        dst[offset++] = DptXlatorXyY.ubyte(yRaw);
        dst[offset++] = DptXlatorXyY.ubyte(brightnessRaw);
        dst[offset++] = (short)valid;
    }

    private void toDpt(double x, double y, double brightness) {
        DptXlatorXyY.rangeCheck(x, y, brightness);
        this.data = new short[6];
        this.setColor(x, y);
        this.setBrightness(brightness);
    }

    private void setColor(double x, double y) {
        int xRaw = (int)Math.round(x * 65535.0);
        int yRaw = (int)Math.round(y * 65535.0);
        this.data[0] = (short)(xRaw >> 8);
        this.data[1] = DptXlatorXyY.ubyte(xRaw);
        this.data[2] = (short)(yRaw >> 8);
        this.data[3] = DptXlatorXyY.ubyte(yRaw);
        this.data[5] = (short)(this.data[5] | 2);
    }

    private static void rangeCheck(double x, double y, double brightness) {
        if (x < 0.0 || x > 1.0) {
            throw new KNXIllegalArgumentException("x " + x + " out of range [0..1]");
        }
        if (y < 0.0 || y > 1.0) {
            throw new KNXIllegalArgumentException("y " + y + " out of range [0..1]");
        }
        if (brightness < 0.0 || brightness > 100.0) {
            throw new KNXIllegalArgumentException("brightness " + brightness + " out of range [0..100]");
        }
    }

    private double parse(String value) throws KNXFormatException {
        try {
            return Double.parseDouble(value.replace(',', '.'));
        }
        catch (NumberFormatException numberFormatException) {
            throw this.newException("wrong value format", value);
        }
    }
}

