/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.text.NumberFormat;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.DPTXlator2ByteUnsigned;
import tuwien.auto.calimero.dptxlator.DPTXlator8BitUnsigned;

public class DptXlatorXyYTransition
extends DPTXlator {
    public static final String Description = "color transition xyY";
    public static final DPT DptXyYTransition = new DPT("243.600", "color transition xyY", "(0, 0) 0 % 0 s", "(1, 1) 100 % 6553.5 s");
    private static final Map<String, DPT> types = DptXlatorXyYTransition.loadDatapointTypes(DptXlatorXyYTransition.class);
    private final NumberFormat formatter = NumberFormat.getNumberInstance();
    private final DPTXlator2ByteUnsigned t = new DPTXlator2ByteUnsigned(DPTXlator2ByteUnsigned.DPT_TIMEPERIOD_100);
    private final DPTXlator8BitUnsigned scaled = new DPTXlator8BitUnsigned(DPTXlator8BitUnsigned.DPT_SCALING);

    public DptXlatorXyYTransition() throws KNXFormatException {
        this(DptXyYTransition);
    }

    public DptXlatorXyYTransition(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DptXlatorXyYTransition(String dptId) throws KNXFormatException {
        super(8);
        this.setTypeID(types, dptId);
        this.data = new short[this.typeSize];
        this.formatter.setMinimumFractionDigits(0);
        this.formatter.setMaximumFractionDigits(4);
    }

    @Override
    public String getValue() {
        return this.fromDpt(0);
    }

    public final Optional<Double> x() {
        double x = this.fromDptDouble(0)[2];
        return x == -1.0 ? Optional.empty() : Optional.of(x);
    }

    public final Optional<Double> y() {
        double y = this.fromDptDouble(0)[1];
        return y == -1.0 ? Optional.empty() : Optional.of(y);
    }

    public final Optional<Double> brightness() {
        double b = this.fromDptDouble(0)[3];
        return b == -1.0 ? Optional.empty() : Optional.of(b);
    }

    public final Duration fadingTime() {
        return Duration.ofMillis((long)(this.fromDptDouble(0)[0] * 100.0));
    }

    public final void setValue(double x, double y, double brightness, Duration fadingTime) {
        this.toDpt(x, y, brightness, fadingTime);
    }

    public final void setChromaticity(double x, double y, Duration fadingTime) {
        this.setCoordinates(x, y);
        this.setFadingTime(fadingTime);
    }

    public final void setBrightness(double brightness, Duration fadingTime) {
        this.setBrightness(brightness);
        this.setFadingTime(fadingTime);
    }

    @Override
    public String[] getAllValues() {
        int items = this.getItems();
        String[] s = new String[items];
        int i = 0;
        while (i < items) {
            s[i] = this.fromDpt(i);
            ++i;
        }
        return s;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String fromDpt(int index) {
        int offset = index * this.typeSize;
        StringJoiner joiner = new StringJoiner(" ");
        short valid = this.data[offset + 7];
        if ((valid & 2) == 2) {
            double y = (double)this.ushort(offset + 2) / 65535.0;
            double x = (double)this.ushort(offset + 4) / 65535.0;
            joiner.add("(" + this.formatter.format(x) + ", " + this.formatter.format(y) + ")");
        }
        if ((valid & 1) == 1) {
            short brightness = this.data[offset + 6];
            this.scaled.setValueUnscaled(brightness);
            this.scaled.setAppendUnit(this.appendUnit);
            joiner.add(this.scaled.getValue());
        }
        int dur = this.ushort(offset);
        try {
            this.t.setTimePeriod(dur * 100);
            this.t.setAppendUnit(this.appendUnit);
            joiner.add(this.t.getValue());
        }
        catch (KNXFormatException kNXFormatException) {}
        return joiner.toString();
    }

    private int ushort(int offset) {
        return this.data[offset] << 8 | this.data[offset + 1];
    }

    private double[] fromDptDouble(int index) {
        short valid;
        int offset = index * this.typeSize;
        double time = this.data[offset++] << 8 | this.data[offset++];
        double y = (double)(this.data[offset++] << 8 | this.data[offset++]) / 65535.0;
        double x = (double)(this.data[offset++] << 8 | this.data[offset++]) / 65535.0;
        double brightness = (double)this.data[offset++] * 100.0 / 255.0;
        boolean clrValid = ((valid = this.data[offset++]) & 2) == 2;
        boolean brightnessValid = (valid & 1) == 1;
        return new double[]{time, clrValid ? y : -1.0, clrValid ? x : -1.0, brightnessValid ? brightness : -1.0};
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        if (value.isEmpty()) {
            return;
        }
        String[] fields = value.split("[ ]+", 0);
        if (fields.length > 6 || fields.length < 1) {
            throw this.newException("unsupported format for color transition xyY", value);
        }
        int i = 0;
        int valid = 0;
        String f = fields[0];
        double x = 0.0;
        double y = 0.0;
        int brightness = 0;
        short brightnessRaw = 0;
        if (f.startsWith("(")) {
            int sep = f.endsWith(",") ? 1 : 0;
            x = this.parse(f.substring(1, f.length() - sep));
            if (fields[++i].isEmpty()) {
                ++i;
            }
            y = this.parse(fields[i].substring(0, fields[i].length() - 1));
            valid = 2;
            ++i;
        }
        if (fields.length > i + 1 && fields[i + 1].equals("%")) {
            this.scaled.setValue(String.valueOf(fields[i]) + " %");
            brightness = this.scaled.getValueUnsigned();
            brightnessRaw = this.scaled.getValueUnscaled();
            i += 2;
            valid |= 1;
        }
        try {
            DptXlatorXyYTransition.rangeCheck(x, y, brightness);
        }
        catch (KNXIllegalArgumentException e) {
            throw this.newException(e.getMessage(), value);
        }
        this.t.setValue(fields[i]);
        if (fields.length > ++i && fields[i].equals("s")) {
            ++i;
        }
        if (i < fields.length) {
            throw this.newException("value contains excessive components", fields[i]);
        }
        int ms = this.t.getValueUnsigned() / 100;
        int xRaw = (int)Math.round(x * 65535.0);
        int yRaw = (int)Math.round(y * 65535.0);
        int offset = index * this.typeSize;
        dst[offset++] = (short)(ms >> 8);
        dst[offset++] = (short)(ms & 0xFF);
        dst[offset++] = (short)(yRaw >> 8);
        dst[offset++] = (short)(yRaw & 0xFF);
        dst[offset++] = (short)(xRaw >> 8);
        dst[offset++] = (short)(xRaw & 0xFF);
        dst[offset++] = brightnessRaw;
        dst[offset++] = (short)valid;
    }

    private void toDpt(double x, double y, double brightness, Duration fadingTime) {
        this.data = new short[8];
        this.setFadingTime(fadingTime);
        this.setCoordinates(x, y);
        this.setBrightness(brightness);
    }

    private void setFadingTime(Duration fadingTime) {
        try {
            this.t.setTimePeriod(fadingTime.toMillis());
        }
        catch (KNXFormatException e) {
            throw new KNXIllegalArgumentException(e.getMessage());
        }
        int dur = this.t.getValueUnsigned() / 100;
        this.data[0] = DptXlatorXyYTransition.ubyte(dur >> 8);
        this.data[1] = DptXlatorXyYTransition.ubyte(dur);
    }

    private void setCoordinates(double x, double y) {
        int xUnscaled = this.unscaled(x);
        int yUnscaled = this.unscaled(y);
        this.data[2] = DptXlatorXyYTransition.ubyte(yUnscaled >> 8);
        this.data[3] = DptXlatorXyYTransition.ubyte(yUnscaled);
        this.data[4] = DptXlatorXyYTransition.ubyte(xUnscaled >> 8);
        this.data[5] = DptXlatorXyYTransition.ubyte(xUnscaled);
        this.data[7] = (short)(this.data[7] | 2);
    }

    private void setBrightness(double brightness) {
        try {
            this.scaled.setValue(brightness);
        }
        catch (KNXFormatException e) {
            throw new KNXIllegalArgumentException(e.getMessage());
        }
        short bright = this.scaled.getValueUnscaled();
        this.data[6] = DptXlatorXyYTransition.ubyte(bright);
        this.data[7] = (short)(this.data[7] | 1);
    }

    private int unscaled(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new KNXIllegalArgumentException("coordinate " + value + " out of range [0..1]");
        }
        return (int)(value * 65535.0);
    }

    private static void rangeCheck(double x, double y, int brightness) {
        if (x < 0.0 || x > 1.0) {
            throw new KNXIllegalArgumentException("x " + x + " out of range [0..1]");
        }
        if (y < 0.0 || y > 1.0) {
            throw new KNXIllegalArgumentException("y " + y + " out of range [0..1]");
        }
        if (brightness < 0 || brightness > 100) {
            throw new KNXIllegalArgumentException("brightness " + brightness + " out of range [0..100]");
        }
    }

    private double parse(String value) throws KNXFormatException {
        try {
            return Double.parseDouble(value.replace(',', '.'));
        }
        catch (NumberFormatException numberFormatException) {
            throw this.newException("wrong value format", value);
        }
    }
}

