/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.EnumSet;
import java.util.regex.Pattern;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;

class EnumDptBase<T extends Enum<T>>
extends DPT {
    final Class<T> elements;
    private static final String regex = "(\\p{Lower})\\B([A-Z])";
    private static final Pattern friendlyPattern = Pattern.compile("(\\p{Lower})\\B([A-Z])");

    EnumDptBase(String typeId, Class<T> elements, String lower, String upper) {
        this(typeId, elements.getSimpleName().replaceAll("\\B([A-Z])", " $1"), elements, lower, upper);
    }

    EnumDptBase(String typeId, String description, Class<T> elements, String lower, String upper) {
        super(typeId, description, lower, upper);
        this.elements = elements;
    }

    public T[] values() {
        return (Enum[])this.elements.getEnumConstants();
    }

    private T find(int element) {
        for (Enum e : EnumSet.allOf(this.elements)) {
            if (((EnumBase)((Object)e)).value() != element) continue;
            return (T)e;
        }
        return null;
    }

    T find(String description) {
        for (Enum e : EnumSet.allOf(this.elements)) {
            if (e.name().equalsIgnoreCase(description)) {
                return (T)e;
            }
            if (((EnumBase)((Object)e)).description().equalsIgnoreCase(description)) {
                return (T)e;
            }
            if (!EnumDptBase.friendly(e.name()).equalsIgnoreCase(description)) continue;
            return (T)e;
        }
        return null;
    }

    boolean contains(int element) {
        return this.find(element) != null;
    }

    String textOf(int element) {
        T e = this.find(element);
        if (e != null) {
            return ((EnumBase)e).description();
        }
        throw new KNXIllegalArgumentException(String.valueOf(this.getID()) + " " + this.elements.getSimpleName() + " has no element " + element + " specified");
    }

    String name() {
        return this.elements.getSimpleName();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(30);
        sb.append(this.getID()).append(": ").append(this.getDescription()).append(", enumeration [");
        sb.append(this.getLowerValue()).append("..").append(this.getUpperValue()).append("]");
        return sb.toString();
    }

    private static String friendly(String name) {
        return friendlyPattern.matcher(name).replaceAll("$1 $2").toLowerCase();
    }

    static interface EnumBase<E extends Enum<E>> {
        default public int value() {
            return 1 << ((Enum)((Object)this)).ordinal();
        }

        default public String description() {
            return EnumDptBase.friendly(((Enum)((Object)this)).name());
        }
    }
}

