/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.TranslatorTypes;

public final class PropertyTypes {
    public static final int PDT_CONTROL = 0;
    public static final int PDT_CHAR = 1;
    public static final int PDT_UNSIGNED_CHAR = 2;
    public static final int PDT_INT = 3;
    public static final int PDT_UNSIGNED_INT = 4;
    public static final int PDT_KNX_FLOAT = 5;
    public static final int PDT_DATE = 6;
    public static final int PDT_TIME = 7;
    public static final int PDT_LONG = 8;
    public static final int PDT_UNSIGNED_LONG = 9;
    public static final int PDT_FLOAT = 10;
    public static final int PDT_DOUBLE = 11;
    public static final int PDT_CHAR_BLOCK = 12;
    public static final int PDT_POLL_GROUP_SETTINGS = 13;
    public static final int PDT_SHORT_CHAR_BLOCK = 14;
    public static final int PDT_DATE_TIME = 15;
    public static final int PDT_VARIABLE_LENGTH = 16;
    public static final int PDT_GENERIC_01 = 17;
    public static final int PDT_GENERIC_02 = 18;
    public static final int PDT_GENERIC_03 = 19;
    public static final int PDT_GENERIC_04 = 20;
    public static final int PDT_GENERIC_05 = 21;
    public static final int PDT_GENERIC_06 = 22;
    public static final int PDT_GENERIC_07 = 23;
    public static final int PDT_GENERIC_08 = 24;
    public static final int PDT_GENERIC_09 = 25;
    public static final int PDT_GENERIC_10 = 26;
    public static final int PDT_GENERIC_11 = 27;
    public static final int PDT_GENERIC_12 = 28;
    public static final int PDT_GENERIC_13 = 29;
    public static final int PDT_GENERIC_14 = 30;
    public static final int PDT_GENERIC_15 = 31;
    public static final int PDT_GENERIC_16 = 32;
    public static final int PDT_GENERIC_17 = 33;
    public static final int PDT_GENERIC_18 = 34;
    public static final int PDT_GENERIC_19 = 35;
    public static final int PDT_GENERIC_20 = 36;
    public static final int PDT_VERSION = 48;
    public static final int PDT_ALARM_INFO = 49;
    public static final int PDT_BINARY_INFORMATION = 50;
    public static final int PDT_BITSET8 = 51;
    public static final int PDT_BITSET16 = 52;
    public static final int PDT_ENUM8 = 53;
    public static final int PDT_SCALING = 54;
    public static final int PDT_NE_VL = 60;
    public static final int PDT_NE_FL = 61;
    public static final int PDT_FUNCTION = 62;
    private static final Map<Integer, DPTID> pt = Collections.synchronizedMap(new HashMap());
    private static final Map<Integer, Integer> typeSize;

    static {
        pt.put(1, new DPTID(6, "6.010"));
        pt.put(2, new DPTID(5, "5.010"));
        pt.put(3, new DPTID(8, "8.001"));
        pt.put(4, new DPTID(7, "7.001"));
        pt.put(5, new DPTID(9, "9.002"));
        pt.put(6, new DPTID(11, "11.001"));
        pt.put(7, new DPTID(10, "10.001"));
        pt.put(8, new DPTID(13, "13.001"));
        pt.put(9, new DPTID(12, "12.001"));
        pt.put(10, new DPTID(14, "14.005"));
        pt.put(12, new DPTID(24, "24.001"));
        pt.put(14, new DPTID(24, "24.001"));
        pt.put(15, new DPTID(19, "19.001"));
        pt.put(16, new DPTID(24, "24.001"));
        pt.put(48, new DPTID(217, "217.001"));
        pt.put(49, new DPTID(219, "219.001"));
        pt.put(50, new DPTID(1, "1.002"));
        pt.put(51, new DPTID(21, "21.001"));
        pt.put(52, new DPTID(22, "22.100"));
        pt.put(53, new DPTID(20, "20.1000"));
        pt.put(54, new DPTID(5, "5.001"));
        typeSize = Map.ofEntries(Map.entry(1, 8), Map.entry(2, 8), Map.entry(3, 16), Map.entry(4, 16), Map.entry(5, 16), Map.entry(6, 24), Map.entry(7, 24), Map.entry(8, 32), Map.entry(9, 32), Map.entry(10, 32), Map.entry(11, 64), Map.entry(12, 80), Map.entry(13, 24), Map.entry(14, 40), Map.entry(15, 64), Map.entry(17, 8), Map.entry(18, 16), Map.entry(19, 24), Map.entry(20, 32), Map.entry(21, 40), Map.entry(22, 48), Map.entry(23, 56), Map.entry(24, 64), Map.entry(25, 72), Map.entry(26, 80), Map.entry(27, 88), Map.entry(28, 96), Map.entry(29, 104), Map.entry(30, 112), Map.entry(31, 120), Map.entry(32, 128), Map.entry(33, 136), Map.entry(34, 144), Map.entry(35, 152), Map.entry(36, 160), Map.entry(48, 16), Map.entry(49, 48), Map.entry(50, 1), Map.entry(51, 8), Map.entry(52, 16), Map.entry(53, 8), Map.entry(54, 8));
    }

    private PropertyTypes() {
    }

    public static Map<Integer, DPTID> getAllPropertyTypes() {
        return pt;
    }

    public static Optional<Integer> bitSize(int dataType) {
        return Optional.ofNullable(typeSize.get(dataType));
    }

    public static boolean hasTranslator(int dataType) {
        DPTID dpt = pt.get(dataType);
        if (dpt != null) {
            try {
                TranslatorTypes.MainType t = TranslatorTypes.getMainType(dpt.getMainNumber());
                if (t != null) {
                    return t.getSubTypes().get(dpt.getDPT()) != null;
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (KNXException kNXException) {}
        }
        return false;
    }

    public static DPTXlator createTranslator(int dataType) throws KNXException {
        DPTID dpt = pt.get(dataType);
        if (dpt == null) {
            throw new KNXException("PDT not found");
        }
        DPTXlator t = TranslatorTypes.createTranslator(dpt.getMainNumber(), dpt.getDPT());
        t.setAppendUnit(false);
        return t;
    }

    public static DPTXlator createTranslator(int dataType, byte[] data) throws KNXException {
        DPTXlator t = PropertyTypes.createTranslator(dataType);
        t.setData(data);
        return t;
    }

    public static String[] getValues(int dataType, byte[] data) throws KNXException {
        return PropertyTypes.createTranslator(dataType, data).getAllValues();
    }

    public static class DPTID {
        private final int main;
        private final String dpt;

        public DPTID(int mainNumber, String dpt) {
            this.main = mainNumber;
            this.dpt = dpt;
        }

        public final int getMainNumber() {
            return this.main;
        }

        public final String getDPT() {
            return this.dpt;
        }
    }
}

