/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.Objects;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPTXlatorBoolean;

public final class StepControl {
    public static final StepControl Break = new StepControl(0);
    private final DPTXlatorBoolean.Step step;
    private final int stepcode;

    public static final StepControl increase(int stepcode) {
        return new StepControl(DPTXlatorBoolean.Step.Increase, stepcode);
    }

    public static final StepControl decrease(int stepcode) {
        return new StepControl(DPTXlatorBoolean.Step.Decrease, stepcode);
    }

    static final StepControl from(int raw) {
        return new StepControl(raw);
    }

    StepControl(int raw) {
        if ((raw & 0xFFFFFFF0) != 0) {
            throw new KNXIllegalArgumentException("reserved bits not 0: " + Integer.toHexString(raw));
        }
        this.step = (raw & 8) != 0 ? DPTXlatorBoolean.Step.Increase : DPTXlatorBoolean.Step.Decrease;
        this.stepcode = raw & 7;
    }

    private StepControl(DPTXlatorBoolean.Step step, int stepcode) {
        if (stepcode < 1 || stepcode > 7) {
            throw new KNXIllegalArgumentException("stepcode out of range [1..7]");
        }
        this.step = step;
        this.stepcode = stepcode;
    }

    public DPTXlatorBoolean.Step step() {
        return this.step;
    }

    public int stepcode() {
        return this.stepcode;
    }

    public boolean isBreak() {
        return this.stepcode == 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof StepControl) {
            StepControl sc = (StepControl)other;
            return this.step == sc.step && this.stepcode == sc.stepcode;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.step, this.stepcode);
    }

    public String toString() {
        return this.step + " " + this.stepcode;
    }
}

