/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public final class TranslatorTypes {
    public static final int TYPE_BOOLEAN = 1;
    public static final int TYPE_1BIT_CONTROLLED = 2;
    public static final int TYPE_3BIT_CONTROLLED = 3;
    public static final int TYPE_CHARACTER_SET = 4;
    public static final int TYPE_8BIT_UNSIGNED = 5;
    public static final int TYPE_8BIT_SIGNED = 6;
    public static final int TYPE_2OCTET_UNSIGNED = 7;
    public static final int TYPE_2OCTET_SIGNED = 8;
    public static final int TYPE_2OCTET_FLOAT = 9;
    public static final int TYPE_TIME = 10;
    public static final int TYPE_DATE = 11;
    public static final int TYPE_4OCTET_UNSIGNED = 12;
    public static final int TYPE_4OCTET_SIGNED = 13;
    public static final int TYPE_4OCTET_FLOAT = 14;
    public static final int TYPE_ACCESS = 15;
    public static final int TYPE_STRING = 16;
    public static final int TYPE_SCENE_NUMBER = 17;
    public static final int TYPE_SCENE_CONTROL = 18;
    public static final int TYPE_DATE_TIME = 19;
    public static final int TYPE_8BIT_ENUM = 20;
    public static final int TYPE_UTF8 = 28;
    public static final int TYPE_64BIT_SIGNED = 29;
    public static final int TYPE_RGB = 232;
    private static final Map<Integer, MainType> map = Collections.synchronizedMap(new HashMap());
    private static final String[] builtinXlators = new String[]{"DptXlator16BitSet", "DPTXlator1BitControlled", "DPTXlator2ByteFloat", "DptXlator2ByteSigned", "DPTXlator2ByteUnsigned", "DPTXlator3BitControlled", "DPTXlator4ByteFloat", "DPTXlator4ByteSigned", "DPTXlator4ByteUnsigned", "DPTXlator64BitSigned", "DPTXlator8BitEnum", "DptXlator8BitSet", "DPTXlator8BitSigned", "DPTXlator8BitUnsigned", "DPTXlatorBoolean", "DptXlatorBrightnessClrTempControl", "DptXlatorBrightnessClrTempTrans", "DPTXlatorDate", "DPTXlatorDateTime", "DptXlatorMeteringValue", "DptXlatorRelativeControlRgb", "DptXlatorRelativeControlRgbw", "DptXlatorRelativeControlXyY", "DPTXlatorRGB", "DptXlatorRgbw", "DPTXlatorSceneControl", "DPTXlatorSceneNumber", "DPTXlatorString", "DPTXlatorTime", "DPTXlatorUtf8", "DptXlatorXyY", "DptXlatorXyYTransition"};

    static {
        try {
            String[] stringArray = builtinXlators;
            int n = builtinXlators.length;
            int n2 = 0;
            while (n2 < n) {
                String x = stringArray[n2];
                TranslatorTypes.addTranslator("tuwien.auto.calimero.dptxlator." + x);
                ++n2;
            }
        }
        catch (Exception e) {
            DPTXlator.logger.error("failed to initialize list of available DPT translators", (Throwable)e);
        }
    }

    private TranslatorTypes() {
    }

    private static void addTranslator(String className) {
        try {
            Class<?> c = Class.forName(className);
            if (DPTXlator.class.equals(c) || !DPTXlator.class.isAssignableFrom(c)) {
                return;
            }
            Class<?> x = c;
            Map dpts = (Map)x.getDeclaredMethod("getSubTypesStatic", new Class[0]).invoke(null, new Object[0]);
            String id = ((DPT)dpts.values().iterator().next()).getID();
            String s = id.substring(0, id.indexOf(46));
            int mainNumber = Integer.parseInt(s);
            String desc = String.valueOf(TranslatorTypes.descriptionFor(x)) + " (main number " + mainNumber + ")";
            map.put(mainNumber, new MainType(mainNumber, x, desc));
            DPTXlator.logger.trace("loaded DPT translator for {}", (Object)desc);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            DPTXlator.logger.warn("lookup DPT translator class {}", (Object)className, (Object)e);
        }
    }

    private static String descriptionFor(Class<? extends DPTXlator> x) throws IllegalAccessException {
        try {
            Field f = x.getField("Description");
            if (f.getType() == String.class) {
                return (String)f.get(null);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        String name = x.getSimpleName();
        if (name.toLowerCase().indexOf("dptxlator") == 0) {
            name = name.substring("dptxlator".length());
        }
        return name.replaceAll("([A-Z])", " $1").trim();
    }

    public static MainType getMainType(int mainNumber) {
        return map.get(mainNumber);
    }

    public static Map<Integer, MainType> getAllMainTypes() {
        return map;
    }

    public static List<MainType> getMainTypesBySize(int typeSize) {
        ArrayList<MainType> l = new ArrayList<MainType>();
        for (MainType type : map.values()) {
            try {
                String dptId = type.getSubTypes().keySet().iterator().next();
                int size = type.createTranslator(dptId).getTypeSize();
                if (size != typeSize) continue;
                l.add(type);
            }
            catch (KNXException kNXException) {}
        }
        return l;
    }

    public static List<MainType> ofBitSize(int size) {
        if (size < 5) {
            MainType mainType = map.get(size == 1 ? 1 : (size == 2 ? 2 : (size == 4 ? 3 : 0)));
            return Optional.ofNullable(mainType).map(Collections::singletonList).orElse(Collections.emptyList());
        }
        ArrayList<MainType> l = new ArrayList<MainType>();
        for (MainType type : map.values()) {
            try {
                String dptId = type.getSubTypes().keySet().iterator().next();
                int bits = type.createTranslator(dptId).getTypeSize() * 8;
                if (bits != size) continue;
                l.add(type);
            }
            catch (KNXException kNXException) {}
        }
        return l;
    }

    public static boolean hasTranslator(int mainNumber, String dptId) {
        try {
            MainType t = TranslatorTypes.getMainType(TranslatorTypes.getMainNumber(mainNumber, dptId));
            if (t != null) {
                return t.getSubTypes().get(dptId) != null;
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (KNXException kNXException) {}
        return false;
    }

    public static DPTXlator createTranslator(int mainNumber, String dptId) throws KNXException {
        int main = 0;
        try {
            main = TranslatorTypes.getMainNumber(mainNumber, dptId);
        }
        catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {}
        MainType type = map.get(main);
        if (type == null) {
            throw new KNXException("no DPT translator available for main number " + main + " (ID " + dptId + ")");
        }
        String id = dptId != null && !dptId.isEmpty() ? dptId : type.getSubTypes().keySet().iterator().next();
        return type.createTranslator(id);
    }

    public static DPTXlator createTranslator(int mainNumber, int subNumber, byte ... data) throws KNXException {
        MainType type = map.get(mainNumber);
        if (type == null) {
            throw new KNXException("no DPT translator available for main number " + mainNumber);
        }
        boolean withSub = subNumber != 0;
        String id = withSub ? String.format("%d.%03d", mainNumber, subNumber) : type.getSubTypes().keySet().iterator().next();
        DPTXlator t = type.createTranslator(id);
        t.setAppendUnit(withSub);
        if (data.length > 0) {
            t.setData(data);
        }
        return t;
    }

    public static DPTXlator createTranslator(DPT dpt, byte ... data) throws KNXException {
        DPTXlator t = TranslatorTypes.createTranslator(dpt);
        if (data.length > 0) {
            t.setData(data);
        }
        return t;
    }

    /*
     * Unable to fully structure code
     */
    private static DPTXlator createTranslator(DPT dpt) throws KNXException {
        try {
            return TranslatorTypes.createTranslator(0, dpt.getID());
        }
        catch (KNXException v0) {
            ** for (type : TranslatorTypes.map.values())
        }
lbl-1000:
        // 1 sources

        {
            try {
                return type.createTranslator(dpt);
            }
            catch (KNXException v1) {}
            continue;
        }
lbl9:
        // 1 sources

        throw new KNXException("failed to create translator for DPT " + dpt.getID());
    }

    public static DPTXlator createTranslator(String dptId, byte ... data) throws KNXException, KNXIllegalArgumentException {
        DPTXlator t = TranslatorTypes.createTranslator(0, dptId);
        if (data.length > 0) {
            t.setData(data);
        }
        return t;
    }

    private static int getMainNumber(int mainNumber, String dptId) {
        return mainNumber != 0 ? mainNumber : Integer.parseInt(dptId.substring(0, dptId.indexOf(46)));
    }

    public static class MainType {
        private final Class<? extends DPTXlator> xlator;
        private final String desc;
        private final int main;

        public MainType(int mainNumber, Class<? extends DPTXlator> translator, String description) {
            if (mainNumber <= 0) {
                throw new KNXIllegalArgumentException("invalid main number");
            }
            if (!DPTXlator.class.isAssignableFrom(translator) || DPTXlator.class.equals(translator)) {
                throw new KNXIllegalArgumentException(String.valueOf(translator.getName()) + " is not a valid DPT translator type");
            }
            this.main = mainNumber;
            this.xlator = translator;
            this.desc = description == null ? "" : description;
        }

        public final int getMainNumber() {
            return this.main;
        }

        public final DPTXlator createTranslator(DPT dpt) throws KNXException {
            return this.createTranslator(dpt.getID());
        }

        public DPTXlator createTranslator(String dptId) throws KNXException {
            try {
                return this.xlator.getConstructor(String.class).newInstance(dptId);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof KNXFormatException) {
                    throw (KNXFormatException)e.getTargetException();
                }
                throw new KNXFormatException("failed to init translator", dptId);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                DPTXlator.logger.error("DPT translator is required to have a public constructor(String dptId)");
                throw new KNXException("interface specification error at translator");
            }
            catch (Exception e) {
                throw new KNXException("failed to create translator", e);
            }
        }

        public Class<? extends DPTXlator> getTranslator() {
            return this.xlator;
        }

        public final String getDescription() {
            return this.desc;
        }

        public Map<String, DPT> getSubTypes() throws KNXException {
            try {
                Map m = (Map)this.xlator.getDeclaredMethod("getSubTypesStatic", null).invoke(null, null);
                return m;
            }
            catch (NoSuchMethodException e) {
                throw new KNXException("no method to get subtypes, " + e.getMessage());
            }
            catch (Exception e) {
                throw new KNXException("security / access problem, " + e.getMessage());
            }
        }

        public String toString() {
            return this.getDescription();
        }
    }
}

