/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.internal;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

class EventDispatcher<T extends Annotation> {
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
    final Map<Class<?>, Set<ListenerMH>> customEvents = new ConcurrentHashMap();
    private final Class<T> eventAnnotation;
    private final Logger logger;

    EventDispatcher(Class<T> eventAnnotation, Logger logger) {
        this.eventAnnotation = eventAnnotation;
        this.logger = logger;
    }

    void register(Class<?> eventType) {
        this.customEvents.put(eventType, ConcurrentHashMap.newKeySet());
    }

    void registerCustomEvents(Object listener) {
        GenericDeclaration[] genericDeclarationArray = listener.getClass().getInterfaces();
        int n = genericDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = genericDeclarationArray[n2];
            Method[] methodArray = iface.getDeclaredMethods();
            int n3 = methodArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Method method = methodArray[n4];
                this.inspectMethodForEvent(method, listener);
                ++n4;
            }
            ++n2;
        }
        genericDeclarationArray = listener.getClass().getDeclaredMethods();
        n = genericDeclarationArray.length;
        n2 = 0;
        while (n2 < n) {
            GenericDeclaration method = genericDeclarationArray[n2];
            this.inspectMethodForEvent((Method)method, listener);
            ++n2;
        }
    }

    void unregisterCustomEvents(Object listener) {
        for (Set<ListenerMH> set : this.customEvents.values()) {
            set.removeIf(lmh -> listener.equals(lmh.listener));
        }
    }

    private void inspectMethodForEvent(Method method, Object listener) {
        if (method.getAnnotation(this.eventAnnotation) == null) {
            return;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length != 1) {
            this.logger.warn("cannot register {}: parameter count not 1", (Object)method);
            return;
        }
        Class<?> paramType = paramTypes[0];
        if (!this.customEvents.containsKey(paramType)) {
            this.logger.debug("unsupported event type {}", (Object)method);
            return;
        }
        try {
            MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(listener.getClass(), lookup);
            MethodHandle boundMethod = privateLookup.unreflect(method).bindTo(listener);
            this.customEvents.get(paramType).add(new ListenerMH(listener, boundMethod));
            this.logger.trace("registered {}", (Object)method);
        }
        catch (Exception e) {
            this.logger.warn("failed to register {}", (Object)method, (Object)e);
        }
    }

    void dispatchCustomEvent(Object event) {
        this.customEvents.getOrDefault(event.getClass(), Set.of()).forEach(lmh -> {
            try {
                lmh.mh.invoke(event);
            }
            catch (Throwable e) {
                this.logger.warn("invoking custom event", e);
            }
        });
    }

    private static final class ListenerMH {
        private final Object listener;
        private final MethodHandle mh;

        ListenerMH(Object listener, MethodHandle mh) {
            this.listener = listener;
            this.mh = mh;
        }
    }
}

