/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.internal;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tuwien.auto.calimero.internal.EventDispatcher;

public class EventListeners<T> {
    private final CopyOnWriteArrayList<T> listeners = new CopyOnWriteArrayList();
    private final Logger logger;
    private final EventDispatcher<?> customEvents;

    public EventListeners(Logger logger) {
        this.logger = logger;
        this.customEvents = new EventDispatcher<Annotation>(Annotation.class, logger);
    }

    public EventListeners(Logger logger, Class<? extends Annotation> eventAnnotation) {
        this.logger = logger;
        this.customEvents = new EventDispatcher<Annotation>(eventAnnotation, logger);
    }

    public EventListeners() {
        this(LoggerFactory.getLogger((String)"calimero"));
    }

    public synchronized void add(T l) {
        if (this.listeners.addIfAbsent(l)) {
            this.customEvents.registerCustomEvents(l);
        }
    }

    public synchronized void remove(T l) {
        if (this.listeners.remove(l)) {
            this.customEvents.unregisterCustomEvents(l);
        }
    }

    public void removeAll() {
        this.listeners.clear();
    }

    public List<T> listeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void fire(Consumer<? super T> c) {
        for (T l : this.listeners) {
            try {
                c.accept(l);
            }
            catch (RuntimeException rte) {
                this.remove(l);
                this.logger.error("removed event listener", (Throwable)rte);
            }
        }
    }

    public void registerEventType(Class<?> eventType) {
        this.customEvents.register(eventType);
    }

    public void dispatchCustomEvent(Object event) {
        this.customEvents.dispatchCustomEvent(event);
    }
}

