/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.slf4j.Logger;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXListener;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.ServiceType;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.internal.EventListeners;
import tuwien.auto.calimero.knxnetip.KNXConnectionClosedException;
import tuwien.auto.calimero.knxnetip.KNXnetIPConnection;
import tuwien.auto.calimero.knxnetip.Net;
import tuwien.auto.calimero.knxnetip.ReceiverLoop;
import tuwien.auto.calimero.knxnetip.servicetype.DisconnectRequest;
import tuwien.auto.calimero.knxnetip.servicetype.ErrorCodes;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.knxnetip.servicetype.PacketHelper;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceRequest;
import tuwien.auto.calimero.knxnetip.util.HPAI;
import tuwien.auto.calimero.log.LogService;

public abstract class ConnectionBase
implements KNXnetIPConnection {
    public static final int ACK_PENDING = 2;
    public static final int ACK_ERROR = 3;
    static final int CONNECT_REQ_TIMEOUT = 10;
    protected DatagramSocket ctrlSocket;
    protected DatagramSocket socket;
    protected InetSocketAddress ctrlEndpt;
    protected InetSocketAddress dataEndpt;
    protected int channelId;
    protected boolean useNat;
    protected final int serviceRequest;
    protected final int serviceAck;
    protected final EventListeners<KNXListener> listeners = new EventListeners();
    protected Logger logger;
    volatile int state = 1;
    protected volatile int internalState = 1;
    volatile boolean updateState = true;
    volatile int closing;
    final int maxSendAttempts;
    final int responseTimeout;
    CEMI keepForCon;
    private ReceiverLoop receiver;
    final Object lock = new Object();
    private int seqRcv;
    private int seqSend;
    private final Semaphore sendWaitQueue = new Semaphore();
    private boolean inBlockingSend;

    protected ConnectionBase(int serviceRequest, int serviceAck, int maxSendAttempts, int responseTimeout) {
        this.serviceRequest = serviceRequest;
        this.serviceAck = serviceAck;
        this.maxSendAttempts = maxSendAttempts;
        this.responseTimeout = responseTimeout;
    }

    @Override
    public void addConnectionListener(KNXListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeConnectionListener(KNXListener l) {
        this.listeners.remove(l);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void send(CEMI frame, KNXnetIPConnection.BlockingMode mode) throws KNXTimeoutException, KNXConnectionClosedException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void send(byte[] packet, InetSocketAddress dst) throws IOException {
        DatagramPacket p = new DatagramPacket(packet, packet.length, dst);
        if (dst.equals(this.dataEndpt)) {
            this.socket.send(p);
        } else {
            this.ctrlSocket.send(p);
        }
    }

    @Override
    public final InetSocketAddress getRemoteAddress() {
        if (this.state == 1) {
            return new InetSocketAddress(0);
        }
        return this.ctrlEndpt;
    }

    @Override
    public final int getState() {
        return this.state;
    }

    @Override
    public String name() {
        return Net.hostPort(this.ctrlEndpt);
    }

    @Override
    public final void close() {
        this.close(0, "user request", LogService.LogLevel.DEBUG, null);
    }

    public String toString() {
        return String.valueOf(this.name()) + (this.channelId != 0 ? " channel " + this.channelId : "") + " (state " + this.connectionState() + ")";
    }

    protected synchronized int getSeqRcv() {
        return this.seqRcv;
    }

    protected synchronized void incSeqRcv() {
        this.seqRcv = this.seqRcv + 1 & 0xFF;
    }

    protected synchronized int getSeqSend() {
        return this.seqSend;
    }

    protected synchronized void incSeqSend() {
        this.seqSend = this.seqSend + 1 & 0xFF;
    }

    protected void fireFrameReceived(CEMI frame) {
        FrameEvent fe = new FrameEvent((Object)this, frame);
        this.listeners.fire(l -> l.frameReceived(fe));
    }

    boolean handleServiceType(KNXnetIPHeader h, byte[] data, int offset, InetSocketAddress source) throws KNXFormatException, IOException {
        int hdrStart = offset - h.getStructLength();
        this.logger.trace("from {}: {}: {}", new Object[]{Net.hostPort(source), h, DataUnitBuilder.toHex(Arrays.copyOfRange(data, hdrStart, hdrStart + h.getTotalLength()), " ")});
        return this.handleServiceType(h, data, offset, source.getAddress(), source.getPort());
    }

    protected boolean handleServiceType(KNXnetIPHeader h, byte[] data, int offset, InetAddress src, int port) throws KNXFormatException, IOException {
        return false;
    }

    protected final void setState(int newState) {
        if (this.closing < 2) {
            if (this.internalState == 0 && newState == 4) {
                return;
            }
            this.internalState = newState;
            if (this.updateState) {
                this.state = newState;
            }
        } else {
            this.internalState = 1;
            this.state = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setStateNotify(int newState) {
        Object object = this.lock;
        synchronized (object) {
            this.setState(newState);
            if (newState == 0 && !this.inBlockingSend) {
                this.sendWaitQueue.release(false);
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(int initiator, String reason, LogService.LogLevel level, Throwable t) {
        Object object = this;
        synchronized (object) {
            if (this.closing > 0) {
                return;
            }
            this.closing = 1;
        }
        try {
            object = this.lock;
            synchronized (object) {
                boolean tcp;
                boolean bl = tcp = this.ctrlSocket == null;
                HPAI hpai = tcp ? HPAI.Tcp : new HPAI(1, this.useNat ? null : (InetSocketAddress)this.ctrlSocket.getLocalSocketAddress());
                this.logger.trace("sending disconnect request for {}", (Object)this);
                byte[] buf = PacketHelper.toPacket(new DisconnectRequest(this.channelId, hpai));
                this.send(buf, this.ctrlEndpt);
                long remaining = 10000L;
                long end = System.currentTimeMillis() + remaining;
                while (this.closing == 1 && remaining > 0L) {
                    this.lock.wait(remaining);
                    remaining = end - System.currentTimeMillis();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException | RuntimeException e) {
            this.logger.error("send disconnect failed", (Throwable)e);
        }
        this.cleanup(initiator, reason, level, t);
    }

    protected void cleanup(int initiator, String reason, LogService.LogLevel level, Throwable t) {
        this.setStateNotify(1);
        this.fireConnectionClosed(initiator, reason);
        this.listeners.removeAll();
    }

    protected boolean supportedVersion(KNXnetIPHeader h) {
        boolean supported;
        boolean bl = supported = h.getVersion() == 16;
        if (!supported) {
            this.logger.warn("KNXnet/IP {}.{} {}", new Object[]{h.getVersion() >> 4, h.getVersion() & 0xF, ErrorCodes.getErrorMessage(2)});
        }
        return supported;
    }

    protected boolean checkChannelId(int id, String svcType) {
        if (id == this.channelId) {
            return true;
        }
        this.logger.warn("received service " + svcType + " with wrong channel ID " + id + ", expected " + this.channelId + " - ignored");
        return false;
    }

    @Deprecated
    protected ServiceRequest<ServiceType> getServiceRequest(KNXnetIPHeader h, byte[] data, int offset) throws KNXFormatException {
        return ServiceRequest.from(h, data, offset);
    }

    final void startReceiver() {
        if (this.receiver == null) {
            ReceiverLoop looper = new ReceiverLoop(this, this.socket, 512);
            Thread t = new Thread((Runnable)looper, "KNXnet/IP receiver");
            t.setDaemon(true);
            t.start();
            this.receiver = looper;
        }
    }

    final void stopReceiver() {
        if (this.receiver != null) {
            this.receiver.quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForStateChange(int initialState, int timeout) throws InterruptedException {
        boolean changed = false;
        long remaining = (long)timeout * 1000L;
        long end = System.currentTimeMillis() + remaining;
        Object object = this.lock;
        synchronized (object) {
            while (this.internalState == initialState && remaining > 0L) {
                this.lock.wait(remaining);
                remaining = end - System.currentTimeMillis();
            }
        }
        changed = remaining > 0L;
        return changed;
    }

    void doExtraBlockingModes() throws KNXTimeoutException, InterruptedException {
    }

    String connectionState() {
        switch (this.state) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "closed";
            }
            case 2: {
                return "ACK pending";
            }
            case 3: {
                return "ACK error";
            }
        }
        return "unknown";
    }

    private void fireConnectionClosed(int initiator, String reason) {
        CloseEvent ce = new CloseEvent(this, initiator, reason);
        this.listeners.fire(l -> l.connectionClosed(ce));
    }

    private static final class Semaphore {
        private Node head;
        private Node tail;
        private int cnt = 1;
        private int nonblockingCnt = 0;

        Semaphore() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void acquire(boolean blocking) {
            Node n;
            boolean interrupted = false;
            Object object = this;
            synchronized (object) {
                if (this.cnt > 0 && this.tail == null) {
                    --this.cnt;
                    if (!blocking) {
                        ++this.nonblockingCnt;
                    }
                    return;
                }
                if (!blocking) {
                    ++this.nonblockingCnt;
                    return;
                }
                n = this.enqueue();
            }
            object = n;
            synchronized (object) {
                while (n.blocked) {
                    try {
                        n.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interrupted = true;
                    }
                }
            }
            object = this;
            synchronized (object) {
                this.dequeue();
                --this.cnt;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }

        synchronized void release(boolean blocking) {
            if (blocking) {
                if (++this.cnt > 0) {
                    this.notifyNext();
                }
            } else if (this.nonblockingCnt > 0) {
                --this.nonblockingCnt;
                if (this.nonblockingCnt == 0 && ++this.cnt > 0) {
                    this.notifyNext();
                }
            }
        }

        private Node enqueue() {
            Node n = new Node(null);
            if (this.tail == null) {
                this.tail = n;
            } else {
                this.head.next = n;
            }
            this.head = n;
            return this.head;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyNext() {
            if (this.tail != null) {
                Node node = this.tail;
                synchronized (node) {
                    this.tail.blocked = false;
                    this.tail.notify();
                }
            }
        }

        private void dequeue() {
            this.tail = this.tail.next;
            if (this.tail == null) {
                this.head = null;
            }
        }

        private static final class Node {
            Node next;
            boolean blocked;

            Node(Node n) {
                this.next = n;
                this.blocked = true;
            }
        }
    }
}

