/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.slf4j.Logger;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXInvalidResponseException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.KnxRuntimeException;
import tuwien.auto.calimero.internal.UdpSocketLooper;
import tuwien.auto.calimero.knxnetip.DiscovererTcp;
import tuwien.auto.calimero.knxnetip.Net;
import tuwien.auto.calimero.knxnetip.TcpConnection;
import tuwien.auto.calimero.knxnetip.servicetype.DescriptionRequest;
import tuwien.auto.calimero.knxnetip.servicetype.DescriptionResponse;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.knxnetip.servicetype.PacketHelper;
import tuwien.auto.calimero.knxnetip.servicetype.SearchRequest;
import tuwien.auto.calimero.knxnetip.servicetype.SearchResponse;
import tuwien.auto.calimero.knxnetip.util.Srp;
import tuwien.auto.calimero.log.LogService;

public class Discoverer {
    public static final String LOG_SERVICE = "calimero.knxnetip.Discoverer";
    public static final String SEARCH_MULTICAST = "224.0.23.12";
    public static final int SEARCH_PORT = 3671;
    private static final Logger logger = LogService.getLogger("calimero.knxnetip.Discoverer");
    static final InetAddress SYSTEM_SETUP_MULTICAST;
    private InetAddress host;
    private final int port;
    private final boolean nat;
    private final boolean mcast;
    private volatile Duration timeout = Duration.ofSeconds(10L);
    private final List<ReceiverLoop> receivers = Collections.synchronizedList(new ArrayList());
    private final List<Result<SearchResponse>> responses = Collections.synchronizedList(new ArrayList());
    private static ExecutorService executor;

    static {
        InetAddress a = null;
        try {
            a = InetAddress.getByName(SEARCH_MULTICAST);
        }
        catch (UnknownHostException e) {
            logger.error("on resolving system setup multicast 224.0.23.12", (Throwable)e);
        }
        SYSTEM_SETUP_MULTICAST = a;
        executor = Executors.newCachedThreadPool(runnable -> {
            Thread t = new Thread(runnable);
            t.setDaemon(true);
            return t;
        });
    }

    public static Discoverer udp(boolean nat) {
        return new Discoverer(0, nat);
    }

    public static Discoverer tcp(TcpConnection c) {
        return new DiscovererTcp(c);
    }

    public static Discoverer secure(TcpConnection.SecureSession session) {
        return new DiscovererTcp(session);
    }

    public Discoverer(int localPort, boolean natAware) {
        this(null, localPort, natAware, false);
    }

    public Discoverer(InetAddress localHost, int localPort, boolean natAware, boolean mcastResponse) {
        if (localPort < 0 || localPort > 65535) {
            throw new KNXIllegalArgumentException("port out of range [0..0xFFFF]");
        }
        this.host = localHost;
        this.port = localPort;
        this.nat = natAware;
        this.mcast = mcastResponse;
        if (this.host != null && this.host.getAddress().length != 4 && !this.nat) {
            throw new KNXIllegalArgumentException("IPv4 address required if NAT is not used (supplied " + this.host.getHostAddress() + ")");
        }
    }

    Discoverer() {
        this.host = null;
        this.port = 0;
        this.nat = false;
        this.mcast = false;
    }

    public Discoverer timeout(Duration timeout) {
        if (timeout.isNegative() || timeout.isZero()) {
            throw new KNXIllegalArgumentException("timeout <= 0");
        }
        this.timeout = timeout;
        return this;
    }

    private CompletableFuture<List<Result<SearchResponse>>> search(Duration timeout) {
        return this.searchAsync(timeout, new Srp[0]);
    }

    public CompletableFuture<List<Result<SearchResponse>>> search(Srp ... searchParameters) {
        return this.searchAsync(this.timeout(), searchParameters);
    }

    public CompletableFuture<Result<SearchResponse>> search(InetSocketAddress serverControlEndpoint, Srp ... searchParameters) throws KNXException {
        InetAddress addr = this.nat ? this.host : (this.host != null ? this.host : Net.onSameSubnet(serverControlEndpoint.getAddress()).orElseGet(Discoverer::localHost));
        try {
            DatagramChannel dc = Discoverer.newChannel(new InetSocketAddress(addr, this.port));
            InetSocketAddress local = (InetSocketAddress)dc.getLocalAddress();
            logger.debug("search {} -> server control endpoint {}", (Object)Net.hostPort(local), (Object)Net.hostPort(serverControlEndpoint));
            InetSocketAddress res = this.nat ? new InetSocketAddress(0) : local;
            byte[] request = PacketHelper.toPacket(new SearchRequest(res, searchParameters));
            dc.send(ByteBuffer.wrap(request), serverControlEndpoint);
            return this.receiveAsync(dc, serverControlEndpoint, this.timeout());
        }
        catch (IOException e) {
            throw new KNXException("search request to " + Net.hostPort(serverControlEndpoint) + " failed on " + addr, e);
        }
    }

    private static InetAddress localHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            throw new KnxRuntimeException("local IP required, but getting local host failed");
        }
    }

    Duration timeout() {
        return this.timeout;
    }

    public void startSearch(NetworkInterface ni, int timeout, boolean wait) throws KNXException, InterruptedException {
        this.startSearch(this.port, ni, timeout, wait);
    }

    public void startSearch(int localPort, NetworkInterface ni, int timeout, boolean wait) throws KNXException, InterruptedException {
        if (timeout < 0) {
            throw new KNXIllegalArgumentException("timeout has to be >= 0");
        }
        if (localPort < 0 || localPort > 65535) {
            throw new KNXIllegalArgumentException("port out of range [0..0xFFFF]");
        }
        List l = Optional.ofNullable(ni).map(NetworkInterface::getInetAddresses).map(Collections::list).orElse(new ArrayList());
        InetAddress addr = l.stream().filter(ia -> this.nat || ia instanceof Inet4Address).findFirst().orElse(this.host(null));
        CompletableFuture<Void> cf = this.search(addr, localPort, ni, Duration.ofSeconds(timeout), this.responses::add, new Srp[0]);
        if (wait) {
            try {
                cf.get();
            }
            catch (CancellationException | ExecutionException e) {
                logger.error("search completed with error", (Throwable)e);
            }
        }
    }

    public void startSearch(int timeout, boolean wait) throws InterruptedException {
        CompletableFuture<List<Result<SearchResponse>>> search = this.search(Duration.ofSeconds(timeout));
        if (!wait) {
            return;
        }
        try {
            try {
                search.get();
            }
            catch (CancellationException | ExecutionException e) {
                logger.error("search completed with error", (Throwable)e);
                this.stopSearch();
            }
        }
        finally {
            this.stopSearch();
        }
    }

    /*
     * Unable to fully structure code
     */
    private CompletableFuture<List<Result<SearchResponse>>> searchAsync(Duration timeout, Srp ... searchParameters) {
        if (timeout.isNegative()) {
            throw new KNXIllegalArgumentException("timeout has to be >= 0");
        }
        try {
            nifs = (NetworkInterface[])NetworkInterface.networkInterfaces().toArray((IntFunction<NetworkInterface[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$6(int ), (I)[Ljava/net/NetworkInterface;)());
        }
        catch (SocketException e) {
            return CompletableFuture.failedFuture(e);
        }
        lo = false;
        cfs = new ArrayList<CompletableFuture<Void>>();
        responses = Collections.newSetFromMap(new ConcurrentHashMap<K, V>());
        var10_8 = nifs;
        var9_9 = nifs.length;
        var8_10 = 0;
        while (var8_10 < var9_9) {
            ni = var10_8[var8_10];
            ea = ni.getInetAddresses();
            while (ea.hasMoreElements()) {
                a = ea.nextElement();
                if (!this.nat && a.getAddress().length != 4) {
                    Discoverer.logger.debug("skip {}, not an IPv4 address", (Object)a);
                    continue;
                }
                try {
                    block14: {
                        block13: {
                            if (!lo) break block13;
                            if (a.isLoopbackAddress()) break block14;
                        }
                        cfs.add(this.search(a, this.port, ni, timeout, (Consumer<Result<SearchResponse>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Ltuwien/auto/calimero/knxnetip/Discoverer$Result;)V)(responses), searchParameters));
                    }
                    if (!a.isLoopbackAddress()) continue;
                    lo = true;
                    continue;
                }
                catch (RuntimeException | KNXException e) {
                    causeMsg = "";
                    t = e.getCause();
                    ** while (t != null && t != t.getCause())
                }
lbl-1000:
                // 1 sources

                {
                    msg = t.getMessage();
                    causeMsg = " (" + (msg != null ? msg : t.toString()) + ")";
                    t = t.getCause();
                    continue;
                }
lbl43:
                // 1 sources

                Discoverer.logger.warn("using {} at {}: {}{}", new Object[]{a, ni.getName(), e.getMessage(), causeMsg});
            }
            ++var8_10;
        }
        if (cfs.size() == 0) {
            return CompletableFuture.failedFuture(new KNXException("search could not be started on any network interface"));
        }
        search = CompletableFuture.allOf(cfs.toArray(new CompletableFuture[0])).thenApply((Function<Void, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$8(java.util.Set java.lang.Void ), (Ljava/lang/Void;)Ljava/util/List;)(responses));
        search.exceptionally((Function<Throwable, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$9(java.util.List java.lang.Throwable ), (Ljava/lang/Throwable;)Ljava/util/List;)(cfs));
        return search;
    }

    public final void stopSearch() {
        ReceiverLoop[] loopers = this.receivers.toArray(new ReceiverLoop[this.receivers.size()]);
        int i = 0;
        while (i < loopers.length) {
            ReceiverLoop loop = loopers[i];
            loop.quit();
            ++i;
        }
        this.receivers.removeAll(Arrays.asList(loopers));
    }

    public final boolean isSearching() {
        return this.receivers.size() != 0;
    }

    public final List<Result<SearchResponse>> getSearchResponses() {
        return Collections.unmodifiableList(this.responses);
    }

    public final void clearSearchResponses() {
        this.responses.clear();
    }

    public Result<DescriptionResponse> getDescription(InetSocketAddress server, int timeout) throws KNXException {
        if (timeout <= 0 || timeout >= 2147483) {
            throw new KNXIllegalArgumentException("timeout out of range");
        }
        InetAddress localhost = this.host(server.getAddress());
        InetSocketAddress bind = new InetSocketAddress(this.nat ? null : Net.onSameSubnet(server.getAddress()).orElse(localhost), this.port);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (DatagramChannel dc = Discoverer.newChannel(bind);){
                InetSocketAddress local = (InetSocketAddress)dc.getLocalAddress();
                byte[] buf = PacketHelper.toPacket(new DescriptionRequest(this.nat ? null : local));
                dc.send(ByteBuffer.wrap(buf), server);
                ReceiverLoop looper = new ReceiverLoop(dc, 512, Duration.ofSeconds(timeout), server);
                looper.loop();
                if (looper.thrown != null) {
                    throw looper.thrown;
                }
                if (looper.res != null) {
                    return new Result<DescriptionResponse>(looper.res, NetworkInterface.getByInetAddress(local.getAddress()), local, server);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new KNXException("network failure on getting description from " + Net.hostPort(server), e);
        }
        throw new KNXTimeoutException("timeout, no description response received from " + Net.hostPort(server));
    }

    private CompletableFuture<Void> search(InetAddress localAddr, int localPort, NetworkInterface ni, Duration timeout, Consumer<Result<SearchResponse>> notifyResponse, Srp ... searchParameters) throws KNXException {
        InetSocketAddress bind = this.mcast ? new InetSocketAddress(3671) : new InetSocketAddress(localAddr, localPort);
        try {
            DatagramChannel channel = Discoverer.newChannel(bind);
            if (ni != null) {
                channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, ni);
            }
            if (this.mcast) {
                channel.join(SYSTEM_SETUP_MULTICAST, ni);
            }
            String nifName = ni != null ? String.valueOf(ni.getName()) + " " : "";
            int realLocalPort = ((InetSocketAddress)channel.getLocalAddress()).getPort();
            InetSocketAddress localEndpoint = new InetSocketAddress(localAddr, realLocalPort);
            logger.debug("search on " + nifName + localEndpoint);
            InetSocketAddress res = this.mcast ? new InetSocketAddress(SYSTEM_SETUP_MULTICAST, realLocalPort) : (this.nat ? new InetSocketAddress(0) : localEndpoint);
            InetSocketAddress dst = new InetSocketAddress(SYSTEM_SETUP_MULTICAST, 3671);
            SearchRequest req = searchParameters.length > 0 ? new SearchRequest(res, searchParameters) : new SearchRequest(res, Srp.withDeviceDescription(1, 2, 8, 6, 7));
            channel.send(ByteBuffer.wrap(PacketHelper.toPacket(req)), dst);
            if (searchParameters.length == 0) {
                byte[] std = PacketHelper.toPacket(new SearchRequest(res));
                channel.send(ByteBuffer.wrap(std), dst);
            }
            return this.receiveAsync(channel, localEndpoint, timeout, String.valueOf(nifName) + localAddr.getHostAddress(), notifyResponse);
        }
        catch (IOException | RuntimeException e) {
            throw new KNXException("search request to " + SYSTEM_SETUP_MULTICAST.getHostAddress() + " failed on " + localAddr + ":" + localPort, e);
        }
    }

    private static DatagramChannel newChannel(InetSocketAddress bind) throws IOException {
        return (DatagramChannel)((AbstractSelectableChannel)((Object)((DatagramChannel)DatagramChannel.open(StandardProtocolFamily.INET).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true)).bind(bind).setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)64))).configureBlocking(false);
    }

    private synchronized InetAddress host(InetAddress remote) throws KNXException {
        try {
            if (remote == null) {
                return InetAddress.getLocalHost();
            }
            if (this.host == null) {
                this.host = InetAddress.getLocalHost();
            }
            return this.host;
        }
        catch (UnknownHostException e) {
            throw new KNXException("on resolving address of local host", e);
        }
    }

    private CompletableFuture<Void> receiveAsync(DatagramChannel dc, InetSocketAddress localEndpoint, Duration timeout, String name, Consumer<Result<SearchResponse>> notifyResponse) throws IOException {
        ReceiverLoop looper = new ReceiverLoop(dc, localEndpoint, 512, timeout, String.valueOf(name) + ":" + ((InetSocketAddress)dc.getLocalAddress()).getPort(), notifyResponse);
        CompletableFuture<Void> cf = CompletableFuture.runAsync(looper, executor);
        cf.exceptionally(t -> {
            looper.quit();
            return null;
        });
        return cf;
    }

    private CompletableFuture<Result<SearchResponse>> receiveAsync(DatagramChannel dc, InetSocketAddress serverCtrlEndpoint, Duration timeout) throws IOException {
        ReceiverLoop looper = new ReceiverLoop(dc, 512, timeout.plusSeconds(1L), serverCtrlEndpoint);
        InetSocketAddress local = (InetSocketAddress)dc.getLocalAddress();
        NetworkInterface netif = local.getAddress().isAnyLocalAddress() ? Net.defaultNetif : NetworkInterface.getByInetAddress(local.getAddress());
        CompletableFuture<Result<SearchResponse>> cf = ((CompletableFuture)CompletableFuture.runAsync(looper, executor).thenApply(__ -> new Result<SearchResponse>(receiverLoop.sr, netif, local, serverCtrlEndpoint))).orTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS);
        cf.exceptionally(t -> {
            looper.quit();
            return null;
        });
        return cf;
    }

    private static /* synthetic */ NetworkInterface[] lambda$6(int n) {
        return new NetworkInterface[n];
    }

    private static /* synthetic */ List lambda$8(Set set, Void __) {
        return List.copyOf(set);
    }

    private static /* synthetic */ List lambda$9(List list, Throwable t) {
        list.forEach(cf -> {
            boolean bl = cf.cancel(false);
        });
        return null;
    }

    private final class ReceiverLoop
    extends UdpSocketLooper
    implements Runnable {
        private final boolean multicast;
        private final InetSocketAddress server;
        private final NetworkInterface nif;
        private final InetSocketAddress localEndpoint;
        private DescriptionResponse res;
        private SearchResponse sr;
        private KNXInvalidResponseException thrown;
        private final String id;
        private final Selector selector;
        private final Duration timeout;
        private final Consumer<Result<SearchResponse>> notifyResponse;

        ReceiverLoop(DatagramChannel dc, InetSocketAddress localEndpoint, int receiveBufferSize, Duration timeout, String name, Consumer<Result<SearchResponse>> notifyResponse) throws IOException {
            super(null, false, receiveBufferSize, 0, (int)timeout.toMillis());
            this.nif = dc.getOption(StandardSocketOptions.IP_MULTICAST_IF);
            this.localEndpoint = localEndpoint;
            this.multicast = true;
            this.server = null;
            this.id = name;
            this.selector = Selector.open();
            dc.register(this.selector, 1);
            this.timeout = timeout;
            this.notifyResponse = notifyResponse;
            Discoverer.this.receivers.add(this);
        }

        ReceiverLoop(DatagramChannel dc, int receiveBufferSize, Duration timeout, InetSocketAddress queriedServer) throws IOException {
            super(null, true, receiveBufferSize, 0, (int)timeout.toMillis());
            this.nif = null;
            this.localEndpoint = null;
            this.multicast = false;
            this.server = queriedServer;
            this.id = "" + dc.getLocalAddress();
            this.selector = Selector.open();
            dc.register(this.selector, 1);
            this.timeout = timeout;
            this.notifyResponse = null;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("Discoverer " + this.id);
            try {
                try {
                    this.loop();
                }
                catch (IOException e) {
                    logger.error("while waiting for response", (Throwable)e);
                    logger.trace("stopped on " + this.id);
                    Thread.currentThread().setName("Discoverer (idle)");
                    Discoverer.this.receivers.remove(this);
                }
            }
            finally {
                logger.trace("stopped on " + this.id);
                Thread.currentThread().setName("Discoverer (idle)");
                Discoverer.this.receivers.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(InetSocketAddress source, byte[] data, int offset, int length) {
            block21: {
                try {
                    KNXnetIPHeader h = new KNXnetIPHeader(data, offset);
                    int bodyLen = h.getTotalLength() - h.getStructLength();
                    int svc = h.getServiceType();
                    if (h.getTotalLength() > length) {
                        logger.warn("ignore received packet from {}, packet size {} > buffer size {}", new Object[]{source, h.getTotalLength(), length});
                        break block21;
                    }
                    if (this.multicast && (svc == 514 || svc == 524)) {
                        List<ReceiverLoop> list = Discoverer.this.receivers;
                        synchronized (list) {
                            if (Discoverer.this.receivers.contains(this)) {
                                SearchResponse response = SearchResponse.from(h, data, offset + h.getStructLength());
                                Result<SearchResponse> r = new Result<SearchResponse>(response, this.nif, this.localEndpoint, source);
                                this.notifyResponse.accept(r);
                                if (!Discoverer.this.responses.contains(r)) {
                                    Discoverer.this.responses.add(r);
                                }
                            }
                            break block21;
                        }
                    }
                    if (!this.multicast && svc == 516) {
                        if (!source.equals(this.server)) break block21;
                        try {
                            try {
                                this.res = new DescriptionResponse(data, offset + h.getStructLength(), bodyLen);
                            }
                            catch (KNXFormatException e) {
                                this.thrown = new KNXInvalidResponseException("invalid description response from " + Net.hostPort(source), e);
                                this.quit();
                            }
                            break block21;
                        }
                        finally {
                            this.quit();
                        }
                    }
                    if (this.multicast || svc != 524 || !source.equals(this.server)) break block21;
                    try {
                        try {
                            this.sr = SearchResponse.from(h, data, offset + h.getStructLength());
                        }
                        catch (KNXFormatException e) {
                            this.thrown = new KNXInvalidResponseException("invalid search response from " + Net.hostPort(source), e);
                            this.quit();
                        }
                    }
                    finally {
                        this.quit();
                    }
                }
                catch (KNXFormatException e) {
                    logger.info("ignore received packet from {}, {}", (Object)source, (Object)e.getMessage());
                }
                catch (RuntimeException e) {
                    logger.warn("error parsing received packet from {}", (Object)source, (Object)e);
                }
            }
        }

        @Override
        protected void receive(byte[] buf) throws IOException {
            Duration remaining = this.timeout;
            Instant end = Instant.now().plus(remaining);
            while (remaining.toMillis() > 0L) {
                if (this.selector.select(remaining.toMillis()) > 0) {
                    Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
                    while (i.hasNext()) {
                        SelectionKey key = i.next();
                        SelectableChannel channel = key.channel();
                        ByteBuffer buffer = ByteBuffer.wrap(buf);
                        SocketAddress source = ((DatagramChannel)channel).receive(buffer);
                        buffer.flip();
                        this.onReceive((InetSocketAddress)source, buf, buffer.position(), buffer.remaining());
                        i.remove();
                    }
                    return;
                }
                remaining = Duration.between(Instant.now(), end);
            }
        }
    }

    public static final class Result<T> {
        private final T response;
        private final NetworkInterface ni;
        private final InetSocketAddress local;
        private final InetSocketAddress remote;

        Result(T r, NetworkInterface outgoing, InetSocketAddress local, InetSocketAddress remote) {
            this.response = r;
            this.ni = outgoing;
            this.local = local;
            this.remote = remote;
        }

        public T getResponse() {
            return this.response;
        }

        public NetworkInterface getNetworkInterface() {
            return this.ni;
        }

        public InetSocketAddress localEndpoint() {
            return this.local;
        }

        public InetSocketAddress remoteEndpoint() {
            return this.remote;
        }

        public String toString() {
            return String.valueOf(Net.hostPort(this.local)) + " (" + this.ni.getName() + ") <- " + this.response;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Result)) {
                return false;
            }
            Result other = (Result)obj;
            return this.getNetworkInterface().equals(other.getNetworkInterface()) && this.localEndpoint().equals(other.localEndpoint()) && this.getResponse().equals(other.getResponse()) && this.remote.equals(other.remote);
        }

        public int hashCode() {
            return 17 * (17 * (17 * this.getNetworkInterface().hashCode() + this.localEndpoint().hashCode()) + this.getResponse().hashCode()) + this.remote.hashCode();
        }
    }
}

