/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.knxnetip.Discoverer;
import tuwien.auto.calimero.knxnetip.KNXnetIPTunnel;
import tuwien.auto.calimero.knxnetip.Net;
import tuwien.auto.calimero.knxnetip.SecureConnection;
import tuwien.auto.calimero.knxnetip.TcpConnection;
import tuwien.auto.calimero.knxnetip.servicetype.DescriptionRequest;
import tuwien.auto.calimero.knxnetip.servicetype.DescriptionResponse;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.knxnetip.servicetype.PacketHelper;
import tuwien.auto.calimero.knxnetip.servicetype.SearchRequest;
import tuwien.auto.calimero.knxnetip.servicetype.SearchResponse;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceType;
import tuwien.auto.calimero.knxnetip.util.CRI;
import tuwien.auto.calimero.knxnetip.util.Srp;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;

public class DiscovererTcp
extends Discoverer {
    private final TcpConnection connection;
    private final TcpConnection.SecureSession session;

    DiscovererTcp(TcpConnection c) {
        this.connection = c;
        this.session = null;
    }

    DiscovererTcp(TcpConnection.SecureSession s) {
        this.connection = s.connection();
        this.session = s;
    }

    @Override
    public DiscovererTcp timeout(Duration timeout) {
        return (DiscovererTcp)super.timeout(timeout);
    }

    @Override
    public CompletableFuture<List<Discoverer.Result<SearchResponse>>> search(Srp ... searchParameters) {
        SearchRequest req = SearchRequest.newTcpRequest(searchParameters);
        CompletableFuture result = this.send(PacketHelper.toPacket(req));
        return result.thenApply(List::of);
    }

    public Discoverer.Result<DescriptionResponse> description() throws KNXException, InterruptedException {
        try {
            byte[] request = PacketHelper.toPacket(DescriptionRequest.tcpRequest());
            CompletableFuture cf = this.send(request);
            return cf.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof KNXException) {
                throw (KNXException)cause;
            }
            if (cause instanceof TimeoutException) {
                throw new KNXTimeoutException(cause.getMessage());
            }
            throw new KNXException("waiting for description response", cause);
        }
    }

    @Override
    @Deprecated(forRemoval=true)
    public CompletableFuture<Discoverer.Result<SearchResponse>> search(InetSocketAddress serverControlEndpoint, Srp ... searchParameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated(forRemoval=true)
    public void startSearch(NetworkInterface ni, int timeout, boolean wait) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated(forRemoval=true)
    public void startSearch(int localPort, NetworkInterface ni, int timeout, boolean wait) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated(forRemoval=true)
    public Discoverer.Result<DescriptionResponse> getDescription(InetSocketAddress server, int timeout) {
        throw new UnsupportedOperationException();
    }

    private <T> CompletableFuture<Discoverer.Result<T>> send(byte[] packet) {
        try {
            CompletableFuture cf = new CompletableFuture();
            Tunnel tunnel = new Tunnel(KNXnetIPTunnel.TunnelingLayer.LinkLayer, this.connection, KNXMediumSettings.BackboneRouter, cf);
            tunnel.send(packet);
            cf.whenCompleteAsync((_1, _2) -> tunnel.close());
            return cf.orTimeout(this.timeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (IOException | InterruptedException | KNXException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private final class Tunnel<T>
    extends KNXnetIPTunnel {
        private final CompletableFuture<Discoverer.Result<T>> cf;

        Tunnel(KNXnetIPTunnel.TunnelingLayer knxLayer, TcpConnection connection, IndividualAddress tunnelingAddress, CompletableFuture<Discoverer.Result<T>> cf) throws KNXException, InterruptedException {
            super(knxLayer, connection, tunnelingAddress);
            this.cf = cf;
        }

        @Override
        protected boolean handleServiceType(KNXnetIPHeader h, byte[] data, int offset, InetAddress src, int port) throws KNXFormatException, IOException {
            int svc = h.getServiceType();
            if (svc == 524 || svc == 516) {
                ServiceType sr = svc == 524 ? SearchResponse.from(h, data, offset) : new DescriptionResponse(data, offset, h.getTotalLength() - h.getStructLength());
                Discoverer.Result<DescriptionResponse> result = new Discoverer.Result<DescriptionResponse>((DescriptionResponse)sr, NetworkInterface.getByInetAddress(DiscovererTcp.this.connection.localEndpoint().getAddress()), DiscovererTcp.this.connection.localEndpoint(), DiscovererTcp.this.connection.server());
                this.complete(result);
                return true;
            }
            return super.handleServiceType(h, data, offset, src, port);
        }

        private void complete(Discoverer.Result<?> result) {
            this.cf.complete(result);
        }

        @Override
        public String name() {
            String lock = new String(Character.toChars(128274));
            String secure = DiscovererTcp.this.session != null ? " " + lock : "";
            return "KNX IP" + secure + " Tunneling " + Net.hostPort(this.ctrlEndpt);
        }

        @Override
        protected void connect(TcpConnection c, CRI cri) throws KNXException, InterruptedException {
            if (DiscovererTcp.this.session == null) {
                super.connect(c, cri);
                return;
            }
            DiscovererTcp.this.session.ensureOpen();
            DiscovererTcp.this.session.registerConnectRequest(this);
            try {
                super.connect(c.localEndpoint(), c.server(), cri, false);
            }
            finally {
                DiscovererTcp.this.session.unregisterConnectRequest(this);
            }
        }

        @Override
        protected void send(byte[] packet, InetSocketAddress dst) throws IOException {
            byte[] send = packet;
            if (DiscovererTcp.this.session != null) {
                send = SecureConnection.newSecurePacket(DiscovererTcp.this.session.id(), DiscovererTcp.this.session.nextSendSeq(), DiscovererTcp.this.session.serialNumber(), 0, packet, DiscovererTcp.this.session.secretKey);
            }
            super.send(send, dst);
        }

        void send(byte[] packet) throws IOException {
            this.send(packet, new InetSocketAddress(0));
        }
    }
}

