/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip;

import java.net.InetSocketAddress;
import tuwien.auto.calimero.Connection;
import tuwien.auto.calimero.KNXListener;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.knxnetip.KNXConnectionClosedException;

public interface KNXnetIPConnection
extends Connection<CEMI> {
    public static final int KNXNETIP_VERSION_10 = 16;
    public static final int DEFAULT_PORT = 3671;
    public static final int OK = 0;
    public static final int CLOSED = 1;

    @Override
    public void addConnectionListener(KNXListener var1);

    @Override
    public void removeConnectionListener(KNXListener var1);

    @Override
    default public void send(CEMI frame, Connection.BlockingMode blockingMode) throws KNXTimeoutException, KNXConnectionClosedException, InterruptedException {
        BlockingMode mode = blockingMode == Connection.BlockingMode.Confirmation ? BlockingMode.WaitForCon : (blockingMode == Connection.BlockingMode.Ack ? BlockingMode.WaitForAck : BlockingMode.NonBlocking);
        this.send(frame, mode);
    }

    public void send(CEMI var1, BlockingMode var2) throws KNXTimeoutException, KNXConnectionClosedException, InterruptedException;

    public InetSocketAddress getRemoteAddress();

    public int getState();

    default public String getName() {
        return this.name();
    }

    @Override
    public void close();

    public static enum BlockingMode {
        NonBlocking,
        WaitForAck,
        WaitForCon;

    }
}

