/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.ServiceType;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMIDevMgmt;
import tuwien.auto.calimero.knxnetip.ClientConnection;
import tuwien.auto.calimero.knxnetip.KNXConnectionClosedException;
import tuwien.auto.calimero.knxnetip.KNXnetIPConnection;
import tuwien.auto.calimero.knxnetip.TcpConnection;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.knxnetip.servicetype.PacketHelper;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceAck;
import tuwien.auto.calimero.knxnetip.servicetype.ServiceRequest;
import tuwien.auto.calimero.knxnetip.util.CRI;
import tuwien.auto.calimero.log.LogService;

public class KNXnetIPDevMgmt
extends ClientConnection {
    public static final int DEVICE_MGMT_CONNECTION = 3;
    private static final int CONFIGURATION_REQ_TIMEOUT = 10;
    static final CRI cri = CRI.createRequest(3, new byte[0]);

    public KNXnetIPDevMgmt(InetSocketAddress localEP, InetSocketAddress serverCtrlEP, boolean useNAT) throws KNXException, InterruptedException {
        this(serverCtrlEP);
        this.connect(localEP, serverCtrlEP, cri, useNAT);
    }

    public KNXnetIPDevMgmt(TcpConnection connection) throws KNXException, InterruptedException {
        super(784, 785, 4, 10, connection);
        this.connect(connection, cri);
    }

    KNXnetIPDevMgmt(InetSocketAddress serverCtrlEP) {
        super(784, 785, 4, 10);
        this.ctrlEndpt = serverCtrlEP;
        this.logger = LogService.getLogger("calimero.knxnetip." + this.name());
    }

    @Override
    public void send(CEMI frame, KNXnetIPConnection.BlockingMode mode) throws KNXTimeoutException, KNXConnectionClosedException, InterruptedException {
        if (!(frame instanceof CEMIDevMgmt)) {
            throw new KNXIllegalArgumentException("unsupported cEMI type");
        }
        super.send(frame, mode);
    }

    @Override
    public String name() {
        return "KNXnet/IP DevMgmt " + super.name();
    }

    @Override
    protected boolean handleServiceType(KNXnetIPHeader h, byte[] data, int offset, InetAddress src, int port) throws KNXFormatException, IOException {
        int status;
        if (super.handleServiceType(h, data, offset, src, port)) {
            return true;
        }
        int svc = h.getServiceType();
        if (svc != this.serviceRequest) {
            return false;
        }
        ServiceRequest<ServiceType> req = ServiceRequest.from(h, data, offset);
        if (!this.checkChannelId(req.getChannelID(), "request")) {
            return true;
        }
        int n = status = h.getVersion() == 16 ? 0 : 2;
        if (!this.tcp) {
            int seq = req.getSequenceNumber();
            if (seq == this.getSeqRcv()) {
                byte[] buf = PacketHelper.toPacket(new ServiceAck(this.serviceAck, this.channelId, seq, status));
                this.send(buf, this.dataEndpt);
                this.incSeqRcv();
            } else {
                this.logger.warn("received dev.mgmt request with rcv-seq {}, expected {} - ignored", (Object)seq, (Object)this.getSeqRcv());
            }
        }
        if (status == 2) {
            this.close(3, "protocol version changed", LogService.LogLevel.ERROR, null);
            return true;
        }
        CEMI cemi = (CEMI)req.service();
        int mc = cemi.getMessageCode();
        if (mc == 247 || mc == 240) {
            this.fireFrameReceived(cemi);
        } else if (mc == 251 || mc == 245) {
            this.fireFrameReceived(cemi);
            this.setStateNotify(0);
        }
        return true;
    }
}

