/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.KnxRuntimeException;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.knxnetip.ConnectionBase;
import tuwien.auto.calimero.knxnetip.Discoverer;
import tuwien.auto.calimero.knxnetip.KNXConnectionClosedException;
import tuwien.auto.calimero.knxnetip.KNXnetIPConnection;
import tuwien.auto.calimero.knxnetip.LostMessageEvent;
import tuwien.auto.calimero.knxnetip.Net;
import tuwien.auto.calimero.knxnetip.ReceiverLoop;
import tuwien.auto.calimero.knxnetip.RoutingBusyEvent;
import tuwien.auto.calimero.knxnetip.RoutingListener;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.knxnetip.servicetype.PacketHelper;
import tuwien.auto.calimero.knxnetip.servicetype.RoutingBusy;
import tuwien.auto.calimero.knxnetip.servicetype.RoutingIndication;
import tuwien.auto.calimero.knxnetip.servicetype.RoutingLostMessage;
import tuwien.auto.calimero.knxnetip.servicetype.RoutingSystemBroadcast;
import tuwien.auto.calimero.knxnetip.servicetype.SearchRequest;
import tuwien.auto.calimero.knxnetip.servicetype.SearchResponse;
import tuwien.auto.calimero.knxnetip.util.HPAI;
import tuwien.auto.calimero.log.LogService;

public class KNXnetIPRouting
extends ConnectionBase {
    public static final String DEFAULT_MULTICAST = "224.0.23.12";
    public static final InetAddress DefaultMulticast = Discoverer.SYSTEM_SETUP_MULTICAST;
    private static final InetAddress systemBroadcast = Discoverer.SYSTEM_SETUP_MULTICAST;
    private static final int GiraUnsupportedSvcType = 1336;
    private boolean loggedGiraUnsupportedSvcType;
    private final InetAddress multicast;
    private DatagramChannel dc;
    private DatagramChannel dcSysBcast;
    private volatile boolean loopbackEnabled;
    private final List<CEMILData> loopbackFrames = new ArrayList<CEMILData>();
    private static final int maxLoopbackQueueSize = 20;
    private volatile BiFunction<KNXnetIPHeader, ByteBuffer, SearchResponse> searchRequestCallback;

    public KNXnetIPRouting(NetworkInterface netIf, InetAddress mcGroup) throws KNXException {
        this(mcGroup);
        this.init(netIf, true, true);
    }

    protected KNXnetIPRouting(InetAddress mcGroup) {
        super(1328, 0, 1, 0);
        if (mcGroup == null) {
            this.multicast = DefaultMulticast;
        } else {
            if (!KNXnetIPRouting.isValidRoutingMulticast(mcGroup)) {
                throw new KNXIllegalArgumentException("non-valid routing multicast " + mcGroup);
            }
            this.multicast = mcGroup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(CEMI frame, KNXnetIPConnection.BlockingMode mode) throws KNXConnectionClosedException {
        if (frame.getMessageCode() != 41) {
            throw new KNXIllegalArgumentException("cEMI frame is not an L-Data.ind");
        }
        try {
            if (this.loopbackEnabled) {
                List<CEMILData> list = this.loopbackFrames;
                synchronized (list) {
                    this.loopbackFrames.add((CEMILData)frame);
                }
                this.logger.trace("add to multicast loopback frame buffer: {}", (Object)frame);
            }
            if (RoutingSystemBroadcast.validSystemBroadcast(frame)) {
                ByteBuffer buf = ByteBuffer.wrap(PacketHelper.toPacket(new RoutingSystemBroadcast(frame)));
                InetSocketAddress dst = new InetSocketAddress(systemBroadcast, 3671);
                this.logger.trace("sending cEMI frame, SBC {} {}", (Object)KNXnetIPConnection.BlockingMode.NonBlocking, (Object)DataUnitBuilder.toHex(buf.array(), " "));
                if (this.dcSysBcast != null) {
                    this.dcSysBcast.send(buf, dst);
                } else {
                    this.dc.send(buf, dst);
                }
            } else {
                super.send(frame, KNXnetIPConnection.BlockingMode.NonBlocking);
            }
            this.setState(0);
        }
        catch (IOException e) {
            this.close(3, "communication failure", LogService.LogLevel.ERROR, e);
            throw new KNXConnectionClosedException("connection closed (" + e.getMessage() + ")");
        }
        catch (KNXTimeoutException kNXTimeoutException) {
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public final void send(RoutingBusy busy) throws KNXConnectionClosedException {
        this.send(PacketHelper.toPacket(busy));
    }

    @Override
    public String name() {
        return "KNXnet/IP Routing " + super.name();
    }

    public final void setHopCount(int hopCount) {
        if (hopCount < 0 || hopCount > 255) {
            throw new KNXIllegalArgumentException("hop count out of range");
        }
        try {
            this.dc.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)hopCount);
        }
        catch (IOException e) {
            this.logger.error("failed to set hop count", (Throwable)e);
        }
    }

    public final int getHopCount() {
        try {
            return this.dc.getOption(StandardSocketOptions.IP_MULTICAST_TTL);
        }
        catch (IOException e) {
            this.logger.error("failed to get hop count", (Throwable)e);
            return 1;
        }
    }

    public final NetworkInterface networkInterface() {
        try {
            NetworkInterface netif = this.dc.getOption(StandardSocketOptions.IP_MULTICAST_IF);
            return netif == null ? Net.defaultNetif : netif;
        }
        catch (IOException e) {
            throw new KnxRuntimeException("socket error getting network interface", e);
        }
    }

    public final boolean usesMulticastLoopback() {
        try {
            return this.dc.getOption(StandardSocketOptions.IP_MULTICAST_LOOP);
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public static boolean isValidRoutingMulticast(InetAddress address) {
        return address != null && address.isMulticastAddress() && KNXnetIPRouting.toLong(address) >= KNXnetIPRouting.toLong(DefaultMulticast);
    }

    protected void init(NetworkInterface netIf, boolean useMulticastLoopback, boolean startReceiver) throws KNXException {
        this.dataEndpt = this.ctrlEndpt = new InetSocketAddress(this.multicast, 3671);
        this.logger = LogService.getLogger("calimero.knxnetip." + this.name());
        try {
            this.dc = KNXnetIPRouting.newChannel();
            this.dcSysBcast = !this.multicast.equals(systemBroadcast) ? KNXnetIPRouting.newChannel() : null;
            NetworkInterface setNetif = netIf;
            if (setNetif != null) {
                this.dc.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, setNetif);
                if (this.dcSysBcast != null) {
                    this.dcSysBcast.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, setNetif);
                }
            } else {
                setNetif = Net.defaultNetif;
            }
            this.logger.debug("join multicast group {} on {}", (Object)this.multicast.getHostAddress(), (Object)setNetif.getName());
            this.dc.join(this.multicast, setNetif);
            if (this.dcSysBcast != null) {
                this.dcSysBcast.join(systemBroadcast, setNetif);
            }
            this.socket = this.dc.socket();
        }
        catch (IOException e) {
            KNXnetIPRouting.closeSilently(this.dc, e);
            KNXnetIPRouting.closeSilently(this.dcSysBcast, e);
            throw new KNXException("initializing multicast (group " + this.multicast.getHostAddress() + "): " + e.getMessage(), e);
        }
        try {
            this.dc.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_LOOP, (Object)useMulticastLoopback);
            if (this.dcSysBcast != null) {
                this.dcSysBcast.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_LOOP, (Object)useMulticastLoopback);
            }
            this.loopbackEnabled = this.usesMulticastLoopback();
            this.logger.info("multicast loopback mode " + (this.loopbackEnabled ? "enabled" : "disabled"));
        }
        catch (IOException e) {
            this.logger.warn("failed to access multicast loopback mode, " + e.getMessage());
        }
        if (startReceiver) {
            this.startChannelReceiver(new ChannelReceiver(this, this.dc), "KNXnet/IP receiver");
        }
        if (this.dcSysBcast != null) {
            ChannelReceiver sysBcastLooper = new ChannelReceiver(this, this.dcSysBcast){

                @Override
                protected void onReceive(InetSocketAddress source, byte[] data, int offset, int length) {
                    try {
                        KNXnetIPHeader h = new KNXnetIPHeader(data, offset);
                        if (h.getTotalLength() > length) {
                            KNXnetIPRouting.this.logger.warn("received frame length " + length + " for " + h + " - ignored");
                        } else if (h.getVersion() != 16) {
                            KNXnetIPRouting.this.close(3, "protocol version changed", LogService.LogLevel.ERROR, null);
                        } else if (h.getServiceType() == 513 || h.getServiceType() == 523) {
                            KNXnetIPRouting.this.searchRequest(source, h, data, offset + h.getStructLength());
                        } else {
                            KNXnetIPRouting.this.systemBroadcast(h, data, offset + h.getStructLength());
                        }
                    }
                    catch (IOException | RuntimeException | KNXFormatException e) {
                        KNXnetIPRouting.this.logger.warn("received invalid frame", (Throwable)e);
                    }
                }
            };
            this.startChannelReceiver(sysBcastLooper, "KNX IP system broadcast receiver");
        }
        this.setState(0);
    }

    private static DatagramChannel newChannel() throws IOException {
        return ((DatagramChannel)DatagramChannel.open(StandardProtocolFamily.INET).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true)).bind(new InetSocketAddress(3671)).setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)64);
    }

    private void startChannelReceiver(ReceiverLoop looper, String name) {
        Thread t = new Thread((Runnable)looper, name);
        t.setDaemon(true);
        t.start();
    }

    protected DatagramChannel channel() {
        return this.dc;
    }

    @Override
    protected boolean handleServiceType(KNXnetIPHeader h, byte[] data, int offset, InetAddress src, int port) throws KNXFormatException, IOException {
        int svc = h.getServiceType();
        if (h.getVersion() != 16) {
            this.close(3, "protocol version changed", LogService.LogLevel.ERROR, null);
        } else if (svc == 1328) {
            RoutingIndication ind = new RoutingIndication(data, offset, h.getTotalLength() - h.getStructLength());
            CEMI frame = ind.getCEMI();
            if (this.discardLoopbackFrame(frame)) {
                return true;
            }
            this.fireFrameReceived(frame);
        } else if (svc == 1329) {
            RoutingLostMessage lost = new RoutingLostMessage(data, offset);
            this.fireLostMessage(new InetSocketAddress(src, port), lost);
        } else if (svc == 1330) {
            RoutingBusy busy = new RoutingBusy(data, offset);
            this.fireRoutingBusy(new InetSocketAddress(src, port), busy);
        } else {
            if (svc == 1331 && this.multicast.equals(systemBroadcast)) {
                return this.systemBroadcast(h, data, offset);
            }
            if (svc == 513 || svc == 523) {
                this.searchRequest(new InetSocketAddress(src, port), h, data, offset);
            } else if (svc == 1336) {
                if (!this.loggedGiraUnsupportedSvcType) {
                    this.logger.warn("received unsupported Gira-specific service type 0x538, will be silently ignored: {}", (Object)DataUnitBuilder.toHex(data, " "));
                }
                this.loggedGiraUnsupportedSvcType = true;
            } else if (!h.isSecure() && svc != 514 && svc != 524) {
                return super.handleServiceType(h, data, offset, src, port);
            }
        }
        return true;
    }

    private void searchRequest(InetSocketAddress source, KNXnetIPHeader h, byte[] data, int offset) throws KNXFormatException, IOException {
        BiFunction<KNXnetIPHeader, ByteBuffer, SearchResponse> callback = this.searchRequestCallback;
        if (callback == null) {
            return;
        }
        HPAI endpoint = SearchRequest.from(h, data, offset).getEndpoint();
        if (endpoint.getHostProtocol() != 1) {
            this.logger.warn("KNX IP has protocol support for UDP/IP only");
            return;
        }
        SearchResponse response = callback.apply(h, ByteBuffer.wrap(data).position(offset));
        if (response != null) {
            DatagramChannel channel = this.dcSysBcast != null ? this.dcSysBcast : this.dc;
            channel.send(ByteBuffer.wrap(PacketHelper.toPacket(response)), KNXnetIPRouting.createResponseAddress(endpoint, source));
        }
    }

    private static InetSocketAddress createResponseAddress(HPAI endpoint, InetSocketAddress sender) {
        if (endpoint.getAddress().isAnyLocalAddress() || endpoint.getPort() == 0) {
            return sender;
        }
        return new InetSocketAddress(endpoint.getAddress(), endpoint.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close(int initiator, String reason, LogService.LogLevel level, Throwable t) {
        KNXnetIPRouting kNXnetIPRouting = this;
        synchronized (kNXnetIPRouting) {
            if (this.closing > 0) {
                return;
            }
            this.closing = 1;
        }
        LogService.log(this.logger, level, "close connection - " + reason, t);
        KNXnetIPRouting.closeSilently(this.dc, null);
        KNXnetIPRouting.closeSilently(this.dcSysBcast, null);
        this.cleanup(initiator, reason, level, t);
    }

    private static void closeSilently(DatagramChannel dc, Exception e) {
        block3: {
            try {
                if (dc != null) {
                    dc.close();
                }
            }
            catch (IOException ioe) {
                if (e == null) break block3;
                e.addSuppressed(ioe);
            }
        }
    }

    protected void send(byte[] packet) throws KNXConnectionClosedException {
        int state = this.getState();
        if (state == 1) {
            this.logger.warn("send invoked on closed connection - aborted");
            throw new KNXConnectionClosedException("connection closed");
        }
        if (state < 0) {
            this.logger.error("send invoked in error state " + state + " - aborted");
            throw new IllegalStateException("in error state, send aborted");
        }
        try {
            this.send(packet, this.dataEndpt);
            this.setState(0);
        }
        catch (InterruptedIOException e) {
            this.close(0, "interrupted", LogService.LogLevel.WARN, e);
            Thread.currentThread().interrupt();
            throw new KNXConnectionClosedException("interrupted connection got closed");
        }
        catch (IOException e) {
            this.close(3, "communication failure", LogService.LogLevel.ERROR, e);
            throw new KNXConnectionClosedException("connection closed");
        }
    }

    @Override
    protected void send(byte[] packet, InetSocketAddress dst) throws IOException {
        this.dc.send(ByteBuffer.wrap(packet), dst);
    }

    private boolean systemBroadcast(KNXnetIPHeader h, byte[] data, int offset) throws KNXFormatException {
        int svc = h.getServiceType();
        if (svc == 1331) {
            RoutingSystemBroadcast ind = new RoutingSystemBroadcast(data, offset, h.getTotalLength() - h.getStructLength());
            CEMI frame = ind.cemi();
            if (this.discardLoopbackFrame(frame)) {
                return true;
            }
            FrameEvent fe = new FrameEvent(this, frame, true);
            this.listeners.fire(l -> l.frameReceived(fe));
            return true;
        }
        return false;
    }

    private void fireLostMessage(InetSocketAddress sender, RoutingLostMessage lost) {
        LostMessageEvent e = new LostMessageEvent(this, sender, lost.getDeviceState(), lost.getLostMessages());
        this.listeners.fire(l -> {
            if (l instanceof RoutingListener) {
                ((RoutingListener)l).lostMessage(e);
            }
        });
    }

    private void fireRoutingBusy(InetSocketAddress sender, RoutingBusy busy) {
        RoutingBusyEvent e = new RoutingBusyEvent(this, sender, busy);
        this.listeners.fire(l -> {
            if (l instanceof RoutingListener) {
                ((RoutingListener)l).routingBusy(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean discardLoopbackFrame(CEMI frame) {
        if (!this.loopbackEnabled) {
            return false;
        }
        byte[] a = frame.toByteArray();
        List<CEMILData> list = this.loopbackFrames;
        synchronized (list) {
            Iterator<CEMILData> i = this.loopbackFrames.iterator();
            while (true) {
                if (!i.hasNext()) {
                    return false;
                }
                if (Arrays.equals(a, i.next().toByteArray())) {
                    i.remove();
                    this.logger.trace("discard multicast loopback cEMI frame: {}", (Object)frame);
                    return true;
                }
                if (this.loopbackFrames.size() <= 20) continue;
                i.remove();
            }
        }
    }

    private static long toLong(InetAddress addr) {
        byte[] buf = addr.getAddress();
        long ret = (long)buf[3] & 0xFFL;
        ret |= (long)(buf[2] << 8) & 0xFF00L;
        ret |= (long)(buf[1] << 16) & 0xFF0000L;
        return ret |= (long)(buf[0] << 24) & 0xFF000000L;
    }

    private static class ChannelReceiver
    extends ReceiverLoop {
        private final DatagramChannel dc;

        ChannelReceiver(KNXnetIPRouting r, DatagramChannel dc) {
            super(r, null, 512, 0, 0);
            this.dc = dc;
        }

        @Override
        protected void setTimeout(int timeout) {
        }

        @Override
        protected void receive(byte[] buf) throws IOException {
            ByteBuffer buffer = ByteBuffer.wrap(buf);
            SocketAddress source = this.dc.receive(buffer);
            buffer.flip();
            this.onReceive((InetSocketAddress)source, buf, buffer.position(), buffer.remaining());
        }
    }
}

