/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXIllegalArgumentException;

final class Net {
    private static final Logger logger = LoggerFactory.getLogger((String)"calimero.knxnetip.Net");
    static final NetworkInterface defaultNetif;

    static {
        try {
            Throwable throwable = null;
            Object var1_2 = null;
            try (MulticastSocket s = new MulticastSocket();){
                defaultNetif = s.getNetworkInterface();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new ExceptionInInitializerError();
        }
    }

    private Net() {
    }

    static Optional<InetAddress> onSameSubnet(InetAddress remote) {
        try {
            return NetworkInterface.networkInterfaces().flatMap(ni -> ni.getInterfaceAddresses().stream()).filter(ia -> ia.getAddress() instanceof Inet4Address).peek(ia -> logger.trace("match local address {}/{} to {}", new Object[]{ia.getAddress().getHostAddress(), ia.getNetworkPrefixLength(), remote.getHostAddress()})).filter(ia -> Net.matchesPrefix(ia.getAddress(), ia.getNetworkPrefixLength(), remote)).map(ia -> ia.getAddress()).findFirst();
        }
        catch (SocketException socketException) {
            return Optional.empty();
        }
    }

    static boolean matchesPrefix(InetAddress local, int maskLength, InetAddress remote) {
        byte[] a1 = local.getAddress();
        byte[] a2 = remote.getAddress();
        long mask = 0xFFFFFFFFL >> maskLength ^ 0xFFFFFFFFL;
        int i = 0;
        while (i < a1.length) {
            int byteMask = (int)(mask >> 24 - 8 * i & 0xFFL);
            if ((a1[i] & byteMask) != (a2[i] & byteMask)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static String hostPort(InetSocketAddress addr) {
        return String.valueOf(addr.getAddress().getHostAddress()) + ":" + addr.getPort();
    }

    static InetSocketAddress matchRemoteEndpoint(InetSocketAddress localEp, InetSocketAddress remoteEp, boolean useNat) throws KNXException {
        if (localEp.isUnresolved()) {
            throw new KNXIllegalArgumentException("unresolved address " + localEp);
        }
        if (!localEp.getAddress().isAnyLocalAddress()) {
            return localEp;
        }
        try {
            InetAddress addr = useNat ? null : Optional.ofNullable(remoteEp.getAddress()).flatMap(Net::onSameSubnet).orElse(InetAddress.getLocalHost());
            return new InetSocketAddress(addr, localEp.getPort());
        }
        catch (UnknownHostException e) {
            throw new KNXException("no local host address available", e);
        }
    }
}

