/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.internal.UdpSocketLooper;
import tuwien.auto.calimero.knxnetip.ConnectionBase;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.log.LogService;

class ReceiverLoop
extends UdpSocketLooper
implements Runnable {
    private final ConnectionBase conn;
    private final Logger logger;

    ReceiverLoop(ConnectionBase connection, DatagramSocket socket, int receiveBufferSize) {
        this(connection, socket, receiveBufferSize, 0, 0);
    }

    ReceiverLoop(ConnectionBase connection, DatagramSocket socket, int receiveBufferSize, int socketTimeout, int loopTimeout) {
        super(socket, true, receiveBufferSize, socketTimeout, loopTimeout);
        this.conn = connection;
        this.logger = connection.logger;
    }

    @Override
    public void run() {
        try {
            this.loop();
        }
        catch (IOException e) {
            this.conn.close(3, "receiver communication failure", LogService.LogLevel.ERROR, e);
        }
    }

    @Override
    protected void onReceive(InetSocketAddress source, byte[] data, int offset, int length) throws IOException {
        try {
            KNXnetIPHeader h = KNXnetIPHeader.from(data, offset);
            if (h.getTotalLength() > length) {
                this.logger.warn("received frame length " + length + " for " + h + " - ignored");
            } else if (h.getServiceType() == 0) {
                this.logger.warn("received frame with service type 0x0 - ignored");
            } else if (!this.conn.handleServiceType(h, data, offset + h.getStructLength(), source)) {
                this.logger.info("received unknown frame with service type 0x" + Integer.toHexString(h.getServiceType()) + " - ignored");
            }
        }
        catch (RuntimeException | KNXFormatException e) {
            this.logger.warn("received invalid frame", (Throwable)e);
        }
    }
}

