/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.NamedParameterSpec;
import java.security.spec.XECPublicKeySpec;
import java.time.Duration;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.knxnetip.KNXnetIPDevMgmt;
import tuwien.auto.calimero.knxnetip.KNXnetIPRouting;
import tuwien.auto.calimero.knxnetip.KNXnetIPTunnel;
import tuwien.auto.calimero.knxnetip.SecureDeviceManagement;
import tuwien.auto.calimero.knxnetip.SecureDeviceManagementUdp;
import tuwien.auto.calimero.knxnetip.SecureRouting;
import tuwien.auto.calimero.knxnetip.SecureSessionUdp;
import tuwien.auto.calimero.knxnetip.SecureTunnel;
import tuwien.auto.calimero.knxnetip.SecureTunnelUdp;
import tuwien.auto.calimero.knxnetip.TcpConnection;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.secure.KnxSecureException;

public final class SecureConnection {
    static final int SecureSvc = 2384;
    static final int SecureSessionResponse = 2386;
    static final int SecureSessionAuth = 2387;
    static final int SecureSessionStatus = 2388;
    static final int macSize = 16;
    static final int keyLength = 32;
    static final String secureSymbol = new String(Character.toChars(128274));

    private SecureConnection() {
    }

    public static KNXnetIPTunnel newTunneling(KNXnetIPTunnel.TunnelingLayer knxLayer, InetSocketAddress localEP, InetSocketAddress serverCtrlEP, boolean useNat, byte[] deviceAuthCode, int userId, byte[] userKey) throws KNXException, InterruptedException {
        byte[] devAuth = deviceAuthCode.length == 0 ? new byte[16] : deviceAuthCode;
        IndividualAddress tunnelingAddress = KNXMediumSettings.BackboneRouter;
        SecureSessionUdp udp = new SecureSessionUdp(userId, userKey, devAuth, serverCtrlEP);
        return new SecureTunnelUdp(knxLayer, localEP, serverCtrlEP, useNat, tunnelingAddress, udp);
    }

    public static KNXnetIPTunnel newTunneling(KNXnetIPTunnel.TunnelingLayer knxLayer, TcpConnection.SecureSession session, IndividualAddress tunnelingAddress) throws KNXException, InterruptedException {
        session.ensureOpen();
        return new SecureTunnel(session, knxLayer, tunnelingAddress);
    }

    public static KNXnetIPRouting newRouting(NetworkInterface netIf, InetAddress mcGroup, byte[] groupKey, Duration latencyTolerance) throws KNXException {
        return new SecureRouting(netIf, mcGroup, groupKey, latencyTolerance);
    }

    public static KNXnetIPDevMgmt newDeviceManagement(InetSocketAddress localEP, InetSocketAddress serverCtrlEP, boolean useNat, byte[] deviceAuthCode, byte[] userKey) throws KNXException, InterruptedException {
        byte[] devAuth = deviceAuthCode.length == 0 ? new byte[16] : deviceAuthCode;
        SecureSessionUdp udp = new SecureSessionUdp(1, userKey, devAuth, serverCtrlEP);
        return new SecureDeviceManagementUdp(localEP, serverCtrlEP, useNat, udp);
    }

    public static KNXnetIPDevMgmt newDeviceManagement(TcpConnection.SecureSession session) throws KNXException, InterruptedException {
        session.ensureOpen();
        return new SecureDeviceManagement(session);
    }

    public static byte[] hashUserPassword(char[] password) {
        byte[] salt = "user-password.1.secure.ip.knx.org".getBytes(StandardCharsets.US_ASCII);
        return SecureConnection.pbkdf2WithHmacSha256(password, salt);
    }

    public static byte[] hashDeviceAuthenticationPassword(char[] password) {
        byte[] salt = "device-authentication-code.1.secure.ip.knx.org".getBytes(StandardCharsets.US_ASCII);
        return SecureConnection.pbkdf2WithHmacSha256(password, salt);
    }

    private static byte[] pbkdf2WithHmacSha256(char[] password, byte[] salt) {
        int i = 0;
        while (i < password.length) {
            char c = password[i];
            if (c < ' ' || c > '~') {
                password[i] = 63;
            }
            ++i;
        }
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec spec = new PBEKeySpec(password, salt, 65536, 128);
            SecretKey key = skf.generateSecret(spec);
            byte[] byArray = key.getEncoded();
            return byArray;
        }
        catch (GeneralSecurityException e) {
            throw new KnxSecureException("PBKDF2WithHmacSHA256", e);
        }
        finally {
            Arrays.fill(password, '\u0000');
        }
    }

    public static byte[] newSecurePacket(long sessionId, long seq, SerialNumber sno, int msgTag, byte[] knxipPacket, Key secretKey) {
        if (seq < 0L || seq > 0xFFFFFFFFFFFFL) {
            throw new KNXIllegalArgumentException("sequence / group counter " + seq + " out of range [0..0xffffffffffff]");
        }
        if (msgTag < 0 || msgTag > 65535) {
            throw new KNXIllegalArgumentException("message tag " + msgTag + " out of range [0..0xffff]");
        }
        int svcLength = 16 + knxipPacket.length + 16;
        KNXnetIPHeader header = new KNXnetIPHeader(2384, svcLength);
        ByteBuffer buffer = ByteBuffer.allocate(header.getTotalLength());
        buffer.put(header.toByteArray());
        buffer.putShort((short)sessionId);
        buffer.putShort((short)(seq >> 32));
        buffer.putInt((int)seq);
        buffer.put(sno.array());
        buffer.putShort((short)msgTag);
        buffer.put(knxipPacket);
        byte[] secInfo = SecureConnection.securityInfo(buffer.array(), header.getStructLength() + 2, knxipPacket.length);
        byte[] mac = SecureConnection.cbcMac(buffer.array(), 0, buffer.position(), secretKey, secInfo);
        buffer.put(mac);
        SecureConnection.encrypt(buffer.array(), header.getStructLength() + 2 + 6 + 6 + 2, secretKey, SecureConnection.securityInfo(buffer.array(), 8, 65280));
        return buffer.array();
    }

    public static Object[] unwrap(KNXnetIPHeader h, byte[] data, int offset, Key secretKey) throws KNXFormatException {
        int hdrLength;
        int minLength;
        if ((h.getServiceType() & 0x950) != 2384) {
            throw new KNXIllegalArgumentException("not a secure service type");
        }
        int total = h.getTotalLength();
        if (total < (minLength = (hdrLength = h.getStructLength()) + 2 + 6 + 6 + 2 + hdrLength + 16)) {
            throw new KNXFormatException("secure packet length < required minimum length " + minLength, total);
        }
        ByteBuffer buffer = ByteBuffer.wrap(data, offset, total - hdrLength);
        int sid = buffer.getShort() & 0xFFFF;
        long seq = SecureConnection.uint48(buffer);
        SerialNumber sno = SerialNumber.of(SecureConnection.uint48(buffer));
        int tag = buffer.getShort() & 0xFFFF;
        ByteBuffer dec = SecureConnection.decrypt(buffer, secretKey, SecureConnection.securityInfo(data, offset + 2, 65280));
        byte[] knxipPacket = new byte[total - minLength + hdrLength];
        dec.get(knxipPacket);
        byte[] mac = new byte[16];
        dec.get(mac);
        byte[] frame = Arrays.copyOfRange(data, offset - hdrLength, offset - hdrLength + total);
        System.arraycopy(knxipPacket, 0, frame, hdrLength + 2 + 6 + 6 + 2, knxipPacket.length);
        SecureConnection.cbcMacVerify(frame, 0, total - 16, secretKey, SecureConnection.securityInfo(data, offset + 2, knxipPacket.length), mac);
        return new Object[]{sid, seq, sno, tag, knxipPacket};
    }

    public static void encrypt(byte[] data, int offset, Key secretKey, byte[] secInfo) {
        try {
            ByteBuffer encrypt = ByteBuffer.wrap(data, offset, data.length - offset);
            ByteBuffer result = SecureConnection.cipher(encrypt, secretKey, secInfo);
            System.arraycopy(result.array(), 0, data, offset, result.remaining());
        }
        catch (GeneralSecurityException e) {
            throw new KnxSecureException("encrypting error", e);
        }
    }

    static ByteBuffer decrypt(ByteBuffer buffer, Key secretKey, byte[] secInfo) {
        try {
            return SecureConnection.cipher(buffer, secretKey, secInfo);
        }
        catch (GeneralSecurityException e) {
            throw new KnxSecureException("decrypting error", e);
        }
    }

    private static ByteBuffer cipher(ByteBuffer buffer, Key secretKey, byte[] secInfo) throws GeneralSecurityException {
        int i;
        int blocks = buffer.remaining() + 15 >> 4;
        byte[] cipher = SecureConnection.cipherStream(blocks, secretKey, secInfo);
        ByteBuffer result = ByteBuffer.allocate(buffer.remaining());
        if (blocks > 1) {
            i = 0;
            while (result.remaining() > 16) {
                result.put((byte)(buffer.get() ^ cipher[16 + i]));
                ++i;
            }
        }
        i = 0;
        while (result.hasRemaining()) {
            result.put((byte)(buffer.get() ^ cipher[i]));
            ++i;
        }
        return result.flip();
    }

    private static byte[] cipherStream(int blocks, Key secretKey, byte[] secInfo) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(1, secretKey);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        while (i < blocks) {
            byte[] output = cipher.update(secInfo);
            baos.write(output, 0, 16);
            secInfo[15] = (byte)(secInfo[15] + 1);
            ++i;
        }
        return baos.toByteArray();
    }

    static void cbcMacVerify(byte[] data, int offset, int length, Key secretKey, byte[] secInfo, byte[] verifyAgainst) {
        byte[] mac = SecureConnection.cbcMac(data, offset, length, secretKey, secInfo);
        boolean authenticated = Arrays.equals(mac, verifyAgainst);
        if (!authenticated) {
            String packet = DataUnitBuilder.toHex(Arrays.copyOfRange(data, offset, offset + length), " ");
            throw new KnxSecureException("authentication failed for " + packet);
        }
    }

    static byte[] cbcMac(byte[] data, int offset, int length, Key secretKey, byte[] secInfo) {
        byte[] log = Arrays.copyOfRange(data, offset, offset + length);
        byte[] hdr = Arrays.copyOfRange(data, offset, offset + 6);
        int packetOffset = hdr.length + 2 + 6 + 6 + 2;
        byte[] session = new byte[]{};
        byte[] frame = new byte[]{};
        if (length > packetOffset) {
            session = Arrays.copyOfRange(data, offset + 6, offset + 8);
            frame = Arrays.copyOfRange(data, offset + packetOffset, offset + length);
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            IvParameterSpec ivSpec = new IvParameterSpec(new byte[16]);
            cipher.init(1, secretKey, ivSpec);
            cipher.update(secInfo);
            byte[] byArray = new byte[2];
            byArray[1] = (byte)(hdr.length + session.length);
            byte[] lenBuf = byArray;
            cipher.update(lenBuf);
            cipher.update(hdr);
            cipher.update(session);
            int checkLength = 24 + session.length + frame.length;
            byte[] padded = Arrays.copyOfRange(frame, 0, frame.length + 15 - (checkLength + 15) % 16);
            byte[] result = cipher.doFinal(padded);
            byte[] mac = Arrays.copyOfRange(result, result.length - 16, result.length);
            return mac;
        }
        catch (GeneralSecurityException e) {
            throw new KnxSecureException("calculating CBC-MAC of " + DataUnitBuilder.toHex(log, " "), e);
        }
    }

    static byte[] securityInfo(byte[] data, int offset, int lengthInfo) {
        byte[] secInfo = Arrays.copyOfRange(data, offset, offset + 16);
        secInfo[14] = (byte)(lengthInfo >> 8);
        secInfo[15] = (byte)lengthInfo;
        return secInfo;
    }

    static String statusMsg(int status) {
        String[] msg = new String[]{"authorization success", "authorization failed", "unauthorized", "timeout", "keep-alive", "close"};
        if (status >= msg.length) {
            return "unknown status " + status;
        }
        return msg[status];
    }

    static SecretKey createSecretKey(byte[] key) {
        if (key.length != 16) {
            throw new KNXIllegalArgumentException("KNX key has to be 16 bytes in length");
        }
        SecretKeySpec spec = new SecretKeySpec(key, "AES");
        Arrays.fill(key, (byte)0);
        return spec;
    }

    static KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator gen = KeyPairGenerator.getInstance("X25519");
        return gen.generateKeyPair();
    }

    static byte[] keyAgreement(PrivateKey privateKey, byte[] spk) {
        try {
            byte[] reversed = (byte[])spk.clone();
            SecureConnection.reverse(reversed);
            XECPublicKeySpec spec = new XECPublicKeySpec(NamedParameterSpec.X25519, new BigInteger(1, reversed));
            PublicKey pubKey = KeyFactory.getInstance("X25519").generatePublic(spec);
            KeyAgreement ka = KeyAgreement.getInstance("X25519");
            ka.init(privateKey);
            ka.doPhase(pubKey, true);
            return ka.generateSecret();
        }
        catch (GeneralSecurityException e) {
            throw new KnxSecureException("key agreement failed", e);
        }
    }

    static byte[] sessionKey(byte[] sharedSecret) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(sharedSecret);
            return Arrays.copyOfRange(hash, 0, 16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KnxSecureException("platform does not support SHA-256 algorithm", e);
        }
    }

    static byte[] xor(byte[] a, int offsetA, byte[] b, int offsetB, int len) {
        if (a.length - len < offsetA || b.length - len < offsetB) {
            throw new KNXIllegalArgumentException("illegal offset or length");
        }
        byte[] res = new byte[len];
        int i = 0;
        while (i < len) {
            res[i] = (byte)(a[i + offsetA] ^ b[i + offsetB]);
            ++i;
        }
        return res;
    }

    static void reverse(byte[] array) {
        int i = 0;
        while (i < array.length / 2) {
            byte b = array[i];
            array[i] = array[array.length - 1 - i];
            array[array.length - 1 - i] = b;
            ++i;
        }
    }

    private static long uint48(ByteBuffer buffer) {
        long l = ((long)buffer.getShort() & 0xFFFFL) << 32;
        return l |= (long)buffer.getInt() & 0xFFFFFFFFL;
    }
}

