/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip;

import java.io.IOException;
import java.net.InetSocketAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.knxnetip.KNXnetIPDevMgmt;
import tuwien.auto.calimero.knxnetip.Net;
import tuwien.auto.calimero.knxnetip.SecureConnection;
import tuwien.auto.calimero.knxnetip.TcpConnection;
import tuwien.auto.calimero.knxnetip.util.CRI;

final class SecureDeviceManagement
extends KNXnetIPDevMgmt {
    private final TcpConnection.SecureSession session;

    SecureDeviceManagement(TcpConnection.SecureSession session) throws KNXException, InterruptedException {
        super(session.connection());
        this.session = session;
        session.registerConnectRequest(this);
        try {
            CRI cri = CRI.createRequest(3, new byte[0]);
            super.connect(session.connection().localEndpoint(), session.connection().server(), cri, false);
        }
        finally {
            session.unregisterConnectRequest(this);
        }
    }

    @Override
    public String name() {
        return "KNX IP " + SecureConnection.secureSymbol + " Management " + Net.hostPort(this.ctrlEndpt);
    }

    @Override
    protected void connect(TcpConnection c, CRI cri) {
    }

    @Override
    protected void send(byte[] packet, InetSocketAddress dst) throws IOException {
        byte[] wrapped = SecureConnection.newSecurePacket(this.session.id(), this.session.nextSendSeq(), this.session.serialNumber(), 0, packet, this.session.secretKey);
        super.send(wrapped, dst);
    }
}

