/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.security.Key;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.knxnetip.KNXnetIPRouting;
import tuwien.auto.calimero.knxnetip.Net;
import tuwien.auto.calimero.knxnetip.SecureConnection;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.secure.KnxSecureException;

final class SecureRouting
extends KNXnetIPRouting {
    private static final int SecureGroupSync = 2389;
    private final SerialNumber sno;
    private final Key secretKey;
    private final int mcastLatencyTolerance;
    private final int syncLatencyTolerance;
    private final AtomicInteger routingCount = new AtomicInteger();
    private long timestampOffset = -System.nanoTime() / 1000000L;
    private volatile boolean syncedWithGroup;
    private volatile int sentGroupSyncTag;
    private static final int syncQueryInterval = 10000;
    private static final int minDelayTimeKeeperUpdateNotify = 100;
    private int minDelayUpdateNotify;
    private int maxDelayUpdateNotify;
    private int minDelayPeriodicNotify;
    private int maxDelayPeriodicNotify;
    private volatile boolean periodicSchedule = true;
    private SerialNumber timerNotifySN;
    private int timerNotifyTag;
    private Future<?> groupSync = CompletableFuture.completedFuture(Void.TYPE);
    private static final ScheduledThreadPoolExecutor groupSyncSender = new ScheduledThreadPoolExecutor(1, r -> {
        Thread t = new Thread(r);
        t.setName("KNX/IP secure group sync");
        t.setDaemon(true);
        return t;
    });

    static {
        groupSyncSender.setKeepAliveTime(30L, TimeUnit.SECONDS);
        groupSyncSender.allowCoreThreadTimeOut(true);
        groupSyncSender.setRemoveOnCancelPolicy(true);
    }

    SecureRouting(NetworkInterface netif, InetAddress mcGroup, byte[] groupKey, Duration latencyTolerance) throws KNXException {
        super(mcGroup);
        this.sno = SecureRouting.deriveSerialNumber(netif);
        this.secretKey = SecureConnection.createSecretKey(groupKey);
        this.mcastLatencyTolerance = (int)latencyTolerance.toMillis();
        this.syncLatencyTolerance = this.mcastLatencyTolerance / 10;
        this.init(netif, true, true);
        this.scheduleGroupSync(0L);
        try {
            this.awaitGroupSync();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private static SerialNumber deriveSerialNumber(NetworkInterface netif) {
        try {
            byte[] hardwareAddress;
            if (netif != null && (hardwareAddress = netif.getHardwareAddress()) != null) {
                return SerialNumber.from(Arrays.copyOf(hardwareAddress, 6));
            }
        }
        catch (SocketException socketException) {}
        return SerialNumber.Zero;
    }

    @Override
    public String name() {
        return "KNX/IP " + SecureConnection.secureSymbol + " Routing " + this.ctrlEndpt.getAddress().getHostAddress();
    }

    @Override
    public String toString() {
        return this.name();
    }

    @Override
    protected void send(byte[] packet, InetSocketAddress dst) throws IOException {
        int tag = this.routingCount.getAndIncrement() % 65536;
        byte[] wrapped = this.newSecurePacket(this.timestamp(), tag, packet);
        this.channel().send(ByteBuffer.wrap(wrapped), dst);
        this.scheduleGroupSync(this.periodicNotifyDelay());
    }

    @Override
    protected boolean handleServiceType(KNXnetIPHeader h, byte[] data, int offset, InetAddress src, int port) throws KNXFormatException, IOException {
        int svc = h.getServiceType();
        if (!h.isSecure()) {
            this.logger.trace("received insecure service type 0x{} - ignore", (Object)Integer.toHexString(svc));
            return true;
        }
        if (svc == 2389) {
            try {
                Object[] fields = this.newGroupSync(h, data, offset);
                this.onGroupSync(src, (Long)fields[0], true, (SerialNumber)fields[1], (Integer)fields[2]);
            }
            catch (KnxSecureException e) {
                this.logger.debug("group sync {}", (Object)e.getMessage());
                return true;
            }
        } else {
            if (svc == 2384) {
                Object[] fields = this.unwrap(h, data, offset);
                long timestamp = (Long)fields[1];
                if (!this.withinTolerance(src, timestamp, (SerialNumber)fields[2], (Integer)fields[3])) {
                    InetSocketAddress source = new InetSocketAddress(src, port);
                    this.logger.warn("{} timestamp {} outside latency tolerance of {} ms (local {}) - ignore", new Object[]{Net.hostPort(source), timestamp, this.mcastLatencyTolerance, this.timestamp()});
                    return true;
                }
                byte[] packet = (byte[])fields[4];
                KNXnetIPHeader containedHeader = new KNXnetIPHeader(packet, 0);
                return super.handleServiceType(containedHeader, packet, containedHeader.getStructLength(), src, port);
            }
            this.logger.warn("received unsupported secure service type 0x{} - ignore", (Object)Integer.toHexString(svc));
        }
        return true;
    }

    @Override
    protected void close(int initiator, String reason, LogService.LogLevel level, Throwable t) {
        this.groupSync.cancel(true);
        super.close(initiator, reason, level, t);
    }

    private boolean withinTolerance(InetAddress src, long timestamp, SerialNumber sn, int tag) {
        this.onGroupSync(src, timestamp, false, sn, tag);
        long diff = this.timestamp() - timestamp;
        return diff <= (long)this.mcastLatencyTolerance;
    }

    private void onGroupSync(InetAddress src, long timestamp, boolean byTimerNotify, SerialNumber sn, int tag) {
        long local = this.timestamp();
        if (timestamp > local) {
            this.logger.debug("sync timestamp +{} ms", (Object)(timestamp - local));
            this.timestampOffset += timestamp - local;
            this.syncedWithGroup(byTimerNotify, sn, tag);
        } else if (timestamp > local - (long)this.syncLatencyTolerance) {
            if (tag != this.sentGroupSyncTag || !this.isLocalIpAddress(src)) {
                this.syncedWithGroup(byTimerNotify, sn, tag);
            }
        } else if (timestamp <= local - (long)this.mcastLatencyTolerance && this.periodicSchedule) {
            this.timerNotifySN = sn;
            this.timerNotifyTag = tag;
            this.periodicSchedule = false;
            this.scheduleGroupSync(SecureRouting.randomClosedRange(this.minDelayUpdateNotify, this.maxDelayUpdateNotify));
        }
    }

    private synchronized void becomeTimeFollower() {
        int maxDelayTimeKeeperUpdateNotify = 100 + 1 * this.syncLatencyTolerance;
        int maxDelayTimeKeeperPeriodicNotify = 10000 + 3 * this.syncLatencyTolerance;
        int minDelayTimeFollowerUpdateNotify = maxDelayTimeKeeperUpdateNotify + 1 * this.syncLatencyTolerance;
        int maxDelayTimeFollowerUpdateNotify = minDelayTimeFollowerUpdateNotify + 10 * this.syncLatencyTolerance;
        int minDelayTimeFollowerPeriodicNotify = maxDelayTimeKeeperPeriodicNotify + 1 * this.syncLatencyTolerance;
        int maxDelayTimeFollowerPeriodicNotify = minDelayTimeFollowerPeriodicNotify + 10 * this.syncLatencyTolerance;
        this.minDelayUpdateNotify = minDelayTimeFollowerUpdateNotify;
        this.maxDelayUpdateNotify = maxDelayTimeFollowerUpdateNotify;
        this.minDelayPeriodicNotify = minDelayTimeFollowerPeriodicNotify;
        this.maxDelayPeriodicNotify = maxDelayTimeFollowerPeriodicNotify;
    }

    private synchronized void becomeTimeKeeper() {
        int maxDelayTimeKeeperUpdateNotify = 100 + 1 * this.syncLatencyTolerance;
        int maxDelayTimeKeeperPeriodicNotify = 10000 + 3 * this.syncLatencyTolerance;
        this.minDelayUpdateNotify = 100;
        this.maxDelayUpdateNotify = maxDelayTimeKeeperUpdateNotify;
        this.minDelayPeriodicNotify = 10000;
        this.maxDelayPeriodicNotify = maxDelayTimeKeeperPeriodicNotify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncedWithGroup(boolean byTimerNotify, SerialNumber sn, int tag) {
        if (byTimerNotify) {
            this.becomeTimeFollower();
        }
        this.scheduleGroupSync(this.periodicNotifyDelay());
        if (!this.syncedWithGroup && tag == this.sentGroupSyncTag && this.sno.equals(sn)) {
            this.logger.info("synchronized with group {}", (Object)this.getRemoteAddress().getAddress().getHostAddress());
            this.syncedWithGroup = true;
            SecureRouting secureRouting = this;
            synchronized (secureRouting) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitGroupSync() throws InterruptedException {
        long wait = 2 * this.mcastLatencyTolerance + 100 + 12 * this.syncLatencyTolerance;
        long end = System.nanoTime() / 1000000L + wait;
        long remaining = wait;
        while (remaining > 0L && !this.syncedWithGroup) {
            SecureRouting secureRouting = this;
            synchronized (secureRouting) {
                this.wait(remaining);
            }
            remaining = end - System.nanoTime() / 1000000L;
        }
        this.syncedWithGroup = true;
        this.logger.trace("waited {} ms for group sync", (Object)(wait - remaining));
    }

    private boolean isLocalIpAddress(InetAddress addr) {
        Stream<NetworkInterface> netifs;
        block3: {
            netifs = Stream.empty();
            InetAddress local = ((InetSocketAddress)this.channel().getLocalAddress()).getAddress();
            if (!addr.equals(local)) break block3;
            return true;
        }
        try {
            NetworkInterface ni2 = this.channel().getOption(StandardSocketOptions.IP_MULTICAST_IF);
            boolean noneSet = ni2 == null || ni2.getInetAddresses().nextElement().isAnyLocalAddress();
            netifs = noneSet ? NetworkInterface.networkInterfaces() : Stream.of(ni2);
        }
        catch (IOException iOException) {
        }
        return netifs.flatMap(ni -> ni.inetAddresses()).anyMatch(addr::equals);
    }

    private void scheduleGroupSync(long initialDelay) {
        this.logger.trace("schedule group sync (initial delay {} ms)", (Object)initialDelay);
        this.groupSync.cancel(false);
        this.groupSync = groupSyncSender.scheduleWithFixedDelay(this::sendGroupSync, initialDelay, 10000L, TimeUnit.MILLISECONDS);
    }

    private void sendGroupSync() {
        try {
            long timestamp = this.timestamp();
            byte[] sync = this.newGroupSync(timestamp);
            this.logger.debug("sending group sync timestamp {} ms (S/N {}, tag {})", new Object[]{timestamp, this.periodicSchedule ? this.sno : this.timerNotifySN, this.periodicSchedule ? this.sentGroupSyncTag : this.timerNotifyTag});
            this.becomeTimeKeeper();
            this.scheduleGroupSync(this.periodicNotifyDelay());
            this.channel().send(ByteBuffer.wrap(sync), this.dataEndpt);
        }
        catch (IOException | RuntimeException e) {
            if (!this.channel().isOpen()) {
                this.groupSync.cancel(true);
                throw new CancellationException("stop group sync for " + this);
            }
            this.logger.warn("sending group sync failed", (Throwable)e);
        }
    }

    private long timestamp() {
        long now = System.nanoTime() / 1000000L;
        return now + this.timestampOffset;
    }

    private synchronized int periodicNotifyDelay() {
        this.periodicSchedule = true;
        return SecureRouting.randomClosedRange(this.minDelayPeriodicNotify, this.maxDelayPeriodicNotify);
    }

    private static int randomClosedRange(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }

    private byte[] newSecurePacket(long seq, int msgTag, byte[] knxipPacket) {
        return SecureConnection.newSecurePacket(0L, seq, this.sno, msgTag, knxipPacket, this.secretKey);
    }

    private Object[] unwrap(KNXnetIPHeader h, byte[] data, int offset) throws KNXFormatException {
        return this.unwrap(h, data, offset, 0, this.secretKey);
    }

    private Object[] unwrap(KNXnetIPHeader h, byte[] data, int offset, int sessionId, Key secretKey) throws KNXFormatException {
        Object[] fields = SecureConnection.unwrap(h, data, offset, secretKey);
        int sid = (Integer)fields[0];
        if (sid != 0) {
            throw new KnxSecureException("secure session mismatch: received ID " + sid + ", expected 0");
        }
        long seq = (Long)fields[1];
        SerialNumber sn = (SerialNumber)fields[2];
        int tag = (Integer)fields[3];
        byte[] knxipPacket = (byte[])fields[4];
        this.logger.trace("received {} (session {} seq {} S/N {} tag {})", new Object[]{DataUnitBuilder.toHex(knxipPacket, " "), sid, seq, sn, tag});
        return new Object[]{fields[0], fields[1], sn, fields[3], fields[4]};
    }

    private byte[] newGroupSync(long timestamp) {
        if (timestamp < 0L || timestamp > 0xFFFFFFFFFFFFL) {
            throw new KNXIllegalArgumentException("timestamp " + timestamp + " out of range [0..0xffffffffffff]");
        }
        KNXnetIPHeader header = new KNXnetIPHeader(2389, 30);
        ByteBuffer buffer = ByteBuffer.allocate(header.getTotalLength());
        buffer.put(header.toByteArray());
        buffer.putShort((short)(timestamp >> 32)).putInt((int)timestamp);
        if (this.periodicSchedule) {
            this.sentGroupSyncTag = SecureRouting.randomClosedRange(1, 65535);
            buffer.put(this.sno.array()).putShort((short)this.sentGroupSyncTag);
        } else {
            buffer.put(this.timerNotifySN.array()).putShort((short)this.timerNotifyTag);
        }
        byte[] mac = this.cbcMac(buffer.array(), 0, header.getStructLength() + 6 + 6 + 2, SecureConnection.securityInfo(buffer.array(), 6, 0));
        byte[] secInfo = SecureConnection.securityInfo(buffer.array(), 6, 65280);
        this.encrypt(mac, 0, secInfo);
        buffer.put(mac);
        return buffer.array();
    }

    private Object[] newGroupSync(KNXnetIPHeader h, byte[] data, int offset) throws KNXFormatException {
        if (h.getTotalLength() != 36) {
            throw new KNXFormatException("invalid length " + data.length + " for a secure group sync");
        }
        ByteBuffer buffer = ByteBuffer.wrap(data, offset, h.getTotalLength() - h.getStructLength());
        long timestamp = SecureRouting.uint48(buffer);
        byte[] sn = new byte[6];
        buffer.get(sn);
        int msgTag = buffer.getShort() & 0xFFFF;
        ByteBuffer mac = this.decrypt(buffer, SecureConnection.securityInfo(data, offset, 65280));
        byte[] secInfo = SecureConnection.securityInfo(buffer.array(), 6, 0);
        SecureConnection.cbcMacVerify(data, offset - h.getStructLength(), h.getTotalLength() - 16, this.secretKey, secInfo, mac.array());
        this.logger.trace("received group sync timestamp {} ms (S/N {}, tag {})", new Object[]{timestamp, DataUnitBuilder.toHex(sn, ""), msgTag});
        return new Object[]{timestamp, SerialNumber.from(sn), msgTag};
    }

    private void encrypt(byte[] data, int offset, byte[] secInfo) {
        SecureConnection.encrypt(data, offset, this.secretKey, secInfo);
    }

    private ByteBuffer decrypt(ByteBuffer buffer, byte[] secInfo) {
        return SecureConnection.decrypt(buffer, this.secretKey, secInfo);
    }

    private byte[] cbcMac(byte[] data, int offset, int length, byte[] secInfo) {
        return SecureConnection.cbcMac(data, offset, length, this.secretKey, secInfo);
    }

    private static long uint48(ByteBuffer buffer) {
        long l = ((long)buffer.getShort() & 0xFFFFL) << 32;
        return l |= (long)buffer.getInt() & 0xFFFFFFFFL;
    }
}

