/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip;

import java.io.IOException;
import java.math.BigInteger;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.interfaces.XECPublicKey;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.knxnetip.ClientConnection;
import tuwien.auto.calimero.knxnetip.Net;
import tuwien.auto.calimero.knxnetip.ReceiverLoop;
import tuwien.auto.calimero.knxnetip.SecureConnection;
import tuwien.auto.calimero.knxnetip.TcpConnection;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.knxnetip.servicetype.PacketHelper;
import tuwien.auto.calimero.knxnetip.util.HPAI;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.secure.KnxSecureException;

final class SecureSessionUdp {
    private static final int sessionSetupTimeout = 10000;
    private static final int AuthSuccess = 0;
    private static final int AuthFailed = 1;
    private static final int Setup = 6;
    private final TcpConnection.SecureSession session;
    private final Logger logger;
    private Key secretKey;
    private PrivateKey privateKey;
    private final byte[] publicKey = new byte[32];
    private int sessionId;
    private volatile int sessionStatus = 6;
    private DatagramSocket localSocket;
    private ReceiverLoop setupLoop;

    SecureSessionUdp(int userId, byte[] userKey, byte[] deviceAuthCode, InetSocketAddress serverCtrlEP) {
        this.session = TcpConnection.Udp.newSecureSession(userId, userKey, deviceAuthCode);
        this.logger = LoggerFactory.getLogger((String)("calimero.knxnetip.KNX/IP " + SecureConnection.secureSymbol + " Session " + Net.hostPort(serverCtrlEP)));
    }

    void setupSecureSession(ClientConnection conn, InetSocketAddress localEP, InetSocketAddress serverCtrlEP, boolean useNat) throws KNXException {
        this.logger.debug("setup secure session with {}", (Object)serverCtrlEP);
        try {
            KeyPair keyPair = SecureConnection.generateKeyPair();
            this.privateKey = keyPair.getPrivate();
            BigInteger u = ((XECPublicKey)keyPair.getPublic()).getU();
            byte[] tmp = u.toByteArray();
            SecureConnection.reverse(tmp);
            System.arraycopy(tmp, 0, this.publicKey, 0, tmp.length);
        }
        catch (Throwable e) {
            throw new KnxSecureException("error creating secure key pair for " + serverCtrlEP, e);
        }
        try {
            try {
                e = null;
                Object var6_9 = null;
                try (DatagramSocket local = new DatagramSocket(localEP);){
                    this.localSocket = local;
                    HPAI hpai = new HPAI(1, useNat ? null : (InetSocketAddress)local.getLocalSocketAddress());
                    byte[] sessionReq = PacketHelper.newChannelRequest(hpai, this.publicKey);
                    local.send(new DatagramPacket(sessionReq, sessionReq.length, serverCtrlEP));
                    this.setupLoop = new ReceiverLoop(conn, local, 512, 0, 10000);
                    this.setupLoop.run();
                    if (this.sessionStatus == 6) {
                        throw new KNXTimeoutException("timeout establishing secure session with " + serverCtrlEP);
                    }
                    if (this.sessionStatus != 0) {
                        throw new KnxSecureException("secure session " + SecureConnection.statusMsg(this.sessionStatus));
                    }
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                throw new KNXException("I/O error establishing secure session with " + serverCtrlEP, e);
            }
        }
        finally {
            Arrays.fill(this.publicKey, (byte)0);
        }
    }

    void sessionAuth(KNXnetIPHeader h, byte[] data, int offset, InetSocketAddress source) throws KNXFormatException, IOException {
        try {
            Object[] res = this.newSessionResponse(h, data, offset, source);
            byte[] serverPublicKey = (byte[])res[1];
            byte[] auth = this.newSessionAuth(serverPublicKey);
            byte[] packet = this.newSecurePacket(auth);
            this.logger.debug("secure session {}, request access for user {}", (Object)this.sessionId, (Object)this.session.user());
            this.localSocket.send(new DatagramPacket(packet, packet.length, source));
        }
        catch (RuntimeException e) {
            this.sessionStatus = 1;
            this.quitSetupLoop();
            this.logger.error("negotiating session key failed", (Throwable)e);
        }
    }

    Object[] newSessionResponse(KNXnetIPHeader h, byte[] data, int offset, InetSocketAddress src) throws KNXFormatException {
        if (h.getServiceType() != 2386) {
            throw new KNXIllegalArgumentException("no secure channel response");
        }
        if (h.getTotalLength() != 56 && h.getTotalLength() != 8) {
            throw new KNXFormatException("invalid length " + data.length + " for a secure channel response");
        }
        ByteBuffer buffer = ByteBuffer.wrap(data, offset, h.getTotalLength() - h.getStructLength());
        this.sessionId = buffer.getShort() & 0xFFFF;
        if (this.sessionId == 0) {
            throw new KnxSecureException("no more free secure channels / remote endpoint busy");
        }
        byte[] serverPublicKey = new byte[32];
        buffer.get(serverPublicKey);
        byte[] sharedSecret = SecureConnection.keyAgreement(this.privateKey, serverPublicKey);
        byte[] sessionKey = SecureConnection.sessionKey(sharedSecret);
        this.secretKey = SecureConnection.createSecretKey(sessionKey);
        boolean skipDeviceAuth = Arrays.equals(this.session.deviceAuthKey().getEncoded(), new byte[16]);
        if (skipDeviceAuth) {
            this.logger.warn("skipping device authentication of {} (no device key)", (Object)Net.hostPort(src));
        } else {
            ByteBuffer mac = SecureConnection.decrypt(buffer, this.session.deviceAuthKey(), SecureConnection.securityInfo(new byte[16], 0, 65280));
            int msgLen = h.getStructLength() + 2 + 32;
            ByteBuffer macInput = ByteBuffer.allocate(18 + msgLen);
            macInput.put(new byte[16]);
            macInput.put((byte)0);
            macInput.put((byte)msgLen);
            macInput.put(h.toByteArray());
            macInput.putShort((short)this.sessionId);
            macInput.put(SecureConnection.xor(serverPublicKey, 0, this.publicKey, 0, 32));
            byte[] verifyAgainst = this.cbcMacSimple(this.session.deviceAuthKey(), macInput.array(), 0, macInput.capacity());
            boolean authenticated = Arrays.equals(mac.array(), verifyAgainst);
            if (!authenticated) {
                String packet = DataUnitBuilder.toHex(Arrays.copyOfRange(data, offset - 6, offset - 6 + 56), " ");
                throw new KnxSecureException("authentication failed for session response " + packet);
            }
        }
        return new Object[]{this.sessionId, serverPublicKey};
    }

    byte[] newSessionAuth(byte[] serverPublicKey) {
        KNXnetIPHeader header = new KNXnetIPHeader(2387, 18);
        ByteBuffer buffer = ByteBuffer.allocate(header.getTotalLength());
        buffer.put(header.toByteArray());
        buffer.putShort((short)this.session.user());
        ByteBuffer macInput = ByteBuffer.allocate(58);
        macInput.put(new byte[16]);
        macInput.put((byte)0);
        macInput.put((byte)40);
        macInput.put(buffer.array(), 0, buffer.position());
        macInput.put(SecureConnection.xor(serverPublicKey, 0, this.publicKey, 0, 32));
        byte[] mac = this.cbcMacSimple(this.session.userKey(), macInput.array(), 0, macInput.capacity());
        SecureConnection.encrypt(mac, 0, this.session.userKey(), SecureConnection.securityInfo(new byte[16], 8, 65280));
        buffer.put(mac);
        return buffer.array();
    }

    void sessionStatus(byte[] packet, KNXnetIPHeader containedHeader) throws KNXFormatException {
        int status = TcpConnection.SecureSession.newChannelStatus(containedHeader, packet, containedHeader.getStructLength());
        LogService.log(this.logger, status == 0 ? LogService.LogLevel.TRACE : LogService.LogLevel.ERROR, "{}: {}", this, SecureConnection.statusMsg(status));
        this.quitSetupLoop();
        this.sessionStatus = status;
    }

    byte[] newSecurePacket(byte[] knxipPacket) {
        return SecureConnection.newSecurePacket(this.sessionId, this.session.nextSendSeq(), this.session.serialNumber(), 0, knxipPacket, this.secretKey);
    }

    Object[] unwrap(KNXnetIPHeader h, byte[] data, int offset) throws KNXFormatException {
        long rcvSeq;
        Object[] fields = SecureConnection.unwrap(h, data, offset, this.secretKey);
        int sid = (Integer)fields[0];
        if (sid != this.sessionId) {
            throw new KnxSecureException("secure session mismatch: received ID " + sid + ", expected " + this.sessionId);
        }
        long seq = (Long)fields[1];
        if (seq < (rcvSeq = this.session.nextReceiveSeq())) {
            throw new KnxSecureException("received secure packet with sequence " + seq + " < expected " + rcvSeq);
        }
        SerialNumber sn = (SerialNumber)fields[2];
        int tag = (Integer)fields[3];
        byte[] knxipPacket = (byte[])fields[4];
        this.logger.trace("received {} (session {} seq {} S/N {} tag {})", new Object[]{DataUnitBuilder.toHex(knxipPacket, " "), sid, seq, sn, tag});
        return new Object[]{fields[0], fields[1], sn, fields[3], fields[4]};
    }

    public String toString() {
        return String.valueOf(SecureConnection.secureSymbol) + " session " + this.sessionId + " (user " + this.session.user() + ")";
    }

    private void quitSetupLoop() {
        this.setupLoop.quit();
    }

    private byte[] cbcMacSimple(Key secretKey, byte[] data, int offset, int length) {
        byte[] exact = Arrays.copyOfRange(data, offset, offset + length);
        this.logger.trace("authenticating (length {}): {}", (Object)length, (Object)DataUnitBuilder.toHex(exact, " "));
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            IvParameterSpec ivSpec = new IvParameterSpec(new byte[16]);
            cipher.init(1, secretKey, ivSpec);
            byte[] padded = Arrays.copyOfRange(exact, 0, (length + 15) / 16 * 16);
            byte[] result = cipher.doFinal(padded);
            byte[] mac = Arrays.copyOfRange(result, result.length - 16, result.length);
            return mac;
        }
        catch (GeneralSecurityException e) {
            throw new KnxSecureException("calculating CBC-MAC of " + DataUnitBuilder.toHex(exact, " "), e);
        }
    }
}

