/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.knxnetip;

import java.io.IOException;
import java.net.InetSocketAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.knxnetip.KNXnetIPTunnel;
import tuwien.auto.calimero.knxnetip.Net;
import tuwien.auto.calimero.knxnetip.SecureConnection;
import tuwien.auto.calimero.knxnetip.TcpConnection;
import tuwien.auto.calimero.knxnetip.util.CRI;
import tuwien.auto.calimero.knxnetip.util.TunnelCRI;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;

final class SecureTunnel
extends KNXnetIPTunnel {
    private final TcpConnection.SecureSession session;

    SecureTunnel(TcpConnection.SecureSession session, KNXnetIPTunnel.TunnelingLayer knxLayer, IndividualAddress tunnelingAddress) throws KNXException, InterruptedException {
        super(knxLayer, session.connection(), tunnelingAddress);
        this.session = session;
        TunnelCRI cri = tunnelingAddress.equals(KNXMediumSettings.BackboneRouter) ? new TunnelCRI(knxLayer) : new TunnelCRI(knxLayer, tunnelingAddress);
        session.registerConnectRequest(this);
        try {
            super.connect(session.connection().localEndpoint(), session.connection().server(), cri, false);
        }
        finally {
            session.unregisterConnectRequest(this);
        }
    }

    @Override
    public String name() {
        return "KNX IP " + SecureConnection.secureSymbol + " Tunneling " + Net.hostPort(this.ctrlEndpt);
    }

    @Override
    protected void connect(TcpConnection c, CRI cri) {
    }

    @Override
    protected void send(byte[] packet, InetSocketAddress dst) throws IOException {
        byte[] wrapped = SecureConnection.newSecurePacket(this.session.id(), this.session.nextSendSeq(), this.session.serialNumber(), 0, packet, this.session.secretKey);
        super.send(wrapped, dst);
    }
}

